# MRC 評估量表 - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "MRCQuestionnaireInstance",
  "meta" : {
    "profile" : [
      "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/SPACQuestionnaire"
    ]
  },
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/MRCQuestionnaireInstance",
  "version" : "0.1.0",
  "title" : "MRC 評估量表",
  "status" : "active",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "MRC肌力測試 (Medical Research Council Scale)",
  "item" : [
    {
      "linkId" : "abduction-arm",
      "text" : "肩關節外展",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueInteger" : 0
        },
        {
          "valueInteger" : 1
        },
        {
          "valueInteger" : 2
        },
        {
          "valueInteger" : 3
        },
        {
          "valueInteger" : 4
        },
        {
          "valueInteger" : 5
        }
      ]
    },
    {
      "linkId" : "flexion-forearm",
      "text" : "前臂屈曲",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueInteger" : 0
        },
        {
          "valueInteger" : 1
        },
        {
          "valueInteger" : 2
        },
        {
          "valueInteger" : 3
        },
        {
          "valueInteger" : 4
        },
        {
          "valueInteger" : 5
        }
      ]
    },
    {
      "linkId" : "extension-wrist",
      "text" : "手腕向上伸張",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueInteger" : 0
        },
        {
          "valueInteger" : 1
        },
        {
          "valueInteger" : 2
        },
        {
          "valueInteger" : 3
        },
        {
          "valueInteger" : 4
        },
        {
          "valueInteger" : 5
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%resource.item.descendants().where(type='choice').answer.valueInteger.sum()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
          "valueBoolean" : true
        }
      ],
      "linkId" : "mrc-total-score",
      "text" : "MRC總分",
      "type" : "integer",
      "readOnly" : true
    }
  ]
}

```
