# MMSE評估量表 - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "MMSEQuestionnaireInstance",
  "meta" : {
    "profile" : [
      "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/SPACQuestionnaire"
    ]
  },
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/MMSEQuestionnaireInstance",
  "version" : "0.1.0",
  "title" : "MMSE評估量表",
  "status" : "active",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "簡易心智狀況檢查表 (Mini-Mental State Examination, MMSE)",
  "item" : [
    {
      "linkId" : "section-a-time",
      "text" : "一、定向感-時間(5分)",
      "type" : "group",
      "item" : [
        {
          "linkId" : "a-1-year",
          "text" : "現在是：民國幾年？",
          "type" : "integer"
        },
        {
          "linkId" : "a-1-year-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        },
        {
          "linkId" : "a-2-month",
          "text" : "現在是：幾月？",
          "type" : "integer"
        },
        {
          "linkId" : "a-2-month-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        },
        {
          "linkId" : "a-3-date",
          "text" : "現在是：幾號？",
          "type" : "integer"
        },
        {
          "linkId" : "a-3-date-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        },
        {
          "linkId" : "a-4-week",
          "text" : "現在是：星期幾？",
          "type" : "string"
        },
        {
          "linkId" : "a-4-week-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        },
        {
          "linkId" : "a-5-season",
          "text" : "現在是：甚麼季節？",
          "type" : "string"
        },
        {
          "linkId" : "a-5-season-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        }
      ]
    },
    {
      "linkId" : "section-b-place",
      "text" : "二、定向感-地方(5分)",
      "type" : "group",
      "item" : [
        {
          "linkId" : "b-1-city",
          "text" : "這裡是:甚麼縣市？",
          "type" : "string"
        },
        {
          "linkId" : "b-1-city-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        },
        {
          "linkId" : "b-2-loc",
          "text" : "這裡是：在台灣的東部、西部、中部、南部或北部？",
          "type" : "string"
        },
        {
          "linkId" : "b-2-loc-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        },
        {
          "linkId" : "b-3-hos",
          "text" : "這裡是：什麼醫院？",
          "type" : "string"
        },
        {
          "linkId" : "b-3-hos-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        },
        {
          "linkId" : "b-4-floor",
          "text" : "這裡是：幾樓？",
          "type" : "string"
        },
        {
          "linkId" : "b-4-floor-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        },
        {
          "linkId" : "b-5-number",
          "text" : "這裡是：您住在哪一個病房？",
          "type" : "string"
        },
        {
          "linkId" : "b-5-number-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 0
            }
          ]
        }
      ]
    },
    {
      "linkId" : "section-c-memory",
      "text" : "三、記憶力(5分)",
      "type" : "group",
      "item" : [
        {
          "linkId" : "c-item",
          "text" : "告訴病人三種東西(香蕉、桌子、火車)(一次唸完)並請他重複這三種東西的名字，每說出一個算一分，共三分。重複___次記住",
          "type" : "integer"
        },
        {
          "linkId" : "c-item-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        }
      ]
    },
    {
      "linkId" : "section-d-language",
      "text" : "四、語言(5分)",
      "type" : "group",
      "item" : [
        {
          "linkId" : "d-cal",
          "text" : "連續從100 減7，再由所回答數字減7；直到有五個答案為止，每算對一個給一分，共五分。 或將 3 、9、2、7、5 順序倒過來唸，每排對一個給一分(用於原本不擅計算者)。",
          "type" : "display"
        },
        {
          "linkId" : "d-cal-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            },
            {
              "valueInteger" : 4
            },
            {
              "valueInteger" : 5
            }
          ]
        }
      ]
    },
    {
      "linkId" : "section-e-oral",
      "text" : "五、口語理解及行為能力(10分)",
      "type" : "group",
      "item" : [
        {
          "linkId" : "e-1-rep",
          "text" : "要求他將第三題之三種東西再說一次(自己不先重複)。",
          "type" : "display"
        },
        {
          "linkId" : "e-1-rep-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "e-2-stuff",
          "text" : "指著鉛筆和手錶問病人：這是什麼東西？(答對一個一分)",
          "type" : "display"
        },
        {
          "linkId" : "e-2-stuff-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            }
          ]
        },
        {
          "linkId" : "e-3-phrase",
          "text" : "請病人重複以下這句話『種瓜得瓜、種豆得豆』(國語)。 『人死留名、虎死留皮』(閩南語)。",
          "type" : "display"
        },
        {
          "linkId" : "e-3-phrase-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            }
          ]
        },
        {
          "linkId" : "e-4-fold",
          "text" : "連續給病人三個口令：用右或左(好)手拿紙、將紙對摺成一半、再將紙放到桌上(命令全說完後再讓他做，每完成一個給一分)。",
          "type" : "display"
        },
        {
          "linkId" : "e-4-fold-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "e-5-sen",
          "text" : "請您隨意寫一個句子(用另一張空白的紙)或說一句話(用於不識字者)。",
          "type" : "display"
        },
        {
          "linkId" : "e-5-sen-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            }
          ]
        }
      ]
    },
    {
      "linkId" : "section-f-build",
      "text" : "六、建構力(2分)",
      "type" : "group",
      "item" : [
        {
          "linkId" : "f-1-paper",
          "text" : "讓病人讀而且按照下列的指式做動作(印於另一張紙)。",
          "type" : "display"
        },
        {
          "linkId" : "f-1-paper-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            }
          ]
        },
        {
          "linkId" : "f-2-draw",
          "text" : "請病人把下面的圖形(印於另一張紙)再畫一次(用另一張空白的紙)。",
          "type" : "display"
        },
        {
          "linkId" : "f-2-draw-score",
          "text" : "得分",
          "type" : "choice",
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            }
          ]
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
          "valueBoolean" : true
        }
      ],
      "linkId" : "total-score-mmse",
      "text" : "總分（自動計算)",
      "type" : "integer",
      "readOnly" : true
    }
  ]
}

```
