# 巴氏量表 - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "BarthelQuestionnaireInstance",
  "meta" : {
    "profile" : [
      "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/SPACQuestionnaire"
    ]
  },
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/BarthelQuestionnaireInstance",
  "version" : "0.1.0",
  "title" : "巴氏量表",
  "status" : "active",
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "巴氏量表 (Barthel Index)",
  "item" : [
    {
      "linkId" : "A-feeding",
      "text" : "進食 (Feeding)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 10
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA12302-8",
            "display" : "Independent"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31630-9",
            "display" : "Needs help cutting, spreading butter, etc., or requires modified diet"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA24937-7",
            "display" : "Unable"
          }
        }
      ]
    },
    {
      "linkId" : "B-grooming",
      "text" : "個人衛生 (Grooming)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31644-0",
            "display" : "Independent face/hair/teeth/shaving (implements provided)"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31643-2",
            "display" : "Needs help with personal care"
          }
        }
      ]
    },
    {
      "linkId" : "C-toiletUse",
      "text" : "上廁所 (Toilet Use)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 10
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31632-5",
            "display" : "Independent (on and off, dressing, wiping)"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31631-7",
            "display" : "Needs some help, but can do something alone"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA12304-4",
            "display" : "Dependent"
          }
        }
      ]
    },
    {
      "linkId" : "D-bathing",
      "text" : "洗澡 (Bathing)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31636-6",
            "display" : "Independent (or in shower)"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA12304-4",
            "display" : "Dependent"
          }
        }
      ]
    },
    {
      "linkId" : "E-dressing",
      "text" : "穿脫衣服 (Dressing)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 10
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31638-2",
            "display" : "Independent (including buttons, zips, laces, etc.)"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31637-4",
            "display" : "Needs help but can do about half unaided"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA12304-4",
            "display" : "Dependent"
          }
        }
      ]
    },
    {
      "linkId" : "F-bowels",
      "text" : "大便控制 (Bowels)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 10
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31625-9",
            "display" : "Continent"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31626-7",
            "display" : "Occasional accident"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31627-5",
            "display" : "Incontinent (or needs to be given enemas)"
          }
        }
      ]
    },
    {
      "linkId" : "G-bladder",
      "text" : "小便控制 (Bladder)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 10
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31625-9",
            "display" : "Continent"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31626-7",
            "display" : "Occasional accident"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31628-3",
            "display" : "Incontinent, or catheterized and unable to manage alone"
          }
        }
      ]
    },
    {
      "linkId" : "H-mobility",
      "text" : "平地行走 (Mobility)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 15
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31642-4",
            "display" : "Independent (but may use any aid; for example, stick) >50 yards"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 10
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31641-6",
            "display" : "Walks with help of one person (verbal or physical) >50 yards"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31640-8",
            "display" : "Wheelchair independent, including corners, >50 yards"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31639-0",
            "display" : "Immobile or <50 yards"
          }
        }
      ]
    },
    {
      "linkId" : "I-stairs",
      "text" : "上下樓梯 (Stairs)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 10
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA12302-8",
            "display" : "Independent"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31629-1",
            "display" : "Needs help (verbal, physical, carrying aid)"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA24937-7",
            "display" : "Unable"
          }
        }
      ]
    },
    {
      "linkId" : "J-transfer",
      "text" : "移位(Transfer)",
      "type" : "choice",
      "answerOption" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 15
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA12302-8",
            "display" : "Independent"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 10
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31635-8",
            "display" : "Minor help (verbal or physical)"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 5
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31634-1",
            "display" : "Major help (one or two people, physical), can sit"
          }
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
              "valueDecimal" : 0
            }
          ],
          "valueCoding" : {
            "system" : "http://loinc.org",
            "code" : "LA31633-3",
            "display" : "Unable, no sitting balance"
          }
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%resource.item.where(linkId != 'K-total-score-Barthel').answer.value.extension('http://hl7.org/fhir/StructureDefinition/ordinalValue').value.sum()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
          "valueBoolean" : true
        }
      ],
      "linkId" : "K-total-score-Barthel",
      "text" : "巴氏量表總分",
      "type" : "integer",
      "required" : false,
      "readOnly" : true
    }
  ]
}

```
