# ARAT上肢功能評估問卷 - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "ARATQuestionnaireInstance",
  "meta" : {
    "profile" : [
      "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/SPACQuestionnaire"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "graspScore",
        "language" : "text/fhirpath",
        "expression" : "%resource.descendants().where(linkId in ('a-block-10cm3' | 'a-block-2.5cm3' | 'a-block-5cm3' | 'a-block-7.5cm3' | 'a-cricket-ball' | 'a-sharpening-stone')).answer.value.sum()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "gripScore",
        "language" : "text/fhirpath",
        "expression" : "%resource.descendants().where(linkId in ('b-pour-water-from-one-glass-to-another' | 'b-displace-2.25-cm-alloy-tube-from-one-side-oftable-to-the-other' | 'b-displace-1-cm-alloy-tube-from-one-side-of-table-to-the-other' | 'b-put-washer-over-bolt')).answer.value.sum()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "pinchScore",
        "language" : "text/fhirpath",
        "expression" : "%resource.descendants().where(linkId in ('c-ball-bearing-held-between-ring-finger-and-thumb' | 'c-marble-held-between-index-finger-and-thumb' | 'c-ball-bearing-held-between-middle-finger-and-thumb' | 'c-ball-bearing-held-between-index-finger-and-thumb' | 'c-marble-held-between-ring-finger-and-thumb' | 'c-marble-held-between-middle-finger-and-thumb')).answer.value.sum()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "movementScore",
        "language" : "text/fhirpath",
        "expression" : "%resource.descendants().where(linkId in ('d-hand-to-behind-the-head' | 'd-hand-to-top-ofhead' | 'd-hand-to-mouth')).answer.value.sum()"
      }
    }
  ],
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/Questionnaire/ARATQuestionnaireInstance",
  "version" : "0.1.0",
  "name" : "ARATQuestionnaire",
  "title" : "ARAT上肢功能評評估問卷",
  "status" : "active",
  "subjectType" : ["Patient"],
  "date" : "2025-11-24T07:10:30+00:00",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "ARAT上肢功能評評估問卷(Yozbatiran, Der-Yeghiaian, and Cramer, 2008)，分左右邊各57分",
  "purpose" : "提供標準化的上肢感覺評估工具，用於中風復健評估",
  "item" : [
    {
      "linkId" : "assessment-side-arat",
      "text" : "請選擇評估側",
      "type" : "choice",
      "required" : true,
      "answerOption" : [
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "24028007",
            "display" : "Right"
          }
        },
        {
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "7771000",
            "display" : "Left"
          }
        }
      ]
    },
    {
      "linkId" : "A-grasp-subscale",
      "text" : "A.抓力分量表",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "A-I-block-10cm3",
          "text" : "方塊積木, 10 立方公分",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "A-I-block-2.5cm3",
          "text" : "方塊積木, 2.5 立方公分",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "A-I-block-5cm3",
          "text" : "方塊積木, 5 立方公分",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "A-I-block-7.5cm3",
          "text" : "方塊積木, 7.5 立方公分",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "A-I-cricket-ball",
          "text" : "板球",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "A-I-sharpening-stone",
          "text" : "磨刀石",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%graspScore"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
              "valueBoolean" : true
            }
          ],
          "linkId" : "A-grasp-subscale-subscore",
          "text" : "A.抓力分數",
          "type" : "integer",
          "readOnly" : true
        }
      ]
    },
    {
      "linkId" : "B-grip-subscale",
      "text" : "B.握力分量表",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "B-I-pour-water-from-one-glass-to-another",
          "text" : "將水從一個杯子倒到另一個杯子",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "B-I-displace-2.25-cm-alloy-tube-from-one-side-oftable-to-the-other",
          "text" : "將 2.25 公分合金管從桌子的一側移到另一側",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "B-I-displace-1-cm-alloy-tube-from-one-side-of-table-to-the-other",
          "text" : "將 1 公分合金管從桌子的一側移到另一側",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "B-I-put-washer-over-bolt",
          "text" : "將墊圈放在螺栓上",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%gripScore"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
              "valueBoolean" : true
            }
          ],
          "linkId" : "B-grip-subscale-subscore",
          "text" : "B.握力分數",
          "type" : "integer",
          "readOnly" : true
        }
      ]
    },
    {
      "linkId" : "C-pinch-subscale",
      "text" : "C.捏取分量表",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "C-I-ball-bearing-held-between-ring-finger-and-thumb",
          "text" : "滾珠軸承，握在無名指與大拇指之間",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "C-I-marble-held-between-index-finger-and-thumb",
          "text" : "大理石，握在食指與大拇指之間",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "C-I-ball-bearing-held-between-middle-finger-and-thumb",
          "text" : "滾珠軸承，握在中指與拇指之間",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "C-I-ball-bearing-held-between-index-finger-and-thumb",
          "text" : "滾珠軸承，握在食指與拇指之間",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "C-I-marble-held-between-ring-finger-and-thumb",
          "text" : "大理石，握在無名指和大拇指之間",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "C-I-marble-held-between-middle-finger-and-thumb",
          "text" : "大理石，握在中指與大拇指之間",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%pinchScore"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
              "valueBoolean" : true
            }
          ],
          "linkId" : "C-pinch-subscale-subscore",
          "text" : "C.捏取分數",
          "type" : "integer",
          "readOnly" : true
        }
      ]
    },
    {
      "linkId" : "D-gross-movement-subscale",
      "text" : "D.粗大動作分量表",
      "type" : "group",
      "required" : true,
      "item" : [
        {
          "linkId" : "D-I-hand-to-behind-the-head",
          "text" : "手放在腦後",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "D-I-hand-to-top-of-head",
          "text" : "手放在頭頂",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "linkId" : "D-I-hand-to-mouth",
          "text" : "手到嘴",
          "type" : "choice",
          "required" : true,
          "answerOption" : [
            {
              "valueInteger" : 0
            },
            {
              "valueInteger" : 1
            },
            {
              "valueInteger" : 2
            },
            {
              "valueInteger" : 3
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%movementScore"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
              "valueBoolean" : true
            }
          ],
          "linkId" : "D-gross-movement-subscale-subscore",
          "text" : "D.粗大動作分數",
          "type" : "integer",
          "readOnly" : true
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%graspScore + %gripScore + %pinchScore + %movementScore"
          }
        },
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationExtract",
          "valueBoolean" : true
        }
      ],
      "linkId" : "E-total-score-ARAT",
      "text" : "E.ARAT總分計算",
      "type" : "integer",
      "required" : false,
      "readOnly" : true
    }
  ]
}

```
