# My FHIR Client Capability Statement - 機器手訓練實作指引 (RoboHand Training Implementation Guide) v0.1.0



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "MyFHIRClientCapabilityStatement",
  "url" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/CapabilityStatement/MyFHIRClientCapabilityStatement",
  "version" : "0.1.0",
  "name" : "MyFHIRClientCapabilityStatement",
  "title" : "My FHIR Client Capability Statement",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-25",
  "publisher" : "Kimsber",
  "contact" : [
    {
      "name" : "Kimsber",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://github.com/Kimsber"
        }
      ]
    }
  ],
  "description" : "此 CapabilityStatement 定義了用戶端（Client）應支援的 FHIR RESTful API 功能。用戶端建議應該（SHOULD）使用伺服端能力聲明中的查詢參數，支援讀取和查詢一個或多個 FHIR Profile。",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "patchFormat" : ["application/json-patch+json"],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "用戶端建議應該（SHOULD）使用伺服端能力聲明中的查詢參數，支援讀取和查詢一個或多個 Profile。系統互動能力：可能可以（MAY）支援交易（transaction）、批次（batch）與查詢系統（search-system）。",
      "resource" : [
        {
          "type" : "Bundle",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Bundle",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://build.fhir.org/ig/Kimsber/Rehab-IGSearchParameter/BundleId",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://example.org/fhir/SearchParameter/Bundle-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "CarePlan",
          "profile" : "https://github.com/Kimsber/StructureDefinition/CarePlan",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "http://example.org/fhir/SearchParameter/CarePlan-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "category",
              "definition" : "http://example.org/fhir/SearchParameter/CarePlan-category",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "http://example.org/fhir/SearchParameter/CarePlan-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "http://example.org/fhir/SearchParameter/CarePlan-status",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Condition",
          "profile" : "https://github.com/Kimsber/fhir/StructureDefinition/Condition",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/Condition-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "clinical-status",
              "definition" : "http://example.org/fhir/SearchParameter/Condition-clinical-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "http://example.org/fhir/SearchParameter/Condition-code",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "http://example.org/fhir/SearchParameter/Condition-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "onset-date",
              "definition" : "http://example.org/fhir/SearchParameter/Condition-onset-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "abatement-date",
              "definition" : "http://example.org/fhir/SearchParameter/Condition-abatement-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "severity",
              "definition" : "http://example.org/fhir/SearchParameter/Condition-severity",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Encounter",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/Encounter-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "class",
              "definition" : "http://example.org/fhir/SearchParameter/Encounter-class",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "http://example.org/fhir/SearchParameter/Encounter-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://example.org/fhir/SearchParameter/Encounter-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "location",
              "definition" : "http://example.org/fhir/SearchParameter/Encounter-location",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "http://example.org/fhir/SearchParameter/Encounter-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "http://example.org/fhir/SearchParameter/Encounter-status",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Goal",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Goal",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "http://example.org/fhir/SearchParameter/Goal-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "lifecycle-status",
              "definition" : "http://example.org/fhir/SearchParameter/Goal-lifecycle-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "target-date",
              "definition" : "http://example.org/fhir/SearchParameter/Goal-target-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "description",
              "definition" : "http://example.org/fhir/SearchParameter/Goal-description",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "MedicationAdministration",
          "profile" : "https://github.com/Kimsber/StructureDefinition/MedicationAdministration",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-code",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "medication",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-medication",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "context",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-context",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "device",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-device",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "effective-time",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-effective-time",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "performer",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-performer",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "reason-given",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-reason-given",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "reason-not-given",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-reason-not-given",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "request",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-request",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "http://example.org/fhir/SearchParameter/MedicationAdministration-subject",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Observation",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Observation",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "category",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-category",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-code",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "performer",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-performer",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_lastUpdated",
              "definition" : "http://example.org/fhir/SearchParameter/Observation-_lastUpdated",
              "type" : "date"
            }
          ]
        },
        {
          "type" : "Organization",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Organization",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/Organization-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://example.org/fhir/SearchParameter/Organization-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "http://example.org/fhir/SearchParameter/Organization-name",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "type",
              "definition" : "http://example.org/fhir/SearchParameter/Organization-type",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Patient",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Patient",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/Patient-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "birthdate",
              "definition" : "http://example.org/fhir/SearchParameter/Patient-birthdate",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "gender",
              "definition" : "http://example.org/fhir/SearchParameter/Patient-gender",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://example.org/fhir/SearchParameter/Patient-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "http://example.org/fhir/SearchParameter/Patient-name",
              "type" : "string"
            }
          ],
          "operation" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "everything",
              "definition" : "http://hl7.org/fhir/OperationDefinition/Patient-everything"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Practitioner",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/Practitioner-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://example.org/fhir/SearchParameter/Practitioner-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "http://example.org/fhir/SearchParameter/Practitioner-name",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "PractitionerRole",
          "profile" : "https://github.com/Kimsber/StructureDefinition/PractitionerRole",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/PractitionerRole-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://example.org/fhir/SearchParameter/PractitionerRole-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "specialty",
              "definition" : "http://example.org/fhir/SearchParameter/PractitionerRole-specialty",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Procedure",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Procedure",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/Procedure-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "http://example.org/fhir/SearchParameter/Procedure-code",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "http://example.org/fhir/SearchParameter/Procedure-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "http://example.org/fhir/SearchParameter/Procedure-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "http://example.org/fhir/SearchParameter/Procedure-date",
              "type" : "date"
            }
          ]
        },
        {
          "type" : "Questionnaire",
          "profile" : "https://github.com/Kimsber/StructureDefinition/Questionnaire",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://example.org/fhir/SearchParameter/Questionnaire-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "title",
              "definition" : "http://example.org/fhir/SearchParameter/Questionnaire-title",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "QuestionnaireResponse",
          "profile" : "https://build.fhir.org/ig/Kimsber/Rehab-IG/StructureDefinition/QuestionnaireResponse",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "update"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "http://example.org/fhir/SearchParameter/QuestionnaireResponse-_id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "http://example.org/fhir/SearchParameter/QuestionnaireResponse-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "http://example.org/fhir/SearchParameter/QuestionnaireResponse-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "authored",
              "definition" : "http://example.org/fhir/SearchParameter/QuestionnaireResponse-authored",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "questionnaire",
              "definition" : "http://example.org/fhir/SearchParameter/QuestionnaireResponse-questionnaire",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "http://example.org/fhir/SearchParameter/QuestionnaireResponse-subject",
              "type" : "reference"
            }
          ],
          "operation" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "extract",
              "definition" : "http://hl7.org/fhir/uv/sdc/OperationDefinition/QuestionnaireResponse-extract",
              "documentation" : "用戶端應支援 $extract 操作以：\n• 將已完成的問卷回應轉換為結構化 FHIR 資源\n• 支援 Observation 提取（計分、測量）\n• 支援資源 Bundle 提取（複雜資料模型）\n• 自動計算衍生欄位（如得分）\n\n調用例：\nPOST /QuestionnaireResponse/qr123/$extract\n返回值：\n{\n  \"resourceType\": \"Bundle\",\n  \"type\": \"transaction\",\n  \"entry\": [\n    {\n      \"resource\": {\n        \"resourceType\": \"Observation\",\n        \"code\": { \"coding\": [{ \"code\": \"depression-score\" }] },\n        \"value\": { \"integer\": 15 }\n      }\n    }\n  ]\n}\n\n這是 SDC 工作流的關鍵步驟"
            }
          ]
        }
      ]
    }
  ]
}

```
