# hl7.fhir.fr.core#2.2.0-ballot: Guide d'implémentation Fr Core

## Pages

* [Accueil](index.md)
* [Historique des changements](change_notes.md)
* [Problématiques connues](known_problems.md)
* [Contraintes sur les profils](structure_contraintes.md)
* [Entités](structure_entites.md)
* [Autres Ressources](autres_ressources.md)
* [Bonnes pratiques d'usage du guide d'implémentation](bonnes_pratiques.md)
* [Introduction](structure_intro.md)
* [Téléchargements et usages](downloads.md)
* [A propos](a_propos.md)
* [Relations entre entités](structure_relations.md)
* [Artifacts Summary](artifacts.md)
* [Liste des profils](profile_list.md)
* [Nomenclatures](structure_nomenclatures.md)
* [Références](structure_ref_loi.md)

## Resources

### CodeSystems

* [FR Core CodeSystem Champ Activite - Codes du champ d'activité](CodeSystem-fr-core-cs-champ-activite.md)
* [FR Core CodeSystem Circonstances Sortie](CodeSystem-fr-core-cs-circonstances-sortie.md)
* [FR Core CodeSystem Codes Tarifs - nomenclature TNJP](CodeSystem-fr-core-cs-code-tarif-tnjp.md)
* [FR Core CodeSystem Contact Relationship](CodeSystem-fr-core-cs-contact-relationship.md)
* [FR Core CodeSystem Discipline d'Equipement - nomenclature SAE](CodeSystem-fr-core-cs-discipline-equipement.md)
* [FR Core CodeSystem Discipline de prestation - nomenclature SAE](CodeSystem-fr-core-cs-discipline-prestation.md)
* [FR Core CodeSystem Fiabilité Identité](CodeSystem-fr-core-cs-fiabilite-identite.md)
* [FR Core CodeSystem Identifier Type](CodeSystem-fr-core-cs-identifier-type.md)
* [FR Core CodeSystem Location Identifier Type](CodeSystem-fr-core-cs-location-identifier-type.md)
* [FR Core CodeSystem Location Physical Type](CodeSystem-fr-core-cs-location-physical-type.md)
* [FR Core CodeSystem Position du lit](CodeSystem-fr-core-cs-location-position-lit.md)
* [FR Core CodeSystem Location Position Room](CodeSystem-fr-core-cs-location-position-room.md)
* [FR Core CodeSystem Type Chambre](CodeSystem-fr-core-cs-location-type-chambre.md)
* [FR Core CodeSystem Location Type](CodeSystem-fr-core-cs-location-type.md)
* [FR Core CodeSystem Marital Status](CodeSystem-fr-core-cs-marital-status.md)
* [FR Core CodeSystem Mode Validation Identite](CodeSystem-fr-core-cs-method-collection.md)
* [FR Core CodeSystem Mode Validation Identite](CodeSystem-fr-core-cs-mode-validation-identity.md)
* [FR Core CodeSystem Schedule Type](CodeSystem-fr-core-cs-schedule-type.md)
* [FR Core CodeSystem Type d'activité - nomenclature SAE](CodeSystem-fr-core-cs-type-activite.md)
* [FR Core CodeSystem Type Admission](CodeSystem-fr-core-cs-type-admission.md)
* [FR Core CodeSystem Organization Type](CodeSystem-fr-core-cs-type-organisation.md)
* [FR Core CodeSystem UF Indicator - indicateur d'une unité fonctionnelle](CodeSystem-fr-core-cs-uf-indicateur.md)
* [FR Core CodeSystem v2-0203](CodeSystem-fr-core-cs-v2-0203.md)
* [FR Core CodeSystem v2-0445](CodeSystem-fr-core-cs-v2-0445.md)
* [FR Core CodeSystem v2-3307](CodeSystem-fr-core-cs-v2-3307.md)
* [FR Core CodeSystem v2-3311](CodeSystem-fr-core-cs-v2-3311.md)

### ValueSets

* [FR Core ValueSet Availability Schedule](ValueSet-fr-core-vs-availability-time-rule.md)
* [Body Position value set](ValueSet-fr-core-vs-body-position.md)
* [Blood Pressure Measurement Body Location Precoordinated value set](ValueSet-fr-core-vs-bp-meas-body-location.md)
* [Blood Pressure Measurement Method value set](ValueSet-fr-core-vs-bp-meas-method.md)
* [FR Core ValueSet BP measurement method](ValueSet-fr-core-vs-bp-method.md)
* [FR Core ValueSet Categorie SAE Etablissement](ValueSet-fr-core-vs-categorie-sae-etablissement.md)
* [FR Core ValueSet COG commune pays](ValueSet-fr-core-vs-cog-commune-pays.md)
* [FR Core ValueSet Contact relationship](ValueSet-fr-core-vs-contact-relationship.md)
* [FR Core ValueSet Organization Discipline de prestation - nomenclature SAE](ValueSet-fr-core-vs-discipline-prestation.md)
* [FR Core ValueSet Email type](ValueSet-fr-core-vs-email-type.md)
* [FR Core ValueSet Encounter class](ValueSet-fr-core-vs-encounter-class.md)
* [FR Core ValueSet Encounter discharge disposition](ValueSet-fr-core-vs-encounter-discharge-disposition.md)
* [FR Core ValueSet Encounter identifier type](ValueSet-fr-core-vs-encounter-identifier-type.md)
* [FR Core ValueSet Encounter type](ValueSet-fr-core-vs-encounter-type.md)
* [Heart Rate Measurement Body Location Precoordinated value set](ValueSet-fr-core-vs-heartrate-body-location.md)
* [Heart Rate Measurement Method value set](ValueSet-fr-core-vs-heartrate-measurement-method.md)
* [FR Core ValueSet BodyPosition](ValueSet-fr-core-vs-height-body-position.md)
* [Height Length Measurement Method value set](ValueSet-fr-core-vs-height-meas-method.md)
* [FR Core ValueSet Identity method collection](ValueSet-fr-core-vs-identity-method-collection.md)
* [FR Core ValueSet Identity reliability](ValueSet-fr-core-vs-identity-reliability.md)
* [FR Core ValueSet INSEE code](ValueSet-fr-core-vs-insee-code.md)
* [FR Core ValueSet Location Position Lit](ValueSet-fr-core-vs-location-position-lit.md)
* [FR Core ValueSet Location Type Chambre](ValueSet-fr-core-vs-location-type-chambre.md)
* [FR Core ValueSet Location type](ValueSet-fr-core-vs-location-type.md)
* [FR Core ValueSet Marital Status ValueSet](ValueSet-fr-core-vs-marital-status.md)
* [FR Core ValueSet Mode validation identity INS](ValueSet-fr-core-vs-mode-validation-identity-ins.md)
* [FR Core ValueSet Mode validation identity](ValueSet-fr-core-vs-mode-validation-identity.md)
* [FR Core ValueSet Codes Tarifs - nomenclature TNJP](ValueSet-fr-core-vs-oragnization-code-tarif-tnjp.md)
* [FR Core ValueSet Organization Type Activité - nomenclature SAE](ValueSet-fr-core-vs-oragnization-type-activite.md)
* [FR Core ValueSet Organization Champ Activite - Champ d'activité clinique de l'organisation type UF](ValueSet-fr-core-vs-organization-champ-activite.md)
* [FR Core ValueSet Organization Discipline d'Equipement - nomenclature SAE](ValueSet-fr-core-vs-organization-discipline-equipement.md)
* [FR Core ValueSet Organization Etablisement type](ValueSet-fr-core-vs-organization-etablissement-type.md)
* [FR Core ValueSet Organization identifier type](ValueSet-fr-core-vs-organization-identifier-type.md)
* [FR Core ValueSet Organization type](ValueSet-fr-core-vs-organization-type.md)
* [FR Core ValueSet Organization UAC type](ValueSet-fr-core-vs-organization-uac-type.md)
* [FR Core ValueSet Organization UF Indicateur](ValueSet-fr-core-vs-organization-uf-indicateur.md)
* [FR Core ValueSet Patient contact role](ValueSet-fr-core-vs-patient-contact-role.md)
* [FR Core ValueSet Patient gender](ValueSet-fr-core-vs-patient-gender.md)
* [FR Core ValueSet Patient identifier type](ValueSet-fr-core-vs-patient-identifier-type.md)
* [FR Core ValueSet Patient identifier use INS](ValueSet-fr-core-vs-patient-identifier-use-ins.md)
* [FR Core ValueSet Patient identifier use PI](ValueSet-fr-core-vs-patient-identifier-use-pi.md)
* [FR Core ValueSet Practitioner identifier type](ValueSet-fr-core-vs-practitioner-identifier-type.md)
* [FR Core ValueSet PractitionerRole Exercice](ValueSet-fr-core-vs-practitioner-role-exercice.md)
* [FR Core ValueSet Practitioner specialty](ValueSet-fr-core-vs-practitioner-specialty.md)
* [FR Core ValueSet relation type](ValueSet-fr-core-vs-relation-type.md)
* [Respiratory Rate Measurement Method value set](ValueSet-fr-core-vs-respiratory-rate-meas-method.md)
* [FR Core ValueSet Schedule type](ValueSet-fr-core-vs-schedule-type.md)
* [FR Core ValueSet Unavailability Reason](ValueSet-fr-core-vs-schedule-unavailability-reason.md)
* [Oxygen Saturation Body Location value set](ValueSet-fr-core-vs-spo2-body-location.md)
* [FR Core ValueSet Title](ValueSet-fr-core-vs-title.md)
* [Body Temperature Measurement Body Location value set](ValueSet-fr-core-vsbody-temp-meas-body-location.md)

### Complex-type Profiles

* [FR Core Address Profile](StructureDefinition-fr-core-address.md)
* [FR Core Contact Point Profile](StructureDefinition-fr-core-contact-point.md)
* [FR Core Human Name Profile](StructureDefinition-fr-core-human-name.md)

### Resource Profiles

* [FR Core Appointment Profile](StructureDefinition-fr-core-appointment.md)
* [FR Core Encounter Profile](StructureDefinition-fr-core-encounter.md)
* [FR Core Healthcare Service Profile](StructureDefinition-fr-core-healthcare-service.md)
* [FR Core Location Profile](StructureDefinition-fr-core-location.md)
* [FR Core Medication Administration Inhaled Oxygen Profile](StructureDefinition-fr-core-medication-administration-inhaled-oxygen.md)
* [FR Core Observation Bmi Profile](StructureDefinition-fr-core-observation-bmi.md)
* [FR Core Observation Body Height Profile](StructureDefinition-fr-core-observation-body-height.md)
* [FR Core Observation Body Temperature Profile](StructureDefinition-fr-core-observation-body-temperature.md)
* [FR Core Observation Body Weight Profile](StructureDefinition-fr-core-observation-body-weight.md)
* [FR Core Observation Blood Pressure Profile](StructureDefinition-fr-core-observation-bp.md)
* [FR Core Observation Head Circum Profile](StructureDefinition-fr-core-observation-head-circum.md)
* [FR Core Observation Heart Rate Profile](StructureDefinition-fr-core-observation-heartrate.md)
* [FR Core Observation Respiratory Rate Profile](StructureDefinition-fr-core-observation-resp-rate.md)
* [FR Core Observation Oxygen Saturation Profile](StructureDefinition-fr-core-observation-saturation-oxygen.md)
* [FR Core Organization Etablissement Profile](StructureDefinition-fr-core-organization-etablissement.md)
* [FR Core Organization UAC Profile](StructureDefinition-fr-core-organization-uac.md)
* [FR Core Organization UF Profile](StructureDefinition-fr-core-organization-uf.md)
* [FR Core Organization Profile](StructureDefinition-fr-core-organization.md)
* [FR Core Patient INS Profile](StructureDefinition-fr-core-patient-ins.md)
* [FR Core Patient Profile](StructureDefinition-fr-core-patient.md)
* [FR Core Practitioner Role](StructureDefinition-fr-core-practitioner-role.md)
* [FR Core Practitioner Profile](StructureDefinition-fr-core-practitioner.md)
* [FR Core Related Person Profile](StructureDefinition-fr-core-related-person.md)
* [FR Core Schedule Profile](StructureDefinition-fr-core-schedule.md)
* [FR Core Slot Profile](StructureDefinition-fr-core-slot.md)

### Extensions

* [FR Core Address Insee Code Extension](StructureDefinition-fr-core-address-insee-code.md)
* [FR Core Appointment Operator Extension](StructureDefinition-fr-core-appointment-operator.md)
* [FR Core Comment Extension](StructureDefinition-fr-core-comment.md)
* [FR Core Contact Point Email Type Extension](StructureDefinition-fr-core-contact-point-email-type.md)
* [FR Core Encounter Estimated Discharge Date Extension](StructureDefinition-fr-core-estimated-discharge-date.md)
* [FR Core Assembly Order Extension](StructureDefinition-fr-core-human-name-assembly-order.md)
* [FR Core Patient Ident Reliability Extension](StructureDefinition-fr-core-identity-reliability.md)
* [FR Core Location Extension - Position du lit](StructureDefinition-fr-core-location-position-lit.md)
* [FR Core Location Extension - Type de chambre](StructureDefinition-fr-core-location-type-chambre.md)
* [FR Core Lunar Date Extension](StructureDefinition-fr-core-lunar-date.md)
* [FR Core Observation Body Position Ext Extension](StructureDefinition-fr-core-observation-body-position-ext.md)
* [FR Core Observation Height Body Position Extension](StructureDefinition-fr-core-observation-height-body-position.md)
* [FR Core Observation Level Of Exertion Extension](StructureDefinition-fr-core-observation-level-of-exertion.md)
* [FR Core Organization Extension - Champ d'activité](StructureDefinition-fr-core-organization-champ-activite.md)
* [FR Core Organization Extension - Demandeuse d'acte](StructureDefinition-fr-core-organization-demandeuse-acte.md)
* [FR Core Organization Extension - Discipline d'équipement](StructureDefinition-fr-core-organization-discipline-equipement.md)
* [FR Core Organization Extension - Discipline Prestation](StructureDefinition-fr-core-organization-discipline-prestation.md)
* [FR Core Organization Extension - Exécutante d'acte](StructureDefinition-fr-core-organization-executante-acte.md)
* [FR Core Organization Extension - Membre d'organisation](StructureDefinition-fr-core-organization-member.md)
* [FR Core Organization Extension - Nombre total de places d'hébergement théoriques](StructureDefinition-fr-core-organization-place-hebergement-theorique.md)
* [FR Core Organization Raison Sociale Extension](StructureDefinition-fr-core-organization-raison-sociale.md)
* [FR Core Organization Extension - Catetgorie SAE](StructureDefinition-fr-core-organization-sae-category.md)
* [FR Core Organization Short Name Extension](StructureDefinition-fr-core-organization-short-name.md)
* [FR Core Organization Extension - Tarif Soin](StructureDefinition-fr-core-organization-tarif.md)
* [FR Core Organization Extension - Type d'activité](StructureDefinition-fr-core-organization-type-activite.md)
* [FR Core Organization Extension - UF Externe](StructureDefinition-fr-core-organization-uf-externe.md)
* [FR Core Organization Extension - Indicateur d'une unité fonctionnelle](StructureDefinition-fr-core-organization-uf-indicateur.md)
* [FR Core Patient Birth List Given name Extension](StructureDefinition-fr-core-patient-birth-list-given-name.md)
* [FR Core Patient Birthdate Update Indicator Extension](StructureDefinition-fr-core-patient-birthdate-update-indicator.md)
* [FR Core Patient Contact Identifier Extension](StructureDefinition-fr-core-patient-contact-identifier.md)
* [FR Core Patient Death Place Extension](StructureDefinition-fr-core-patient-death-place.md)
* [Rang Gémellaire](StructureDefinition-fr-core-patient-multiple-birth-r5.md)
* [FR Core Nationality Extension](StructureDefinition-fr-core-patient-nationality.md)
* [FR Core Practitioner Specialty Extension](StructureDefinition-fr-core-practitioner-specialty.md)
* [FR Core Schedule availability time Extension](StructureDefinition-fr-core-schedule-availability-time.md)
* [FR Core Service Type Duration Extension](StructureDefinition-fr-core-service-type-duration.md)

### ImplementationGuides

* [Guide d'implémentation Fr Core](index.md)

### Examples

* [FRCoreAppointmentExample (Appointment)](Appointment-FRCoreAppointmentExample.md)
* [FRCoreEncounterExample (Encounter)](Encounter-FRCoreEncounterExample.md)
* [Service de cardiologie (HealthcareService)](HealthcareService-svc-cardiologie-1.md)
* [Lit Fenetre - chambre 04 (Location)](Location-hopitaltest-endocrino-ch04-litF.md)
* [Chambre 04 (Location)](Location-hopitaltest-endocrino-ch04.md)
* [Salle d'examen 01 (Location)](Location-hopitaltest-salle-examen-01.md)
* [Centre de radiologie Hôpital Z (Location)](Location-loc-radiologie-z.md)
* [FRCoreObservationBMIExample (Observation)](Observation-FRCoreObservationBMIExample.md)
* [FRCoreObservationBPExample (Observation)](Observation-FRCoreObservationBPExample.md)
* [FRCoreObservationBodyHeightExample (Observation)](Observation-FRCoreObservationBodyHeightExample.md)
* [FRCoreObservationBodyTemperatureExample (Observation)](Observation-FRCoreObservationBodyTemperatureExample.md)
* [FRCoreObservationBodyWeightExample (Observation)](Observation-FRCoreObservationBodyWeightExample.md)
* [FRCoreObservationHeadCircumExample (Observation)](Observation-FRCoreObservationHeadCircumExample.md)
* [FRCoreObservationHeartRateExample (Observation)](Observation-FRCoreObservationHeartRateExample.md)
* [HOPITAL INTERCOMMUNAL DE LA PRESQU'ILE G (Organization)](Organization-FRCoreOrganizationExample.md)
* [Depertement d'Endocrinologie (Organization)](Organization-hopitaltest-dept-11003-endocrino.md)
* [CHRU CENTRE VILLE (Organization)](Organization-hopitaltest-eg-4-members.md)
* [CHRU RENNES (Organization)](Organization-hopitaltest-ej-350005179.md)
* [Pole Medecines spécialisées (Organization)](Organization-hopitaltest-pole-1150-med-spe.md)
* [Service Endocrino Diabeto (Organization)](Organization-hopitaltest-service-11006-endocrino-diabo.md)
* [Service Dietetique (Organization)](Organization-hopitaltest-service-11007-dietetique.md)
* [UAC 01 Dialyse (Organization)](Organization-hopitaltest-uac-4420-uac-01.md)
* [UAC 02 Dialyse (Organization)](Organization-hopitaltest-uac-4420-uac-02.md)
* [UF Dialyse (Organization)](Organization-hopitaltest-uf-4420-dialyse.md)
* [UF Endocrino Diabeto (Organization)](Organization-hopitaltest-uf-4701-endocrino-diab.md)
* [UF Nutrition (Organization)](Organization-hopitaltest-uf-4705-nutrition.md)
* [FRCorePatientExample (Patient)](Patient-FRCorePatientExample.md)
* [FRCorePractitionerExample (Practitioner)](Practitioner-FRCorePractitionerExample.md)
* [FRCorePractitionerRoleExample (PractitionerRole)](PractitionerRole-FRCorePractitionerRoleExample.md)
* [FRCoreScheduleExample (Schedule)](Schedule-FRCoreScheduleExample.md)
* [FRCoreSlotExample (Slot)](Slot-FRCoreSlotExample.md)
