# Accueil - Guide d'implémentation Fr Core v2.2.0-ballot

* [**Table of Contents**](toc.md)
* **Accueil**

## Accueil

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fr/ig/fhir/core/ImplementationGuide/hl7.fhir.fr.core | *Version*:2.2.0-ballot |
| Active as of 2025-12-17 | *Computable Name*:FrCore |

 **Profils, extensions, jeux de valeurs, et guides de mise en œuvre normalisant l'échange de données administratives sur les patients, les professionnels de santé et les organisations, et les rencontres avec les patients (programmées ou effectives), ainsi que les signes vitaux en France.**
 Profiles, extensions, value sets, code systems and implementation guides standardizing the exchange of administrative data about patients, health professionals and organization, and patient encounters (scheduled or effective), and vital sign in France 

> **Attention !**Cette version du guide d'implémentation est en concertation pour validation. La version officielle est accessible à l'adresse http://hl7.fr/ig/fhir/core</b>

Ce guide de mise en œuvre est fourni pour **soutenir l’utilisation de FHIR® en France**. Il permet de définir les profils, les extensions et les jeux de valeurs normalisant **l’échange de données administratives sur les patients, les professionnels de santé et les organisations, et les rencontres avec les patients (programmées ou effectives), ainsi que les signes vitaux**.

Les profils FHIR de ce guide d’implémentation sont volontairement très peu contraignants et ne répondent pas à des cas d’usages spécifiques, l’objectif de ce guide d’implémentation est de proposer un socle commun pour l’ensemble des échanges de données utilisant le standard FHIR en France. Par exemple, ce guide indique comment modéliser un patient FHIR en France (contenant l’identifiant national de santé (INS)), le professionnel de santé (contenant l’identifiant national de professionnel de santé (IDNatPS)), …

Ainsi, on y retrouve :

* Les ressources essentielles profilées pour la France
* Les extensions nécessaires à l’utilisation locale en France.

### Champ d’application

Ce document présente les concepts d’utilisation français définis par :

* Profils - contraintes utiles des ressources et types de données FHIR essentiels pour l’utilisation en France.
* Extensions - extensions FHIR ajoutées pour un usage local, couvrant les concepts français nécessaires.
* Terminologies - systèmes de codes et ensembles de valeurs définis ou référencés pour la France.

Les activités de profilage donnent la priorité aux ressources ayant un niveau de maturité suffisant (>=3). Chaque sujet fonctionnel est traité par un groupe de travail dédié d’Interop’Santé, réunissant des éditeurs de logiciels, des professionnels des établissements de santé et des représentants d’agences gouvernementales. Le consensus sur les ressources de conformité FHIR est établi d’abord au niveau du groupe de travail, puis au niveau des membres.

### Choix de la version du standard FHIR

Le Guide d’implémentation FR Core est **basé sur la version Release 4 de HL7 FHIR** et définit l’ensemble minimum de contraintes sur les ressources FHIR pour créer les profils FR Core. Elles font référence à un certain nombre de ressources du standard ainsi qu’aux spécifications de l’API REST FHIR, basées sur le protocole HTTP. Les syntaxes retenues sont la syntaxe XML et JSON.

En établissant la “base” des normes pour promouvoir l’interopérabilité et l’adoption par le biais d’une mise en œuvre commune, il permet une évolution ultérieure de l’élaboration des normes pour des cas d’utilisation spécifiques.

La stratégie sur le choix des versions FHIR a été définie au sein d’un groupe de travail organisé entre Interop’Santé et l’ANS en 2023/2024, validée via une [concertation](https://participez.esante.gouv.fr/project/fhir-r5-ou-r4/presentation/presentation) de l’ANS.

#### Nouveaux cas d’usages FHIR adressés par Interop’Santé et l’ANS : privilégier FHIR R4 et anticiper la transition vers R6

Pour garantir la cohérence au sein de l’écosystème français, éviter tout problème de compatibilité ainsi que les travaux divergents, il est nécessaire d’utiliser une même version du standard FHIR à l’échelle nationale. Le choix a été fait de conserver FHIR R4 car il y a un existant conséquent en France et cela permet d’éviter une double transition R4 vers R5 et R5 vers R6 qui aurait un coût non négligeable. Ce choix est conforté car la release 6 se veut être la version finale stable de FHIR, une transition vers R6 se voudra de toute manière nécessaire. Pour anticiper cette transition, il est jugé important d’être proactif sur les travaux internationaux de développement de R6 et d’anticiper les impacts pour l’écosystème français. Il est également à noter que le choix national de la version FHIR utilisée devra être en accord avec le règlement de l’EEDS qui se dessine progressivement et qui pour l’heure semble se diriger vers R4.

#### Ne pas créer de guide d’implémentation (IG) se basant sur R5 sans analyse des normes et standards et des impacts

La priorité actuelle est de faire monter l’écosystème en compétences et de gagner en maturité sur les spécifications existantes. Créer des IGs R5 engendreraient une fragmentation de l’écosystème et un ralentissement de la mise en qualité de l’existant qui finirait par freiner l’adoption de FHIR.

Généralement, rajouter quelques [extensions qui miment les attributs R5](https://hl7.org/fhir/R5/versions.html#extensions) s’avère suffisant pour éviter de créer tout un guide en R5. Dans certains cas, une autre version de FHIR peut être justifiée, par exemple si le cas d’usage concerne des échanges internationaux ou si le cas d’usage est significativement mieux couvert par une autre version. Le cas échéant, l’usage d’une autre version devra être validé par une étude des normes et standards publiée et validée par l’écosystème.

Dans certains cas non identifiés à ce jour, il pourrait également être nécessaire de maintenir des guides d’implémentation sous plusieurs versions. Après validation par l’écosystème de ce besoin, cela donnerait l’opportunité d’estimer des travaux de maintenance d’Implementation Guide (IG) sous plusieurs versions ainsi qu’un mapping associé pour gagner en expérience.

#### Priorité FHIR France en 2025+ - améliorer la qualité de l’existant

De nombreux travaux ont été menés en 2023 pour mettre en qualité les spécifications FHIR et encourager leur déploiement, tel que le passage au format IG et la mise à jour des tests et validateurs gazelle.

Les priorités des prochaines années sont de continuer dans cette direction :

* La montée en compétences et l’acculturation des développeurs et des chefs de projets aux bonnes pratiques d’usages de FHIR, notamment en organisant des évènements par l'ANS et InteropSanté : projectathon, webinaires, formations, ...
* S’assurer de la faisabilité d’implémentation des IGs existants (amélioration du contenu narratif pour expliquer comment utiliser les ressources, s’assurer de la facilité d’accès au contenu, s'assurer que les IGs soient bien connus …).
* Prise en main des outils de mapping tel que le FHIR Mapping Language afin d'assurer une transition maîtrisée vers une autre version de FHIR.
* Anticiper les prochaines évolutions internationales : passage au FHIR Document dans le cadre du règlement européen, anticiper la transition vers FHIR R6, ...

Il est également nécessaire de rester à l’écoute des tendances internationales en interopérabilité et de se garder la possibilité de réitérer l’analyse si le besoin ou le contexte international évolue, en particulier l’EEDS.

### Gouvernance

Le guide d’implémentation FR Core est géré par HL7 France et IHE France au sein du comité technique FHIR de HL7 France.

### Dépendances





### Propriété intellectuelle

Certaines ressources sémantiques de ce guide sont protégées par des droits de propriété intellectuelle couverte par les déclarations ci-dessous. L’utilisation de ces ressources est soumise à l’acceptation et au respect des conditions précisées dans la licence d’utilisation de chacune d’entre elle.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [FRCoreAddressInseeCodeExtension](StructureDefinition-fr-core-address-insee-code.md), [FRCoreAddressProfile](StructureDefinition-fr-core-address.md)...Show 124 more,[FRCoreAppointmentOperatorExtension](StructureDefinition-fr-core-appointment-operator.md),[FRCoreAppointmentProfile](StructureDefinition-fr-core-appointment.md),[FRCoreAssemblyOrderExtension](StructureDefinition-fr-core-human-name-assembly-order.md),[FRCoreCodeSystemCirconstancesSortie](CodeSystem-fr-core-cs-circonstances-sortie.md),[FRCoreCodeSystemContactRelationship](CodeSystem-fr-core-cs-contact-relationship.md),[FRCoreCodeSystemIdentifierType](CodeSystem-fr-core-cs-identifier-type.md),[FRCoreCodeSystemLocationIdentifierType](CodeSystem-fr-core-cs-location-identifier-type.md),[FRCoreCodeSystemLocationPhysicalType](CodeSystem-fr-core-cs-location-physical-type.md),[FRCoreCodeSystemLocationPositionRoom](CodeSystem-fr-core-cs-location-position-room.md),[FRCoreCodeSystemLocationType](CodeSystem-fr-core-cs-location-type.md),[FRCoreCodeSystemMaritalStatus](CodeSystem-fr-core-cs-marital-status.md),[FRCoreCodeSystemMethodCollection](CodeSystem-fr-core-cs-method-collection.md),[FRCoreCodeSystemModeValidationIdentite](CodeSystem-fr-core-cs-mode-validation-identity.md),[FRCoreCodeSystemReliabilityIdentity](CodeSystem-fr-core-cs-fiabilite-identite.md),[FRCoreCodeSystemScheduleType](CodeSystem-fr-core-cs-schedule-type.md),[FRCoreCodeSystemTypeAdmission](CodeSystem-fr-core-cs-type-admission.md),[FRCoreCodeSystemTypesOrganisations](CodeSystem-fr-core-cs-type-organisation.md),[FRCoreCodeSystemv2_0203](CodeSystem-fr-core-cs-v2-0203.md),[FRCoreCodeSystemv2_0445](CodeSystem-fr-core-cs-v2-0445.md),[FRCoreCodeSystemv2_3307](CodeSystem-fr-core-cs-v2-3307.md),[FRCoreCodeSystemv2_3311](CodeSystem-fr-core-cs-v2-3311.md),[FRCoreCommentExtension](StructureDefinition-fr-core-comment.md),[FRCoreContactPointEmailTypeExtension](StructureDefinition-fr-core-contact-point-email-type.md),[FRCoreContactPointProfile](StructureDefinition-fr-core-contact-point.md),[FRCoreEncounterEstimatedDischargeDateExtension](StructureDefinition-fr-core-estimated-discharge-date.md),[FRCoreEncounterProfile](StructureDefinition-fr-core-encounter.md),[FRCoreHealthcareServiceProfile](StructureDefinition-fr-core-healthcare-service.md),[FRCoreHumanNameProfile](StructureDefinition-fr-core-human-name.md),[FRCoreLocationPartOfPositionRoomExtension](StructureDefinition-fr-core-location-position-room.md),[FRCoreLocationProfile](StructureDefinition-fr-core-location.md),[FRCoreLunarDateExtension](StructureDefinition-fr-core-lunar-date.md),[FRCoreMedicationAdministrationInhaledOxygenProfile](StructureDefinition-fr-core-medication-administration-inhaled-oxygen.md),[FRCoreNationalityExtension](StructureDefinition-fr-core-patient-nationality.md),[FRCoreObservationBmiProfile](StructureDefinition-fr-core-observation-bmi.md),[FRCoreObservationBodyHeightProfile](StructureDefinition-fr-core-observation-body-height.md),[FRCoreObservationBodyPositionExtExtension](StructureDefinition-fr-core-observation-body-position-ext.md),[FRCoreObservationBodyTemperatureProfile](StructureDefinition-fr-core-observation-body-temperature.md),[FRCoreObservationBodyWeightProfile](StructureDefinition-fr-core-observation-body-weight.md),[FRCoreObservationBpProfile](StructureDefinition-fr-core-observation-bp.md),[FRCoreObservationHeadCircumProfile](StructureDefinition-fr-core-observation-head-circum.md),[FRCoreObservationHeartRateProfile](StructureDefinition-fr-core-observation-heartrate.md),[FRCoreObservationHeightBodyPositionExtension](StructureDefinition-fr-core-observation-height-body-position.md),[FRCoreObservationLevelOfExertionExtension](StructureDefinition-fr-core-observation-level-of-exertion.md),[FRCoreObservationOxygenSaturationProfile](StructureDefinition-fr-core-observation-saturation-oxygen.md),[FRCoreObservationRespRateProfile](StructureDefinition-fr-core-observation-resp-rate.md),[FRCoreOrganizationActivityFieldExtension](StructureDefinition-fr-core-organization-activity-field.md),[FRCoreOrganizationActivityTypeExtension](StructureDefinition-fr-core-organization-activity-type.md),[FRCoreOrganizationAnalysisSectionExtension](StructureDefinition-fr-core-organization-analysis-section.md),[FRCoreOrganizationApplicantActExtension](StructureDefinition-fr-core-organization-applicant-act.md),[FRCoreOrganizationBudgetLetterExtension](StructureDefinition-fr-core-organization-budget-letter.md),[FRCoreOrganizationDescriptionExtension](StructureDefinition-fr-core-organization-description.md),[FRCoreOrganizationExecutantExtension](StructureDefinition-fr-core-organization-executant.md),[FRCoreOrganizationExternalExtension](StructureDefinition-fr-core-organization-external.md),[FRCoreOrganizationFieldExtension](StructureDefinition-fr-core-organization-field.md),[FRCoreOrganizationPoleProfile](StructureDefinition-fr-core-organization-pole.md),[FRCoreOrganizationPrestationDisciplineExtension](StructureDefinition-fr-core-organization-prestation-discipline.md),[FRCoreOrganizationProfile](StructureDefinition-fr-core-organization.md),[FRCoreOrganizationShortNameExtension](StructureDefinition-fr-core-organization-short-name.md),[FRCoreOrganizationTotalNumberOfTheoricalAccomodationSpaceExtension](StructureDefinition-fr-core-organization-number-of-theorical-accomadation-space.md),[FRCoreOrganizationUACProfile](StructureDefinition-fr-core-organization-uac.md),[FRCoreOrganizationUFProfile](StructureDefinition-fr-core-organization-uf.md),[FRCorePatientBirthDateUpdateIndicatorExtension](StructureDefinition-fr-core-patient-birthdate-update-indicator.md),[FRCorePatientBirthListGivenName](StructureDefinition-fr-core-patient-birth-list-given-name.md),[FRCorePatientContactIdentifierExtension](StructureDefinition-fr-core-patient-contact-identifier.md),[FRCorePatientDeathPlaceExtension](StructureDefinition-fr-core-patient-death-place.md),[FRCorePatientINSProfile](StructureDefinition-fr-core-patient-ins.md),[FRCorePatientIdentityReliabilityExtension](StructureDefinition-fr-core-identity-reliability.md),[FRCorePatientMultipleBirthExtension](StructureDefinition-fr-core-patient-multiple-birth-r5.md),[FRCorePatientProfile](StructureDefinition-fr-core-patient.md),[FRCorePractitionerProfile](StructureDefinition-fr-core-practitioner.md),[FRCorePractitionerRoleProfile](StructureDefinition-fr-core-practitioner-role.md),[FRCorePractitionerSpecialtyExtension](StructureDefinition-fr-core-practitioner-specialty.md),[FRCoreRelatedPersonProfile](StructureDefinition-fr-core-related-person.md),[FRCoreScheduleAvailabilityTimeExtension](StructureDefinition-fr-core-schedule-availability-time.md),[FRCoreScheduleProfile](StructureDefinition-fr-core-schedule.md),[FRCoreServiceTypeDurationExtension](StructureDefinition-fr-core-service-type-duration.md),[FRCoreSlotProfile](StructureDefinition-fr-core-slot.md),[FRCoreUsePeriodExtension](StructureDefinition-fr-core-use-period.md),[FRCoreValueSetAvailabilityTimeRule](ValueSet-fr-core-vs-availability-time-rule.md),[FRCoreValueSetBPMeasurementMethod](ValueSet-fr-core-vs-bp-method.md),[FRCoreValueSetBloodPressureMeasurementBodyLocation](ValueSet-fr-core-vs-bp-meas-body-location.md),[FRCoreValueSetBloodPressureMeasurementMethod](ValueSet-fr-core-vs-bp-meas-method.md),[FRCoreValueSetBodyPosition](ValueSet-fr-core-vs-body-position.md),[FRCoreValueSetBodyTemperatureMeasurementBodyLocation](ValueSet-fr-core-vsbody-temp-meas-body-location.md),[FRCoreValueSetCOGCommunePays](ValueSet-fr-core-vs-cog-commune-pays.md),[FRCoreValueSetContactRelationship](ValueSet-fr-core-vs-contact-relationship.md),[FRCoreValueSetEmailType](ValueSet-fr-core-vs-email-type.md),[FRCoreValueSetEncounterClass](ValueSet-fr-core-vs-encounter-class.md),[FRCoreValueSetEncounterDischargeDisposition](ValueSet-fr-core-vs-encounter-discharge-disposition.md),[FRCoreValueSetEncounterIdentifierType](ValueSet-fr-core-vs-encounter-identifier-type.md),[FRCoreValueSetEncounterType](ValueSet-fr-core-vs-encounter-type.md),[FRCoreValueSetHeartRateMeasurementBodyLocation](ValueSet-fr-core-vs-heartrate-body-location.md),[FRCoreValueSetHeartRateMeasurementMethod](ValueSet-fr-core-vs-heartrate-measurement-method.md),[FRCoreValueSetHeightBodyPosition](ValueSet-fr-core-vs-height-body-position.md),[FRCoreValueSetHeightMeasurementMethod](ValueSet-fr-core-vs-height-meas-method.md),[FRCoreValueSetINSEECode](ValueSet-fr-core-vs-insee-code.md),[FRCoreValueSetIdentityMethodCollection](ValueSet-fr-core-vs-identity-method-collection.md),[FRCoreValueSetIdentityReliabilityStatus](ValueSet-fr-core-vs-identity-reliability.md),[FRCoreValueSetLocationIdentifierType](ValueSet-fr-core-vs-location-identifier-type.md),[FRCoreValueSetLocationPhysicalType](ValueSet-fr-core-vs-location-physical-type.md),[FRCoreValueSetLocationPositionRoom](ValueSet-fr-core-vs-location-position-room.md),[FRCoreValueSetLocationType](ValueSet-fr-core-vs-location-type.md),[FRCoreValueSetMaritalStatus](ValueSet-fr-core-vs-marital-status.md),[FRCoreValueSetModeValidationIdentity](ValueSet-fr-core-vs-mode-validation-identity.md),[FRCoreValueSetModeValidationIdentityINS](ValueSet-fr-core-vs-mode-validation-identity-ins.md),[FRCoreValueSetOrganizationActivityField](ValueSet-fr-core-vs-organization-activity-field.md),[FRCoreValueSetOrganizationIdentifierType](ValueSet-fr-core-vs-organization-identifier-type.md),[FRCoreValueSetOrganizationType](ValueSet-fr-core-vs-organization-type.md),[FRCoreValueSetOrganizationUFActivityField](ValueSet-fr-core-vs-organization-uf-activity-field.md),[FRCoreValueSetPatientContactRole](ValueSet-fr-core-vs-patient-contact-role.md),[FRCoreValueSetPatientGender](ValueSet-fr-core-vs-patient-gender.md),[FRCoreValueSetPatientIdentifierType](ValueSet-fr-core-vs-patient-identifier-type.md),[FRCoreValueSetPatientIdentifierUseINS](ValueSet-fr-core-vs-patient-identifier-use-ins.md),[FRCoreValueSetPatientIdentifierUsePI](ValueSet-fr-core-vs-patient-identifier-use-pi.md),[FRCoreValueSetPatientRelationType](ValueSet-fr-core-vs-relation-type.md),[FRCoreValueSetPractitionerIdentifierType](ValueSet-fr-core-vs-practitioner-identifier-type.md),[FRCoreValueSetPractitionerRoleExercice](ValueSet-fr-core-vs-practitioner-role-exercice.md),[FRCoreValueSetPractitionerSpecialty](ValueSet-fr-core-vs-practitioner-specialty.md),[FRCoreValueSetRespiratoryRateMeasurementMethod](ValueSet-fr-core-vs-respiratory-rate-meas-method.md),[FRCoreValueSetSPO2BodyLocation](ValueSet-fr-core-vs-spo2-body-location.md),[FRCoreValueSetScheduleType](ValueSet-fr-core-vs-schedule-type.md),[FRCoreValueSetTitle](ValueSet-fr-core-vs-title.md),[FRCoreValueSetUnavailabilityReason](ValueSet-fr-core-vs-schedule-unavailability-reason.md)and[FrCore](index.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Observation/FRCoreObservationBMIExample](Observation-FRCoreObservationBMIExample.md), [Observation/FRCoreObservationBPExample](Observation-FRCoreObservationBPExample.md)...Show 5 more,[Observation/FRCoreObservationBodyHeightExample](Observation-FRCoreObservationBodyHeightExample.md),[Observation/FRCoreObservationBodyTemperatureExample](Observation-FRCoreObservationBodyTemperatureExample.md),[Observation/FRCoreObservationBodyWeightExample](Observation-FRCoreObservationBodyWeightExample.md),[Observation/FRCoreObservationHeadCircumExample](Observation-FRCoreObservationHeadCircumExample.md)and[Observation/FRCoreObservationHeartRateExample](Observation-FRCoreObservationHeartRateExample.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Observation/FRCoreObservationBMIExample](Observation-FRCoreObservationBMIExample.md), [Observation/FRCoreObservationBPExample](Observation-FRCoreObservationBPExample.md)...Show 5 more,[Observation/FRCoreObservationBodyHeightExample](Observation-FRCoreObservationBodyHeightExample.md),[Observation/FRCoreObservationBodyTemperatureExample](Observation-FRCoreObservationBodyTemperatureExample.md),[Observation/FRCoreObservationBodyWeightExample](Observation-FRCoreObservationBodyWeightExample.md),[Observation/FRCoreObservationHeadCircumExample](Observation-FRCoreObservationHeadCircumExample.md)and[Observation/FRCoreObservationHeartRateExample](Observation-FRCoreObservationHeartRateExample.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](https://interop.esante.gouv.fr/terminologies/1.4.0/CodeSystem-900000000000207008-20251001.html): [FRCoreObservationBodyHeightProfile](StructureDefinition-fr-core-observation-body-height.md), [FRCoreObservationBodyPositionExtExtension](StructureDefinition-fr-core-observation-body-position-ext.md)...Show 18 more,[FRCoreObservationBodyTemperatureProfile](StructureDefinition-fr-core-observation-body-temperature.md),[FRCoreObservationBpProfile](StructureDefinition-fr-core-observation-bp.md),[FRCoreObservationHeartRateProfile](StructureDefinition-fr-core-observation-heartrate.md),[FRCoreObservationHeightBodyPositionExtension](StructureDefinition-fr-core-observation-height-body-position.md),[FRCoreObservationOxygenSaturationProfile](StructureDefinition-fr-core-observation-saturation-oxygen.md),[FRCoreObservationRespRateProfile](StructureDefinition-fr-core-observation-resp-rate.md),[FRCoreValueSetBPMeasurementMethod](ValueSet-fr-core-vs-bp-method.md),[FRCoreValueSetBloodPressureMeasurementBodyLocation](ValueSet-fr-core-vs-bp-meas-body-location.md),[FRCoreValueSetBloodPressureMeasurementMethod](ValueSet-fr-core-vs-bp-meas-method.md),[FRCoreValueSetBodyPosition](ValueSet-fr-core-vs-body-position.md),[FRCoreValueSetBodyTemperatureMeasurementBodyLocation](ValueSet-fr-core-vsbody-temp-meas-body-location.md),[FRCoreValueSetHeartRateMeasurementBodyLocation](ValueSet-fr-core-vs-heartrate-body-location.md),[FRCoreValueSetHeartRateMeasurementMethod](ValueSet-fr-core-vs-heartrate-measurement-method.md),[FRCoreValueSetHeightBodyPosition](ValueSet-fr-core-vs-height-body-position.md),[FRCoreValueSetHeightMeasurementMethod](ValueSet-fr-core-vs-height-meas-method.md),[FRCoreValueSetRespiratoryRateMeasurementMethod](ValueSet-fr-core-vs-respiratory-rate-meas-method.md),[FRCoreValueSetSPO2BodyLocation](ValueSet-fr-core-vs-spo2-body-location.md)and[Observation/FRCoreObservationBPExample](Observation-FRCoreObservationBPExample.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Discharge disposition](http://terminology.hl7.org/7.0.1/CodeSystem-discharge-disposition.html): [FRCoreEncounterProfile](StructureDefinition-fr-core-encounter.md) and [FRCoreValueSetEncounterDischargeDisposition](ValueSet-fr-core-vs-encounter-discharge-disposition.md)
* [HL7 Terminology Maintenance Infrastructure Vocabulary](http://terminology.hl7.org/7.0.1/CodeSystem-hl7TermMaintInfra.html): [FRCoreCodeSystemModeValidationIdentite](CodeSystem-fr-core-cs-mode-validation-identity.md)
* [HumanNameAssemblyOrder](http://terminology.hl7.org/7.0.1/CodeSystem-name-assembly-order.html): [FRCoreAssemblyOrderExtension](StructureDefinition-fr-core-human-name-assembly-order.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Observation/FRCoreObservationBMIExample](Observation-FRCoreObservationBMIExample.md), [Observation/FRCoreObservationBPExample](Observation-FRCoreObservationBPExample.md)...Show 5 more,[Observation/FRCoreObservationBodyHeightExample](Observation-FRCoreObservationBodyHeightExample.md),[Observation/FRCoreObservationBodyTemperatureExample](Observation-FRCoreObservationBodyTemperatureExample.md),[Observation/FRCoreObservationBodyWeightExample](Observation-FRCoreObservationBodyWeightExample.md),[Observation/FRCoreObservationHeadCircumExample](Observation-FRCoreObservationHeadCircumExample.md)and[Observation/FRCoreObservationHeartRateExample](Observation-FRCoreObservationHeartRateExample.md)
* [Service category](http://terminology.hl7.org/7.0.1/CodeSystem-service-category.html): [Service de cardiologie](HealthcareService-svc-cardiologie-1.md)
* [Service type](http://terminology.hl7.org/7.0.1/CodeSystem-service-type.html): [Appointment/FRCoreAppointmentExample](Appointment-FRCoreAppointmentExample.md), [FRCoreServiceTypeDurationExtension](StructureDefinition-fr-core-service-type-duration.md), [Schedule/FRCoreScheduleExample](Schedule-FRCoreScheduleExample.md) and [Slot/FRCoreSlotExample](Slot-FRCoreSlotExample.md)
* [admissionType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0007.html): [FRCoreEncounterProfile](StructureDefinition-fr-core-encounter.md) and [FRCoreValueSetEncounterType](ValueSet-fr-core-vs-encounter-type.md)
* [contactRole2](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0131.html): [FRCorePatientProfile](StructureDefinition-fr-core-patient.md), [FRCoreRelatedPersonProfile](StructureDefinition-fr-core-related-person.md), [FRCoreValueSetContactRelationship](ValueSet-fr-core-vs-contact-relationship.md) and [FRCoreValueSetPatientContactRole](ValueSet-fr-core-vs-patient-contact-role.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [FRCorePatientINSProfile](StructureDefinition-fr-core-patient-ins.md), [FRCorePatientProfile](StructureDefinition-fr-core-patient.md), [FRCorePractitionerProfile](StructureDefinition-fr-core-practitioner.md), [FRCoreValueSetPatientIdentifierType](ValueSet-fr-core-vs-patient-identifier-type.md) and [FRCoreValueSetPractitionerIdentifierType](ValueSet-fr-core-vs-practitioner-identifier-type.md)
* [nameAssemblyOrder](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0444.html): [FRCoreAssemblyOrderExtension](StructureDefinition-fr-core-human-name-assembly-order.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [Encounter/FRCoreEncounterExample](Encounter-FRCoreEncounterExample.md) and [FRCoreValueSetEncounterClass](ValueSet-fr-core-vs-encounter-class.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.1/CodeSystem-v3-MaritalStatus.html): [FRCorePatientProfile](StructureDefinition-fr-core-patient.md) and [FRCoreValueSetMaritalStatus](ValueSet-fr-core-vs-marital-status.md)
* [NullFlavor](http://terminology.hl7.org/7.0.1/CodeSystem-v3-NullFlavor.html): [FRCoreAssemblyOrderExtension](StructureDefinition-fr-core-human-name-assembly-order.md), [FRCorePatientProfile](StructureDefinition-fr-core-patient.md) and [FRCoreValueSetMaritalStatus](ValueSet-fr-core-vs-marital-status.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationInterpretation.html): [Observation/FRCoreObservationBMIExample](Observation-FRCoreObservationBMIExample.md) and [Observation/FRCoreObservationBPExample](Observation-FRCoreObservationBPExample.md)


### Analyse inter-version

Ceci est un IG R4. Aucune des fonctionnalités quil utilise nest modifiée dans R4B, il peut donc être utilisé tel quel avec les systèmes R4B. Les packages pour [R4 (hl7.fhir.fr.core.r4)](package.r4.tgz) et [R4B (hl7.fhir.fr.core.r4b)](package.r4b.tgz) sont disponibles.

### Profils internationaux

*There are no Global profiles defined*

