# Home - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/ImplementationGuide/iknl.fhir.r4.pzp | *Version*:1.0.0-rc1 |
| Active as of 2025-10-31 | *Computable Name*:PZP |

### Project Description and Scope

This Implementation Guide (IG) supports the Advance Care Planning (ACP) information standard (Dutch: Proactieve Zorgplanning) and is intended for use within the palliative care domain in the Netherlands. This domain involves care for patients with an incurable illness or condition from which they are expected to die.

Developed by the [Netherlands Comprehensive Cancer Organisation](https://iknl.nl/en) (Dutch: Integraal Kankercentrum Nederland (IKNL)), this guide provides technical direction for using FHIR to exchange ACP data. It is based on [HL7 FHIR R4](http://hl7.org/fhir/R4/index.html) and builds on top of the [Dutch Core R4 profiles](https://simplifier.net/packages/nictiz.fhir.nl.r4.nl-core).

This guide assumes that readers are familiar with the functional specifications of ACP and the R4 version of FHIR.

### Call for Feedback

This implementation guide is a work in progress, and its quality and usefulness depend on community input. We welcome feedback on all aspects of this guide, and we are particularly interested in your thoughts on the following decisions and sections:

1. The[EncounterReference extension](StructureDefinition-ext-EncounterReference.md)is an optional extension that enables linking the Consent, Goal, and DeviceUseStatement resources to a relevant Encounter. We invite feedback on whether this extension is truly necessary.
1. The[Communication profile](StructureDefinition-ACP-Communication.md)has been developed to capture all communication events related to advance care planning. It specifically documents whether the patient has been informed about their responsibility to discuss treatment agreements with relatives. As this profile is newly created rather than derived from zib/nl-core profiles, we welcome input on its structure and modeling approach.
1. The[TreatmentDirective profile](StructureDefinition-ACP-TreatmentDirective.md)is reused for directives regarding deactivation of Implantable Cardioverter Defibrillators (ICDs). However, this does not fully align with the zib TreatmentDirective2 for two reasons:
* First, ICD codes cannot be added to `Consent.provision.code` due to binding constraints, so the mapping is placed in `Consent.provision.code.text` with `OTH` as the code. A zib ticket ([ZIB-2796](https://nictiz.atlassian.net/browse/ZIB-2796)) has been created to address this issue.
* Second, for `Consent.provision.type`, only the **permit** code should be used; the other two nullflavor codes (**ASKU** and **NASK**) from the dataset valueset are not appropriate here. The profile describes using `Consent.modifierExtension.specificationOther` to capture information about these choices, which is somewhat questionable. Alternatively, a specialized profile for ICDs could be created, not based on the nl-core profile but following the same structure where possible.

1. The[ACP Questionnaire](Questionnaire-ACP-zib2020.md)has been developed based on the ACP form dataset and aims to preserve the zib structure as much as possible. We welcome any feedback on its design and implementation.

### Dependencies







## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "iknl.fhir.r4.pzp",
  "url" : "https://api.iknl.nl/docs/pzp/r4/ImplementationGuide/iknl.fhir.r4.pzp",
  "version" : "1.0.0-rc1",
  "name" : "PZP",
  "title" : "Advance Care Planning (PZP)",
  "status" : "active",
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "Advance Care Planning (PZP) IG for FHIR R4 based on zib release 2020",
  "packageId" : "iknl.fhir.r4.pzp",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "nictiz_fhir_nl_r4_nl_core",
      "uri" : "http://fhir.org/packages/nictiz.fhir.nl.r4.nl-core/ImplementationGuide/nictiz.fhir.nl.r4.nl-core",
      "packageId" : "nictiz.fhir.nl.r4.nl-core",
      "version" : "0.12.0-beta.4"
    },
    {
      "id" : "nictiz_fhir_nl_r4_zib2020",
      "uri" : "http://fhir.org/packages/nictiz.fhir.nl.r4.zib2020/ImplementationGuide/nictiz.fhir.nl.r4.zib2020",
      "packageId" : "nictiz.fhir.nl.r4.zib2020",
      "version" : "0.12.0-beta.4"
    },
    {
      "id" : "hl7_fhir_uv_extensions_r4",
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "trial-use"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "..\\..\\input\\_resources\\Parameters-expansion.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-all"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "display-warnings"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-cibuild-issues"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "suppress-mappings"
          },
          {
            "url" : "value",
            "valueString" : "*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://api.iknl.nl/docs/pzp/r4/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "trial-use"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "..\\..\\input\\_resources\\Parameters-expansion.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-all"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "display-warnings"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-cibuild-issues"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "suppress-mappings"
          },
          {
            "url" : "value",
            "valueString" : "*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://api.iknl.nl/docs/pzp/r4/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "Q-QR",
        "name" : "Structures: Questionnaire and QuestionnaireResponses",
        "description" : "These define forms used by systems conforming to this implementation guide to capture or expose data to end users."
      },
      {
        "id" : "AD",
        "name" : "Requirements: Actor Definitions",
        "description" : "The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/ACPActorConsulter"
        },
        "name" : "ACP Actor Consulter",
        "description" : "The ACP Actor Consulter is a system that creates and initiates a data access request to retrieve digital health and administrative information.",
        "exampleBoolean" : true,
        "groupingId" : "AD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/ACPActorProvider"
        },
        "name" : "ACP Actor Provider",
        "description" : "The ACP Actor Provider is a system that responds to data access requests for digital health and administrative information.",
        "exampleBoolean" : true,
        "groupingId" : "AD"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/ACP-zib2020"
        },
        "name" : "ACP Questionnaire based on zib2020",
        "description" : "Uniform vastleggen proactieve zorgpanning advance care planning (ACP) o.b.v. zibs2020 - Beta3 28-08-2025",
        "exampleBoolean" : false,
        "groupingId" : "Q-QR"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-Procedure"
        },
        "name" : "Advance Care Planning Procedure",
        "description" : "Advance Care Planning procedure. Based on nl-core-Procedure-event profile and HCIM Procedure.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-AdvanceDirective"
        },
        "name" : "AdvanceDirective",
        "description" : "A verbal or written description of the patient’s wishes with regard to future medical action or end of their life. A living will is mainly used for situations in which the patient is no longer able to speak about these decisions with their healthcare provider. Based on nl-core-AdvanceDirective and HCIM AdvanceDirective.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-Communication"
        },
        "name" : "Communication",
        "description" : "Communication events that have taken place in context of Advance Care Planning. Based on Communication resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Communication-reason-code"
        },
        "name" : "Communication-reason-code",
        "description" : "ReasonCode for the Communication",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-ContactPerson"
        },
        "name" : "ContactPerson",
        "description" : "A person not being a healthcare professional who is involved in the patient’s care, such as family members, caregivers, mental caretakers, guardians and legal representatives. Based on nl-core-ContactPerson and HCIM ContactPerson.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-Encounter"
        },
        "name" : "Encounter",
        "description" : "Any interaction, regardless of the situation, between a patient and the healthcare provider, in which the healthcare provider has primary responsibility for diagnosing, evaluating and treating the patient’s condition and informing the patient. These can be visits, appointments or non face-to-face interactions. Based on nl-core-Encounter and HCIM Encounter.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ACP-EuthanasiaStatement"
        },
        "name" : "Euthanasia Statement",
        "description" : "ValueSet for Position Regarding Euthanasia, representing the the patient's position regarding euthanasia and information on the presence of a euthanasia statement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-EncounterReference"
        },
        "name" : "ext Encounter Reference",
        "description" : "An extension to link the Encounter during which the Consent, Goal or DeviceUseStatement was created or to which the creation is tightly associated.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions"
        },
        "name" : "ext LegallyCapable regarding medical treatment decisions",
        "description" : "An extension to indicate the patient's legal capability regarding medical treatment decisions, and to provide a comment on this capability.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/F1-ACP-Procedure-01-10-2020"
        },
        "name" : "F1 ACP ACPProcedure 01-10-2020",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Procedure|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Communication"
          }
        ],
        "reference" : {
          "reference" : "Communication/F1-ACP-Communication-01-10-2020"
        },
        "name" : "F1 ACP Communication",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Communication|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/F1-ACP-ContactPerson-MichielHartman"
        },
        "name" : "F1 ACP ContactPerson Michiel Hartman",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/F1-ACP-OrganDonationChoiceRegistration-Yes"
        },
        "name" : "F1 ACP Donor Registration Yes",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-OrganDonationChoiceRegistration|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/F1-ACP-Encounter-01-10-2020"
        },
        "name" : "F1 ACP Encounter 01-10-2020",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/F1-ACP-HealthProfessional-Practitioner-DrVanHuissen"
        },
        "name" : "F1 ACP HealthProfessional Practitioner Dr. van Huissen",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-Practitioner|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen"
        },
        "name" : "F1 ACP HealthProfessional PractitionerRole Dr. van Huissen",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Goal"
          }
        ],
        "reference" : {
          "reference" : "Goal/F1-ACP-Medical-Policy-Goal"
        },
        "name" : "F1 ACP Medical Policy Goal - Life-sustaining treatment",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Medical-Policy-Goal|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceUseStatement"
          }
        ],
        "reference" : {
          "reference" : "DeviceUseStatement/F1-ACP-MedicalDevice-ICD"
        },
        "name" : "F1 ACP MedicalDevice ICD",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-MedicalDevice|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/F1-ACP-MedicalDevice.Product-ICD"
        },
        "name" : "F1 ACP MedicalDevice.Product ICD",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-MedicalDevice.Product-ICD|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/F1-ACP-OtherImportantInformation"
        },
        "name" : "F1 ACP Other Important Information",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-OtherImportantInformation|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/F1-ACP-Patient-HendrikHartman"
        },
        "name" : "F1 ACP Patient Hendrik Hartman",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/F1-ACP-PositionRegardingEuthanasia-Unknown"
        },
        "name" : "F1 ACP Position Regarding Euthanasia Unknown",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-PositionRegardingEuthanasia|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/F1-ACP-PreferredPlaceOfDeath-Unknown"
        },
        "name" : "F1 ACP Preferred Place Of Death Unknown",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-PreferredPlaceOfDeath|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/F1-ACP-SpecificCareWishes"
        },
        "name" : "F1 ACP Specific Care Wishes",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-SpecificCareWishes|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/F1-ACP-TreatmentDirective-400231000146108"
        },
        "name" : "F1 ACP TreatmentDirective",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/F1-ACP-TreatmentDirective-116762002"
        },
        "name" : "F1 ACP TreatmentDirective 116762002",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/F1-ACP-TreatmentDirective-281789004"
        },
        "name" : "F1 ACP TreatmentDirective 281789004",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/F1-ACP-TreatmentDirective-305351004"
        },
        "name" : "F1 ACP TreatmentDirective 305351004",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/F1-ACP-TreatmentDirective-32485007"
        },
        "name" : "F1 ACP TreatmentDirective 32485007",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/F1-ACP-TreatmentDirective-40617009"
        },
        "name" : "F1 ACP TreatmentDirective 40617009",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/F1-ACP-TreatmentDirective-89666000"
        },
        "name" : "F1 ACP TreatmentDirective 89666000",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/F2-ACP-TreatmentDirective-305351004"
        },
        "name" : "F2 ACP TreatmentDirective 305351004",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-HealthProfessional-Practitioner"
        },
        "name" : "HealthProfessional Practitioner",
        "description" : "A person who is authorized to perform actions in the field of individual healthcare. Based on nl-core-HealthProfessionalPractitioner and HCIM HealthProfessional.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-HealthProfessional-PractitionerRole"
        },
        "name" : "HealthProfessional PractitionerRole",
        "description" : "The specialty of a person who is authorized to perform actions in the field of individual healthcare. Based on nl-core-HealthProfessionalPractitionerRole and HCIM HealthProfessional.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-Medical-Policy-Goal"
        },
        "name" : "Medical Policy Goal",
        "description" : "The primary, agreed-upon goal of a patient's medical treatment policy. Based on Goal resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-MedicalDevice"
        },
        "name" : "MedicalDevice",
        "description" : "Any internally implanted and external devices and/or aids used by the patient (in the past) to reduce the effects of functional limitations in organ systems or to facilitate the treatment of a disease. In the context of ACP, this profile is used to declare the use of an implantable cardioverter defibrillator (ICD). Based on nl-core-MedicalDevice and HCIM MedicalDevice.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-MedicalDevice.Product-ICD"
        },
        "name" : "MedicalDevice Product ICD",
        "description" : "The medical device (internally or externally). In the context of ACP, this profile is used to capture information on a patient's implantable cardioverter defibrillator (ICD). Based on nl-core-MedicalDeviceProduct and HCIM MedicalDevice.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ACP-MedicalDeviceProductType-ICD"
        },
        "name" : "MedicalDevice ProductType ICD",
        "description" : "ICD product code for MedicalDevice ProductType.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ACP-MedicalPolicyGoal"
        },
        "name" : "Most Important Agreed-upon Goal of Medical Policy",
        "description" : "ValueSet for Medical Policy Goal, representing the primary agreed-upon goal of a patient's medical treatment policy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-OrganDonationChoiceRegistration"
        },
        "name" : "Organ donation choice registration in donor register",
        "description" : "Answer, captured in an observation, to the question: 'Is the choice on organ donation recorded in the donor register?' Based on Observation resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-OtherImportantInformation"
        },
        "name" : "Other Important Information",
        "description" : "Other relevant and important information related to the Patient’s Advance Care Planning (ACP) agreements. Based on Observation resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/P2-ACP-Procedure-07-08-2025"
        },
        "name" : "P2 ACP ACPProcedure 07-08-2025",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Procedure|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/P2-ACP-Procedure-28-07-2024"
        },
        "name" : "P2 ACP ACPProcedure 28-07-2024",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Procedure|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-AdvanceDirective"
        },
        "name" : "P2 ACP AdvanceDirective",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-AdvanceDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Communication"
          }
        ],
        "reference" : {
          "reference" : "Communication/P2-ACP-Communication-07-08-2025"
        },
        "name" : "P2 ACP Communication",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Communication|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/P2-ACP-ContactPerson-GertJanDeJong"
        },
        "name" : "P2 ACP ContactPerson Gert-Jan de Jong",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/P2-ACP-ContactPerson-MayaVanDerSluijsMulder"
        },
        "name" : "P2 ACP ContactPerson Maya van der Sluijs-Mulder",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/P2-ACP-Encounter-07-08-2025"
        },
        "name" : "P2 ACP Encounter 07-08-2025",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/P2-ACP-Encounter-28-07-2024"
        },
        "name" : "P2 ACP Encounter 28-07-2025",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/P2-ACP-HealthProfessional-Practitioner-DesireeWolters"
        },
        "name" : "P2 ACP HealthProfessional Practitioner Desiree Wolters",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-Practitioner|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/P2-ACP-HealthProfessional-Practitioner-Santos"
        },
        "name" : "P2 ACP HealthProfessional Practitioner Santos",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-Practitioner|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters"
        },
        "name" : "P2 ACP HealthProfessional PractitionerRole Desiree Wolters",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-Santos"
        },
        "name" : "P2 ACP HealthProfessional PractitionerRole Santos",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Goal"
          }
        ],
        "reference" : {
          "reference" : "Goal/P2-ACP-Medical-Policy-Goal"
        },
        "name" : "P2 ACP Medical Policy Goal - Life-sustaining treatment",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Medical-Policy-Goal|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceUseStatement"
          }
        ],
        "reference" : {
          "reference" : "DeviceUseStatement/P2-ACP-MedicalDevice-ICD"
        },
        "name" : "P2 ACP MedicalDevice ICD",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-MedicalDevice|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/P2-ACP-MedicalDevice.Product-ICD"
        },
        "name" : "P2 ACP MedicalDevice.Product ICD",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-MedicalDevice.Product-ICD|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/P2-ACP-OrganDonationChoiceRegistration-20250807"
        },
        "name" : "P2 ACP Organ Donation Choice Registration 2025 08 07",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-OrganDonationChoiceRegistration|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/P2-ACP-OtherImportantInformation-20250807"
        },
        "name" : "P2 ACP Other Important Information 2025 08 07",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-OtherImportantInformation|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs"
        },
        "name" : "P2 ACP Patient Samira van der Sluijs",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/P2-ACP-PositionRegardingEuthanasia-20250807"
        },
        "name" : "P2 ACP Position Regarding Euthanasia 2025 08 07",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-PositionRegardingEuthanasia|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/P2-ACP-PreferredPlaceOfDeath-20250807"
        },
        "name" : "P2 ACP Preferred Place Of Death 2025 08 07",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-PreferredPlaceOfDeath|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/P2-ACP-SpecificCareWishes-20250807"
        },
        "name" : "P2 ACP Specific Care Wishes 2025 08 07",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-SpecificCareWishes|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-TreatmentDirective-281789004"
        },
        "name" : "P2 ACP TreatmentDirective 281789004",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-TreatmentDirective-305351004"
        },
        "name" : "P2 ACP TreatmentDirective 305351004",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-TreatmentDirective-32485007"
        },
        "name" : "P2 ACP TreatmentDirective 32485007",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-TreatmentDirective-400231000146108"
        },
        "name" : "P2 ACP TreatmentDirective 400231000146108",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-TreatmentDirective-40617009-1"
        },
        "name" : "P2 ACP TreatmentDirective 40617009-1",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-TreatmentDirective-40617009-2"
        },
        "name" : "P2 ACP TreatmentDirective 40617009-2",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-TreatmentDirective-89666000"
        },
        "name" : "P2 ACP TreatmentDirective 89666000",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/P2-ACP-TreatmentDirective-other"
        },
        "name" : "P2 ACP TreatmentDirective other",
        "exampleCanonical" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective|1.0.0-rc1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-Patient"
        },
        "name" : "Patient",
        "description" : "A person who receives medical, psychological, paramedical, or nursing care. Based on nl-core-Patient and HCIM Patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-PositionRegardingEuthanasia"
        },
        "name" : "Position Regarding Euthanasia",
        "description" : "The patient's position regarding euthanasia. Based on Observation resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-PreferredPlaceOfDeath"
        },
        "name" : "Preferred Place Of Death",
        "description" : "The preferred place of death. This is the place where the patient prefers to die, if possible. The preferred place of death can be a home, a hospital, a nursing home, hospice or another location. Based on Observation resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ACP-PreferredPlaceOfDeath"
        },
        "name" : "Preferred Place Of Death",
        "description" : "ValueSet for Preferred Place of Death, representing the place where the patient prefers to die, if possible.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "QuestionnaireResponse"
          }
        ],
        "reference" : {
          "reference" : "QuestionnaireResponse/HendrikHartman-20201001"
        },
        "name" : "QuestionnaireResponse Hendrik Hartman 20201001",
        "description" : "An example of a QuestionnaireResponse for Hendrik Hartman on 2020-10-01",
        "exampleBoolean" : false,
        "groupingId" : "Q-QR"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "QuestionnaireResponse"
          }
        ],
        "reference" : {
          "reference" : "QuestionnaireResponse/HendrikHartman-20221108"
        },
        "name" : "QuestionnaireResponse Hendrik Hartman 20221108",
        "description" : "An example of a QuestionnaireResponse for Hendrik Hartman on 2022-11-08",
        "exampleBoolean" : false,
        "groupingId" : "Q-QR"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-SpecificCareWishes"
        },
        "name" : "Specific Care Wishes",
        "description" : "The patient's wishes and expectations concerning their treatment, as an answer to the questions: 'What, according to the patient, should healthcare providers know to provide good care? Does this patient have specific wishes regarding their care (including cultural, religious, social, and spiritual aspects)?' Based on Observation resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ACP-TreatmentDirective"
        },
        "name" : "TreatmentDirective",
        "description" : "A joint decision between a health professional (for example a general practitioner) and a patient or his representative(s) about the desirability of performing a certain treatment, such as resuscitation, before this treatment becomes (acute) necessary. Based on nl-core-TreatmentDirective2 and HCIM TreatmentDirective2.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ACP-YesNoUnknownVS"
        },
        "name" : "Yes, No, Unknown valueSet",
        "description" : "ValueSet representing 'Yes, No, Unknown' answers.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "information-standard.html"
            }
          ],
          "nameUrl" : "information-standard.html",
          "title" : "Information Standard",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "data-model.html"
            }
          ],
          "nameUrl" : "data-model.html",
          "title" : "Data Model Overview",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "data-exchange.html"
            }
          ],
          "nameUrl" : "data-exchange.html",
          "title" : "Data Exchange Overview",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "changelog.html"
            }
          ],
          "nameUrl" : "changelog.html",
          "title" : "Change Log",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
