# Data Exchange Overview - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* **Data Exchange Overview**

## Data Exchange Overview

This page describes the two transaction methods for exchanging a patient's Advance Care Planning (ACP) information using RESTful API.

1. As individual resources. By fetching specific resources (`Consent`,`Goal`,`Observation`, etc.) that together form the patient's ACP. See[Data Model page](data-model.md)for a complete overview.
1. As a form. Fetching`QuestionnaireResponse`resource(s). This contains the ACP agreements recorded according to the structured form for uniform registration of ACP.

This guide, in conjunction with its STU3 counterpart, specifies four distinct transactions for data exchange:

1. [R4 Individual Resources](#method-1-retrieve-acp-as-individual-resources)
1. [R4 QuestionnaireResponse](#method-2-retrieve-acp-questionnaireresponse)
1. STU3 Individual Resources
1. STU3 QuestionnaireResponse

### Conformance Requirements Actors

This implementation guide defines two actors:

* [ACP Actor Consulter](ActorDefinition-ACPActorConsulter.md): a client application that retrieves a patient's ACP information.
* [ACP Actor Provider](ActorDefinition-ACPActorProvider.md): a server application that exposes a patient's ACP information.

To be conformant the ACP Actor Consulter SHALL support all four transaction groups. This ensures the actor can retrieve ACP information from any provider, regardless of the FHIR version (STU3 or R4) or exchange method implemented. The ACP Actor Provider SHALL support at least one of the four transaction groups. The individual resources method is preferred over the form-based method for system-to-system exchange, as it offers a more standardized and reusable data structure.

### General API requirements

All interactions adhere to the following principles.

1. **Authorization**: Accessing ACP information is subject to strict privacy and security rules. All API requests MUST be properly authenticated and authorized. The client application is expected to use a secure mechanism to obtain an access token with the necessary scopes to read the patient's clinical data. The exact methods may be found in the used infrastructure specification and agreements of e.g. LSP, Twiin and or Nuts.
1. **Patient Context**: All queries described in this guide are patient-specific. The client MUST know the logical ID of the patient in question and include it in every query (e.g.,`patient=123`or`subject=Patient/123`). This may require an initial request on the Patient endpoint with a search using a patient identifier like the BSN. This may also be described by other technical agreements.
1. **Resolving references**: The returned resources may contain nested resources or references to other resources (like`Practitioner`or`RelatedPerson`). The client application may need to perform subsequent requests to resolve these references and display the full details.

-------

### Method 1: Retrieve ACP as Individual Resources

This approach provides granular access to the individual clinical statements that constitute the ACP. It allows applications to query for specific data points without processing an entire form.

This approach is useful for applications that need to query specific parts of a patient's ACP, like treatment wishes or stated goals. While it requires multiple API calls, it provides more granular control and returns the ACP in usable resources. The below listed client requests are in scope of a Patient's context for which an initial request may be needed to match the Patient resource id with an identifier (e.g. BSN).

#### Client Requests

The below listed search requests show how all the ACP agreements, procedural information and relevant clinical context can be retrieved. Information on individuals involved in the ACP process are referenced from these resources and can be retrieved using the `_include` statement as defined below, or by resolving the references. Standard FHIR rules apply on the search syntax.

```
1a GET [base]/Procedure?patient=[id]&code=http://snomed.info/sct|713603004&_include:Procedure:encounter

1b GET [base]/Encounter?patient=[id]&reason-reference:Procedure.code=http://snomed.info/sct|713603004&_include:Encounter:reason-reference

2 GET [base]/Consent?patient=[id]&scope=http://terminology.hl7.org/CodeSystem/consentscope|treatment&category=http://snomed.info/sct|129125009&_include=Consent:actor

3 GET [base]/Consent?patient=[id]&scope=http://terminology.hl7.org/CodeSystem/consentscope|adr&category=http://terminology.hl7.org/CodeSystem/consentcategorycodes|acd&_include=Consent:actor

4 GET [base]/Goal?patient=[id]&description=http://snomed.info/sct|385987000,1351964001,713148004

5 GET [base]/Observation?patient=[id]&code=http://snomed.info/sct|153851000146100,395091006,340171000146104,247751003

6 GET [base]/DeviceUseStatement?patient=[id]&device.type:in=https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-MedicalDeviceProductType-ICD&_include:DeviceUseSatement:device

7 GET [base]/Communication?patient=[id]&reason-code=http://snomed.info/sct|713603004

```

1. Both requests are designed to retrieve the same information, but with different approaches:
* A) Retrieves `Procedure` resources representing ACP procedures and includes the associated `Encounter` resource where the procedure took place.
* B) Retrieves `Encounter` resources that list an ACP procedure as their reason, and includes the referenced resources in the result. Request A is generally preferred because `Encounter.patient` may not always be present; if absent, it indicates the patient was not involved in the Encounter. Using request A ensures these cases are included as well.

1. Retrieves`Consent`resources for Treatment Directives and includes the agreement parties (Patient, ContactPersons, and HealthProfessionals).
1. Retrieves`Consent`resources for Advance Directives and includes the representatives (ContactPersons).
1. Retrieves`Goal`resources with a Medical Policy Goal code in the`Goal.description`.
1. Retrieves`Observation`resources related to specific wishes and plans, as defined by the profiles in the Implementation Guide.
1. Retrieves`DeviceUseStatement`resources for devices representing an ICD, and includes the corresponding`Device`resource.
1. Retrieves`Communication`resources representing all communication events related to the ACP procedure.

#### Advanced Search Parameters Supported

Custom search parameters:

* The `reason-code` parameter allows searching on `Communication.reasonCode`. See the custom `SearchParameter` resource definition in the artifacts tab.
* The `description` parameter allows searching on `Goal.description`. This search parameter is defined from R5 onwards. The parameter definition can be found in the [Search Parameter Registry](https://hl7.org/fhir/searchparameter-registry.html#:~:text=Goal.%E2%80%8Bcategory-,description,-token) and be applied for this version.

The queries above use several search parameter types and modifiers:

* `_include`: Returns referenced resources in the same `Bundle`, reducing the need for additional API calls.
* `in`: A modifier that enables searching against a ValueSet. In the client requests above, it checks if the device type is included in the specified ValueSet of ICD products.
* Chained parameters: Used for searching within referenced resources. For example, to find `DeviceUseStatement` resources with a specific `Device`, or `Encounter` resources that have an advance care planning `Procedure` as their reason.

#### Server Response

Standard FHIR rules apply for every resource request:

* Success: `200 OK`. The server will return a Bundle containing the matching resource(s) for the patient.
* Not Found: If the patient has no matching resources, the server will return a 200 OK with an empty Bundle.

-------

### Method 2: Retrieve ACP QuestionnaireResponse

This approach is used to retrieve the complete form for uniform registration of ACP in its original context. It retrieves `QuestionnaireResponse` resources that contain the content discussed by the individuals involved in the ACP conversation.

This method is included to lower the implementation burden for data providers who already use a form-based registration process. By allowing them to expose their existing form as a `QuestionnaireResponse`, it accelerates the availability of exchangeable ACP data. The trade-off is that this approach requires more effort from the ACP Actor Consulter, as they need to support multiple methods. The preferred method for system-to-system exchange is the individual resources method, as it offers a more standardized and reusable data structure.

#### Client Request

A client retrieves the `QuestionnaireResponse` by performing a `GET` search operation. The search is scoped to a specific patient and is filtered by the canonical URL of the [ACP Questionnaire](Questionnaire-ACP-zib2020.md) to ensure that only the correct form is returned.

> GET [base]/QuestionnaireResponse?subject=Patient/[id]&questionnaire=https://api.iknl.nl/docs/pzp/r4/Questionnaire/ACP-zib2020

#### Server Response

The server follows standard FHIR response rules:

* Success: `200 OK`. The response body will contain a Bundle with the matching QuestionnaireResponse resource(s). Example QuestionnaireResponse resources are available [here](QuestionnaireResponse-HendrikHartman-20201001.md) and [here](QuestionnaireResponse-HendrikHartman-20221108.md).
* Not Found: `200 OK`. If there is no completed form for this patient, the server will return an empty Bundle.

