# Euthanasia Statement - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Euthanasia Statement**

## ValueSet: Euthanasia Statement 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-EuthanasiaStatement | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPEuthanasiaStatementVS |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
ValueSet for Position Regarding Euthanasia, representing the the patient's position regarding euthanasia and information on the presence of a euthanasia statement. 

 **References** 

* [Position Regarding Euthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT Dutch edition 30-Sep 2024
* [codesystem NullFlavor v3.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html)

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ACP-EuthanasiaStatement",
  "url" : "https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-EuthanasiaStatement",
  "version" : "1.0.0-rc1",
  "name" : "ACPEuthanasiaStatementVS",
  "title" : "Euthanasia Statement",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "ValueSet for Position Regarding Euthanasia, representing the the patient's position regarding euthanasia and information on the presence of a euthanasia statement.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "code" : "UNK",
            "display" : "nog onbekend",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "onbekend"
              }
            ]
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "340181000146102",
            "display" : "heeft euthanasieverklaring"
          },
          {
            "code" : "340201000146103",
            "display" : "wil geen euthanasie"
          },
          {
            "code" : "340191000146100",
            "display" : "heeft geen euthanasieverklaring"
          }
        ]
      }
    ]
  }
}

```
