# ext Encounter Reference - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ext Encounter Reference**

## Extension: ext Encounter Reference 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ExtEncounterReference |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

An extension to link the Encounter during which the Consent, Goal or DeviceUseStatement was created or to which the creation is tightly associated.

For some resources it may be important to know the link between the resource and a particular encounter while this is not part of the base resource. This extension allows to link the resource to the Encounter context.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [AdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md), [Medical Policy Goal](StructureDefinition-ACP-Medical-Policy-Goal.md), [MedicalDevice](StructureDefinition-ACP-MedicalDevice.md) and [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)
* Examples for this Extension: [Consent/F1-ACP-TreatmentDirective-116762002](Consent-F1-ACP-TreatmentDirective-116762002.md), [Consent/F1-ACP-TreatmentDirective-281789004](Consent-F1-ACP-TreatmentDirective-281789004.md), [Consent/F1-ACP-TreatmentDirective-305351004](Consent-F1-ACP-TreatmentDirective-305351004.md), [Consent/F1-ACP-TreatmentDirective-32485007](Consent-F1-ACP-TreatmentDirective-32485007.md)...Show 17 more,[Consent/F1-ACP-TreatmentDirective-400231000146108](Consent-F1-ACP-TreatmentDirective-400231000146108.md),[Consent/F1-ACP-TreatmentDirective-40617009](Consent-F1-ACP-TreatmentDirective-40617009.md),[Consent/F1-ACP-TreatmentDirective-89666000](Consent-F1-ACP-TreatmentDirective-89666000.md),[Consent/F2-ACP-TreatmentDirective-305351004](Consent-F2-ACP-TreatmentDirective-305351004.md),[Consent/P2-ACP-AdvanceDirective](Consent-P2-ACP-AdvanceDirective.md),[Consent/P2-ACP-TreatmentDirective-281789004](Consent-P2-ACP-TreatmentDirective-281789004.md),[Consent/P2-ACP-TreatmentDirective-305351004](Consent-P2-ACP-TreatmentDirective-305351004.md),[Consent/P2-ACP-TreatmentDirective-32485007](Consent-P2-ACP-TreatmentDirective-32485007.md),[Consent/P2-ACP-TreatmentDirective-400231000146108](Consent-P2-ACP-TreatmentDirective-400231000146108.md),[Consent/P2-ACP-TreatmentDirective-40617009-1](Consent-P2-ACP-TreatmentDirective-40617009-1.md),[Consent/P2-ACP-TreatmentDirective-40617009-2](Consent-P2-ACP-TreatmentDirective-40617009-2.md),[Consent/P2-ACP-TreatmentDirective-89666000](Consent-P2-ACP-TreatmentDirective-89666000.md),[Consent/P2-ACP-TreatmentDirective-other](Consent-P2-ACP-TreatmentDirective-other.md),[DeviceUseStatement/F1-ACP-MedicalDevice-ICD](DeviceUseStatement-F1-ACP-MedicalDevice-ICD.md),[DeviceUseStatement/P2-ACP-MedicalDevice-ICD](DeviceUseStatement-P2-ACP-MedicalDevice-ICD.md),[Goal/F1-ACP-Medical-Policy-Goal](Goal-F1-ACP-Medical-Policy-Goal.md)and[Goal/P2-ACP-Medical-Policy-Goal](Goal-P2-ACP-Medical-Policy-Goal.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ext-EncounterReference)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-EncounterReference.csv), [Excel](StructureDefinition-ext-EncounterReference.xlsx), [Schematron](StructureDefinition-ext-EncounterReference.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-EncounterReference",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
  "version" : "1.0.0-rc1",
  "name" : "ExtEncounterReference",
  "title" : "ext Encounter Reference",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "An extension to link the Encounter during which the Consent, Goal or DeviceUseStatement was created or to which the creation is tightly associated.",
  "purpose" : "For some resources it may be important to know the link between the resource and a particular encounter while this is not part of the base resource. This extension allows to link the resource to the Encounter context.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Consent"
    },
    {
      "type" : "element",
      "expression" : "Goal"
    },
    {
      "type" : "element",
      "expression" : "DeviceUseStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension|4.0.1",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "ext Encounter Reference",
        "definition" : "An extension to link the Encounter during which the Consent, Goal or DeviceUseStatement was created or to which the creation is tightly associated."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Encounter",
        "definition" : "The Encounter during which this resource was created or to which the creation is tightly associated.",
        "comment" : "This will typically be the encounter the event occurred within, but some activities may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. completing the administrative registration after the encounter).",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Encounter|4.0.1"]
          }
        ]
      }
    ]
  }
}

```
