# ContactPerson - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ContactPerson**

## Resource Profile: ContactPerson 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPContactPerson |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
A person not being a healthcare professional who is involved in the patient’s care, such as family members, caregivers, mental caretakers, guardians and legal representatives. Based on nl-core-ContactPerson and HCIM ContactPerson. 

**Usages:**

* Refer to this Profile: [Encounter](StructureDefinition-ACP-Encounter.md), [Patient](StructureDefinition-ACP-Patient.md), [Advance Care Planning Procedure](StructureDefinition-ACP-Procedure.md) and [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)
* Examples for this Profile: [RelatedPerson/F1-ACP-ContactPerson-MichielHartman](RelatedPerson-F1-ACP-ContactPerson-MichielHartman.md), [RelatedPerson/P2-ACP-ContactPerson-GertJanDeJong](RelatedPerson-P2-ACP-ContactPerson-GertJanDeJong.md) and [RelatedPerson/P2-ACP-ContactPerson-MayaVanDerSluijsMulder](RelatedPerson-P2-ACP-ContactPerson-MayaVanDerSluijsMulder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ACP-ContactPerson)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ACP-ContactPerson.csv), [Excel](StructureDefinition-ACP-ContactPerson.xlsx), [Schematron](StructureDefinition-ACP-ContactPerson.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ACP-ContactPerson",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson",
  "version" : "1.0.0-rc1",
  "name" : "ACPContactPerson",
  "title" : "ContactPerson",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "A person not being a healthcare professional who is involved in the patient’s care, such as family members, caregivers, mental caretakers, guardians and legal representatives. Based on nl-core-ContactPerson and HCIM ContactPerson.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "pall-izppz-zib2020v2025-03-11",
      "uri" : "https://decor.nictiz.nl/exist/apps/api/dataset/2.16.840.1.113883.2.4.3.11.60.117.1.1/2020-07-29T10%3A37%3A48/$view?language=nl-NL&ui=nl-NL&format=html&hidecolumns=3456gh&release=2025-10-29T13%3A09%3A23",
      "name" : "ACP dataset"
    },
    {
      "identity" : "zib-contactperson-v3.4-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactPerson-v3.4(2020EN)",
      "name" : "zib ContactPerson-v3.4(2020EN)"
    },
    {
      "identity" : "zib-contactinformation-v1.2-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.2(2020EN)",
      "name" : "zib ContactInformation-v1.2(2020EN)"
    },
    {
      "identity" : "zib-payer-v3.1.1-2020EN",
      "uri" : "https://zibs.nl/wiki/Payer-v3.1.1(2020EN)",
      "name" : "zib Payer-v3.1.1(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RelatedPerson",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-ContactPerson",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedPerson",
        "path" : "RelatedPerson",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "441",
            "comment" : "Wettelijk vertegenwoordiger (Contactpersoon)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "615",
            "comment" : "Contactpersoon"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "650",
            "comment" : "Contactpersoon"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "696",
            "comment" : "Contactpersoon"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "706",
            "comment" : "Contactpersoon"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "727",
            "comment" : "Contactpersoon"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "478",
            "comment" : "Eerste contactpersoon (Contactpersoon)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "554",
            "comment" : "Gesprek gevoerd in bijzijn van (Contactpersoon)"
          }
        ]
      },
      {
        "id" : "RelatedPerson.patient",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.relationship",
        "path" : "RelatedPerson.relationship",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.relationship:role",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.relationship",
        "sliceName" : "role",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "475",
            "comment" : "Rol"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "477",
            "comment" : "Vertegenwoordiger is contactpersoon"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "512",
            "comment" : "Rol"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "588",
            "comment" : "Rol"
          }
        ]
      },
      {
        "id" : "RelatedPerson.relationship:relationship",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.relationship",
        "sliceName" : "relationship",
        "definition" : "When someone is or **will be** a legal representative, then a relationship code `24` from code system  _urn:oid:2.16.840.1.113883.2.4.3.11.22.472_ is added.",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "476",
            "comment" : "Relatie"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "513",
            "comment" : "Relatie"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "589",
            "comment" : "Relatie"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name",
        "path" : "RelatedPerson.name",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "442",
            "comment" : "Naamgegevens"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "479",
            "comment" : "Naamgegevens"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "555",
            "comment" : "Naamgegevens"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name:nameInformation",
        "path" : "RelatedPerson.name",
        "sliceName" : "nameInformation"
      },
      {
        "id" : "RelatedPerson.name:nameInformation.use",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.name.use",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "446",
            "comment" : "Naamgebruik"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "483",
            "comment" : "Naamgebruik"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "559",
            "comment" : "Naamgebruik"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name:nameInformation.family.extension:prefix",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.name.family.extension",
        "sliceName" : "prefix"
      },
      {
        "id" : "RelatedPerson.name:nameInformation.family.extension:prefix.value[x]",
        "path" : "RelatedPerson.name.family.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "448",
            "comment" : "Voorvoegsels"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "485",
            "comment" : "Voorvoegsels"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "561",
            "comment" : "Voorvoegsels"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name:nameInformation.family.extension:lastName",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.name.family.extension",
        "sliceName" : "lastName"
      },
      {
        "id" : "RelatedPerson.name:nameInformation.family.extension:lastName.value[x]",
        "path" : "RelatedPerson.name.family.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "449",
            "comment" : "Achternaam"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "486",
            "comment" : "Achternaam"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "562",
            "comment" : "Achternaam"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name:nameInformation.family.extension:partnerPrefix",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.name.family.extension",
        "sliceName" : "partnerPrefix"
      },
      {
        "id" : "RelatedPerson.name:nameInformation.family.extension:partnerPrefix.value[x]",
        "path" : "RelatedPerson.name.family.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "451",
            "comment" : "VoorvoegselsPartner"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "488",
            "comment" : "VoorvoegselsPartner"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "564",
            "comment" : "VoorvoegselsPartner"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name:nameInformation.family.extension:partnerLastName",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.name.family.extension",
        "sliceName" : "partnerLastName"
      },
      {
        "id" : "RelatedPerson.name:nameInformation.family.extension:partnerLastName.value[x]",
        "path" : "RelatedPerson.name.family.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "452",
            "comment" : "AchternaamPartner"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "489",
            "comment" : "AchternaamPartner"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "565",
            "comment" : "AchternaamPartner"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name:nameInformation.given",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.name.given",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "443",
            "comment" : "Voornamen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "444",
            "comment" : "Initialen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "480",
            "comment" : "Voornamen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "481",
            "comment" : "Initialen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "556",
            "comment" : "Voornamen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "557",
            "comment" : "Initialen"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name:nameInformation.suffix",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.name.suffix",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "453",
            "comment" : "Titels"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "490",
            "comment" : "Titels"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "566",
            "comment" : "Titels"
          }
        ]
      },
      {
        "id" : "RelatedPerson.name:nameInformation-GivenName",
        "path" : "RelatedPerson.name",
        "sliceName" : "nameInformation-GivenName"
      },
      {
        "id" : "RelatedPerson.name:nameInformation-GivenName.given",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.name.given",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "445",
            "comment" : "Roepnaam"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "482",
            "comment" : "Roepnaam"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "558",
            "comment" : "Roepnaam"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom",
        "path" : "RelatedPerson.telecom",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "454",
            "comment" : "Contactgegevens"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "491",
            "comment" : "Contactgegevens"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:telephoneNumbers",
        "path" : "RelatedPerson.telecom",
        "sliceName" : "telephoneNumbers",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "455",
            "comment" : "Telefoonnummers"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "492",
            "comment" : "Telefoonnummers"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:telephoneNumbers.extension:comment",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "RelatedPerson.telecom.extension",
        "sliceName" : "comment"
      },
      {
        "id" : "RelatedPerson.telecom:telephoneNumbers.extension:comment.value[x]",
        "path" : "RelatedPerson.telecom.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "459",
            "comment" : "Toelichting"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "496",
            "comment" : "Toelichting"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:telephoneNumbers.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.telecom.system",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "457",
            "comment" : "TelecomType"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "494",
            "comment" : "TelecomType"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:telephoneNumbers.system.extension:telecomType",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "RelatedPerson.telecom.system.extension",
        "sliceName" : "telecomType"
      },
      {
        "id" : "RelatedPerson.telecom:telephoneNumbers.system.extension:telecomType.value[x]",
        "path" : "RelatedPerson.telecom.system.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "457",
            "comment" : "TelecomType"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "494",
            "comment" : "TelecomType"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:telephoneNumbers.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.telecom.value",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "456",
            "comment" : "Telefoonnummer"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "493",
            "comment" : "Telefoonnummer"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:telephoneNumbers.use",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.telecom.use",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "458",
            "comment" : "NummerSoort"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "495",
            "comment" : "NummerSoort"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:emailAddresses",
        "path" : "RelatedPerson.telecom",
        "sliceName" : "emailAddresses",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "460",
            "comment" : "EmailAdressen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "497",
            "comment" : "EmailAdressen"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:emailAddresses.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.telecom.system",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "462",
            "comment" : "EmailSoort"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "499",
            "comment" : "EmailSoort"
          }
        ]
      },
      {
        "id" : "RelatedPerson.telecom:emailAddresses.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.telecom.value",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "461",
            "comment" : "EmailAdres"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "498",
            "comment" : "EmailAdres"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address",
        "path" : "RelatedPerson.address",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "463",
            "comment" : "Adresgegevens"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "500",
            "comment" : "Adresgegevens"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.use",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.use",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "474",
            "comment" : "AdresSoort"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "511",
            "comment" : "AdresSoort"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.type",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "474",
            "comment" : "AdresSoort"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "511",
            "comment" : "AdresSoort"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.line.extension:streetName",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.line.extension",
        "sliceName" : "streetName"
      },
      {
        "id" : "RelatedPerson.address.line.extension:streetName.value[x]",
        "path" : "RelatedPerson.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "464",
            "comment" : "Straat"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "501",
            "comment" : "Straat"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.line.extension:houseNumber",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.line.extension",
        "sliceName" : "houseNumber"
      },
      {
        "id" : "RelatedPerson.address.line.extension:houseNumber.value[x]",
        "path" : "RelatedPerson.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "465",
            "comment" : "Huisnummer"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "502",
            "comment" : "Huisnummer"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.line.extension:houseNumberLetter-houseNumberAddition",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.line.extension",
        "sliceName" : "houseNumberLetter-houseNumberAddition"
      },
      {
        "id" : "RelatedPerson.address.line.extension:houseNumberLetter-houseNumberAddition.value[x]",
        "path" : "RelatedPerson.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "466",
            "comment" : "Huisnummerletter"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "467",
            "comment" : "Huisnummertoevoeging"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "503",
            "comment" : "Huisnummerletter"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "504",
            "comment" : "Huisnummertoevoeging"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.line.extension:houseNumberIndication",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.line.extension",
        "sliceName" : "houseNumberIndication"
      },
      {
        "id" : "RelatedPerson.address.line.extension:houseNumberIndication.value[x]",
        "path" : "RelatedPerson.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "468",
            "comment" : "AanduidingBijHuisnummer"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "505",
            "comment" : "AanduidingBijHuisnummer"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.line.extension:additionalInformation",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.line.extension",
        "sliceName" : "additionalInformation"
      },
      {
        "id" : "RelatedPerson.address.line.extension:additionalInformation.value[x]",
        "path" : "RelatedPerson.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "473",
            "comment" : "AdditioneleInformatie"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "510",
            "comment" : "AdditioneleInformatie"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.city",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.city",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "470",
            "comment" : "Woonplaats"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "507",
            "comment" : "Woonplaats"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.district",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.district",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "471",
            "comment" : "Gemeente"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "508",
            "comment" : "Gemeente"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.postalCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "RelatedPerson.address.postalCode",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "469",
            "comment" : "Postcode"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "506",
            "comment" : "Postcode"
          }
        ]
      },
      {
        "id" : "RelatedPerson.address.country.extension:countryCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "RelatedPerson.address.country.extension",
        "sliceName" : "countryCode"
      },
      {
        "id" : "RelatedPerson.address.country.extension:countryCode.value[x]",
        "path" : "RelatedPerson.address.country.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "472",
            "comment" : "Land"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "509",
            "comment" : "Land"
          }
        ]
      }
    ]
  }
}

```
