# AdvanceDirective - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdvanceDirective**

## Resource Profile: AdvanceDirective 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-AdvanceDirective | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPAdvanceDirective |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
A verbal or written description of the patient’s wishes with regard to future medical action or end of their life. A living will is mainly used for situations in which the patient is no longer able to speak about these decisions with their healthcare provider. Based on nl-core-AdvanceDirective and HCIM AdvanceDirective. 

**Usages:**

* Refer to this Profile: [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)
* Examples for this Profile: [Consent/P2-ACP-AdvanceDirective](Consent-P2-ACP-AdvanceDirective.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ACP-AdvanceDirective)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ACP-AdvanceDirective.csv), [Excel](StructureDefinition-ACP-AdvanceDirective.xlsx), [Schematron](StructureDefinition-ACP-AdvanceDirective.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ACP-AdvanceDirective",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-AdvanceDirective",
  "version" : "1.0.0-rc1",
  "name" : "ACPAdvanceDirective",
  "title" : "AdvanceDirective",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "A verbal or written description of the patient’s wishes with regard to future medical action or end of their life. A living will is mainly used for situations in which the patient is no longer able to speak about these decisions with their healthcare provider. Based on nl-core-AdvanceDirective and HCIM AdvanceDirective.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "pall-izppz-zib2020v2025-03-11",
      "uri" : "https://decor.nictiz.nl/exist/apps/api/dataset/2.16.840.1.113883.2.4.3.11.60.117.1.1/2020-07-29T10%3A37%3A48/$view?language=nl-NL&ui=nl-NL&format=html&hidecolumns=3456gh&release=2025-10-29T13%3A09%3A23",
      "name" : "ACP dataset"
    },
    {
      "identity" : "zib-advancedirective-v3.1.1-2020EN",
      "uri" : "https://zibs.nl/wiki/AdvanceDirective-v3.1.1(2020EN)",
      "name" : "zib AdvanceDirective-v3.1.1(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-AdvanceDirective",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "690",
            "comment" : "Euthanasieverklaring (Wilsverklaring)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "700",
            "comment" : "Keuze orgaandonatie vastgelegd (Wilsverklaring)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "721",
            "comment" : "Eerder vastgelegde behandelafspraken (Wilsverklaring)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "610",
            "comment" : "Wilsverklaring"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "645",
            "comment" : "Wilsverklaring"
          }
        ]
      },
      {
        "id" : "Consent.extension:disorder",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Consent.extension",
        "sliceName" : "disorder"
      },
      {
        "id" : "Consent.extension:disorder.value[x]",
        "path" : "Consent.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "693",
            "comment" : "Aandoening"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "703",
            "comment" : "Aandoening"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "724",
            "comment" : "Aandoening"
          }
        ]
      },
      {
        "id" : "Consent.extension:comment",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Consent.extension",
        "sliceName" : "comment"
      },
      {
        "id" : "Consent.extension:comment.value[x]",
        "path" : "Consent.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "698",
            "comment" : "Toelichting"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "708",
            "comment" : "Toelichting"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "729",
            "comment" : "Toelichting"
          }
        ]
      },
      {
        "id" : "Consent.extension:encounter",
        "path" : "Consent.extension",
        "sliceName" : "encounter",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Consent.extension:encounter.value[x]",
        "path" : "Consent.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Consent.patient",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Consent.dateTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.dateTime",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "692",
            "comment" : "WilsverklaringDatum"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "702",
            "comment" : "WilsverklaringDatum"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "723",
            "comment" : "WilsverklaringDatum"
          }
        ]
      },
      {
        "id" : "Consent.source[x]:sourceAttachment",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.source[x]",
        "sliceName" : "sourceAttachment",
        "type" : [
          {
            "code" : "Attachment"
          }
        ],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "697",
            "comment" : "WilsverklaringDocument"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "707",
            "comment" : "WilsverklaringDocument"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "728",
            "comment" : "WilsverklaringDocument"
          }
        ]
      },
      {
        "id" : "Consent.provision.actor:representative",
        "path" : "Consent.provision.actor",
        "sliceName" : "representative"
      },
      {
        "id" : "Consent.provision.actor:representative.reference",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.provision.actor.reference",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "695",
            "comment" : "Vertegenwoordiger"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "705",
            "comment" : "Vertegenwoordiger"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "726",
            "comment" : "Vertegenwoordiger"
          }
        ]
      },
      {
        "id" : "Consent.provision.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.provision.code",
        "definition" : " The following codes are in scope of this profile:\n- For Euthanasia, codes _EU_ (Euthanasieverzoek) or _EUD_ (Euthanasieverzoek met aanvulling Dementie).\n- For Organ Donation, code _DO_ (Verklaring donorschap).",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "691",
            "comment" : "Euthanasieverklaring (WilsverklaringType)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "701",
            "comment" : "Orgaandonatie (WilsverklaringType)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "722",
            "comment" : "WilsverklaringType"
          }
        ]
      }
    ]
  }
}

```
