# F1 ACP ACPProcedure 01-10-2020 - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP ACPProcedure 01-10-2020**

## Example Procedure: F1 ACP ACPProcedure 01-10-2020

Profile: [Advance Care Planning Procedure](StructureDefinition-ACP-Procedure.md)

**identifier**: Resource identifier/64627bfa-f127-4d3a-2387-39426d7937dc

**status**: Completed

**code**: advance care planning

**subject**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**encounter**: [Encounter, 01-10-2020](Encounter-F1-ACP-Encounter-01-10-2020.md)

**performed**: 2020-10-01 --> 2020-10-01

> **performer****actor**:[Healthcare professional (role), van Huissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md)

> **performer****actor**:[ContactPerson, Michiel Hartman](RelatedPerson-F1-ACP-ContactPerson-MichielHartman.md)

> **performer****actor**:[Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "F1-ACP-Procedure-01-10-2020",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Procedure"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "64627bfa-f127-4d3a-2387-39426d7937dc"
    }
  ],
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "713603004",
        "display" : "advance care planning"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "encounter" : {
    "reference" : "Encounter/F1-ACP-Encounter-01-10-2020",
    "display" : "Encounter, 01-10-2020"
  },
  "performedPeriod" : {
    "start" : "2020-10-01",
    "end" : "2020-10-01"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen",
        "type" : "PractitionerRole",
        "display" : "Healthcare professional (role), van Huissen"
      }
    },
    {
      "actor" : {
        "reference" : "RelatedPerson/F1-ACP-ContactPerson-MichielHartman",
        "type" : "RelatedPerson",
        "display" : "ContactPerson, Michiel Hartman"
      }
    },
    {
      "actor" : {
        "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
        "type" : "Patient",
        "display" : "Patient, Hendrik Hartman"
      }
    }
  ]
}

```
