# F1 ACP Patient Hendrik Hartman - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP Patient Hendrik Hartman**

## Example Patient: F1 ACP Patient Hendrik Hartman

Profile: [Patient](StructureDefinition-ACP-Patient.md)

Hendrik (no stated gender), DoB: 1961-01-01 ( http://fhir.nl/fhir/NamingSystem/bsn#999911120)

-------

| | |
| :--- | :--- |
| Alt. Name: | Hendrik Hartman(Official) |
| Contact: | * Michiel Hartman(Official)
* Relationships:Eerste relatie/contactpersoon, Wettelijke vertegenwoordiger, brother
* [michiel.hartman@iknl.nl](mailto:michiel.hartman@iknl.nl)
 |
| ext LegallyCapable regarding medical treatment decisions: | * legallyCapable: true
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "F1-ACP-Patient-HendrikHartman",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "legallyCapable",
          "valueBoolean" : true
        }
      ],
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions"
    }
  ],
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/bsn",
      "value" : "999911120"
    }
  ],
  "name" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order",
          "valueCode" : "NL1"
        }
      ],
      "use" : "official",
      "text" : "Hendrik Hartman",
      "family" : "Hartman",
      "_family" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
            "valueString" : "Hartman"
          }
        ]
      },
      "given" : ["Hendrik"],
      "_given" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier",
              "valueCode" : "BR"
            }
          ]
        }
      ]
    },
    {
      "use" : "usual",
      "given" : ["Hendrik"]
    }
  ],
  "birthDate" : "1961-01-01",
  "contact" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/patient-relatedPerson",
          "valueReference" : {
            "reference" : "RelatedPerson/F1-ACP-ContactPerson-MichielHartman"
          }
        }
      ],
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.2.4.3.11.22.472",
              "code" : "01",
              "display" : "Eerste relatie/contactpersoon"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.2.4.3.11.22.472",
              "code" : "24",
              "display" : "Wettelijke vertegenwoordiger"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "BRO",
              "display" : "brother"
            }
          ]
        }
      ],
      "name" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order",
            "valueCode" : "NL1"
          }
        ],
        "use" : "official",
        "text" : "Michiel Hartman",
        "family" : "Hartman",
        "_family" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
              "valueString" : "Hartman"
            }
          ]
        },
        "given" : ["Michiel"],
        "_given" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier",
                "valueCode" : "BR"
              }
            ]
          }
        ]
      },
      "telecom" : [
        {
          "system" : "email",
          "value" : "michiel.hartman@iknl.nl",
          "use" : "work"
        }
      ]
    }
  ]
}

```
