# P2 ACP Encounter 28-07-2025 - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP Encounter 28-07-2025**

## Example Encounter: P2 ACP Encounter 28-07-2025

Profile: [Encounter](StructureDefinition-ACP-Encounter.md)

**identifier**: Resource identifier/4fd4a47f-e5a2-410d-8f3b-10bd58539013

**status**: Finished

**class**: [ActCode: IMP](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**subject**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

> **participant****individual**:[Healthcare professional (role), Desiree Wolters](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters.md)

> **participant****individual**:[ContactPerson, Gert-Jan de Jong](RelatedPerson-P2-ACP-ContactPerson-GertJanDeJong.md)

**period**: 2024-07-28 --> 2024-07-28

**reasonReference**: [Procedure, ACP](Procedure-P2-ACP-Procedure-28-07-2024.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "P2-ACP-Encounter-28-07-2024",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "4fd4a47f-e5a2-410d-8f3b-10bd58539013"
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP",
    "display" : "inpatient encounter"
  },
  "subject" : {
    "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
    "display" : "Patient, Samira van der Sluijs"
  },
  "participant" : [
    {
      "individual" : {
        "reference" : "PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters",
        "type" : "PractitionerRole",
        "display" : "Healthcare professional (role), Desiree Wolters"
      }
    },
    {
      "individual" : {
        "reference" : "RelatedPerson/P2-ACP-ContactPerson-GertJanDeJong",
        "type" : "RelatedPerson",
        "display" : "ContactPerson, Gert-Jan de Jong"
      }
    }
  ],
  "period" : {
    "start" : "2024-07-28",
    "end" : "2024-07-28"
  },
  "reasonReference" : [
    {
      "extension" : [
        {
          "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-Comment",
          "valueString" : "Eerste PZP gesprek van mevrouw "
        }
      ],
      "reference" : "Procedure/P2-ACP-Procedure-28-07-2024",
      "display" : "Procedure, ACP"
    }
  ]
}

```
