# F1 ACP Encounter 01-10-2020 - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP Encounter 01-10-2020**

## Example Encounter: F1 ACP Encounter 01-10-2020

Profile: [Encounter](StructureDefinition-ACP-Encounter.md)

**identifier**: Resource identifier/64627bfa-a127-4d3a-8187-39426d7937dc

**status**: Finished

**class**: [ActCode: IMP](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**subject**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

> **participant****individual**:[Healthcare professional (role), van Huissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md)

> **participant****individual**:[ContactPerson, Michiel Hartman](RelatedPerson-F1-ACP-ContactPerson-MichielHartman.md)

**period**: 2020-10-01 --> 2020-10-01

**reasonReference**: [Procedure, ACP](Procedure-F1-ACP-Procedure-01-10-2020.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "F1-ACP-Encounter-01-10-2020",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "64627bfa-a127-4d3a-8187-39426d7937dc"
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP",
    "display" : "inpatient encounter"
  },
  "subject" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "participant" : [
    {
      "individual" : {
        "reference" : "PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen",
        "type" : "PractitionerRole",
        "display" : "Healthcare professional (role), van Huissen"
      }
    },
    {
      "individual" : {
        "reference" : "RelatedPerson/F1-ACP-ContactPerson-MichielHartman",
        "type" : "RelatedPerson",
        "display" : "ContactPerson, Michiel Hartman"
      }
    }
  ],
  "period" : {
    "start" : "2020-10-01",
    "end" : "2020-10-01"
  },
  "reasonReference" : [
    {
      "reference" : "Procedure/F1-ACP-Procedure-01-10-2020",
      "display" : "Procedure, ACP"
    }
  ]
}

```
