# F1 ACP MedicalDevice ICD - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP MedicalDevice ICD**

## Example DeviceUseStatement: F1 ACP MedicalDevice ICD

Profile: [MedicalDevice](StructureDefinition-ACP-MedicalDevice.md)

**ext Encounter Reference**: [Encounter, 2020-10-01](Encounter-F1-ACP-Encounter-01-10-2020.md)

**identifier**: Resource identifier/99a671c0-f756-4c29-bba2-ad8d6f05a5fe

**status**: Active

**subject**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**timing**: 2018 --> (ongoing)

**device**: [Device: identifier = Resource identifier: 00e66024-84a5-44f8-84e9-f8ac339bfd5a; type = implanteerbare cardioverter-defibrillator](Device-F1-ACP-MedicalDevice.Product-ICD.md)

**note**: 

> 

Geïmplanteerd in 2018




## Resource Content

```json
{
  "resourceType" : "DeviceUseStatement",
  "id" : "F1-ACP-MedicalDevice-ICD",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-MedicalDevice"
    ]
  },
  "extension" : [
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/F1-ACP-Encounter-01-10-2020",
        "display" : "Encounter, 2020-10-01"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "99a671c0-f756-4c29-bba2-ad8d6f05a5fe"
    }
  ],
  "status" : "active",
  "subject" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "timingPeriod" : {
    "start" : "2018"
  },
  "device" : {
    "reference" : "Device/F1-ACP-MedicalDevice.Product-ICD"
  },
  "note" : [
    {
      "text" : "Geïmplanteerd in 2018"
    }
  ]
}

```
