# P2 ACP TreatmentDirective 40617009-1 - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP TreatmentDirective 40617009-1**

## Example Consent: P2 ACP TreatmentDirective 40617009-1

Profile: [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)

**ext Encounter Reference**: [Encounter, 2024-07-28](Encounter-P2-ACP-Encounter-28-07-2024.md)

**ext TreatmentDirective2.SpecificationOther**: Onbekend

**identifier**: Resource identifier/bc70c02f-f4f3-44a1-833b-41965885cc02

**status**: Inactive

**scope**: Treatment

**category**: Context-dependent procedure

**patient**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

**dateTime**: 2024-07-28

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [https://wetten.overheid.nl/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://wetten.overheid.nl/) |

> **provision****period**: ?? --> 2025-06-09
> **actor****role**:consenter**reference**:[Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

> **actor****role**:consenter**reference**:[Healthcare professional (role), Desiree Wolters](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters.md)
**code**:kunstmatige beademing



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "P2-ACP-TreatmentDirective-40617009-1",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective"
    ]
  },
  "extension" : [
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/P2-ACP-Encounter-28-07-2024",
        "display" : "Encounter, 2024-07-28"
      }
    }
  ],
  "modifierExtension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-TreatmentDirective2.SpecificationOther",
      "valueString" : "Onbekend"
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "bc70c02f-f4f3-44a1-833b-41965885cc02"
    }
  ],
  "status" : "inactive",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "treatment"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "129125009"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
    "display" : "Patient, Samira van der Sluijs"
  },
  "dateTime" : "2024-07-28",
  "policy" : [
    {
      "uri" : "https://wetten.overheid.nl/"
    }
  ],
  "provision" : {
    "period" : {
      "end" : "2025-06-09"
    },
    "actor" : [
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
          "type" : "Patient",
          "display" : "Patient, Samira van der Sluijs"
        }
      },
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters",
          "type" : "PractitionerRole",
          "display" : "Healthcare professional (role), Desiree Wolters"
        }
      }
    ],
    "code" : [
      {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "40617009",
            "display" : "kunstmatige beademing"
          }
        ]
      }
    ]
  }
}

```
