# P2 ACP TreatmentDirective 32485007 - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP TreatmentDirective 32485007**

## Example Consent: P2 ACP TreatmentDirective 32485007

Profile: [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)

**ext Encounter Reference**: [Encounter, 2025-08-07](Encounter-P2-ACP-Encounter-07-08-2025.md)

**ext TreatmentDirective2.SpecificationOther**: Alleen als de patiënt een kans heeft om weer uit het ziekenhuis te komen, anders hoeft het niet meer van mevrouw.

**identifier**: Resource identifier/e70a0ec8-f77a-4c4d-8876-c9103f09bbc2

**status**: Active

**scope**: Treatment

**category**: Context-dependent procedure

**patient**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

**dateTime**: 2025-08-07

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [https://wetten.overheid.nl/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://wetten.overheid.nl/) |

> **provision**
> **actor****role**:consenter**reference**:[Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

> **actor****role**:consenter**reference**:[Healthcare professional (role), Desiree Wolters](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters.md)
**code**:opname in ziekenhuis



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "P2-ACP-TreatmentDirective-32485007",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective"
    ]
  },
  "extension" : [
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/P2-ACP-Encounter-07-08-2025",
        "display" : "Encounter, 2025-08-07"
      }
    }
  ],
  "modifierExtension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-TreatmentDirective2.SpecificationOther",
      "valueString" : "Alleen als de patiënt een kans heeft om weer uit het ziekenhuis te komen, anders hoeft het niet meer van mevrouw."
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "e70a0ec8-f77a-4c4d-8876-c9103f09bbc2"
    }
  ],
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "treatment"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "129125009"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
    "display" : "Patient, Samira van der Sluijs"
  },
  "dateTime" : "2025-08-07",
  "policy" : [
    {
      "uri" : "https://wetten.overheid.nl/"
    }
  ],
  "provision" : {
    "actor" : [
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
          "type" : "Patient",
          "display" : "Patient, Samira van der Sluijs"
        }
      },
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters",
          "type" : "PractitionerRole",
          "display" : "Healthcare professional (role), Desiree Wolters"
        }
      }
    ],
    "code" : [
      {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "32485007",
            "display" : "opname in ziekenhuis"
          }
        ]
      }
    ]
  }
}

```
