# P2 ACP AdvanceDirective - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP AdvanceDirective**

## Example Consent: P2 ACP AdvanceDirective

Profile: [AdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)

**ext Encounter Reference**: [Encounter, 2025-08-07](Encounter-P2-ACP-Encounter-07-08-2025.md)

**identifier**: Resource identifier/db81a3f9-bec0-4437-bc2c-8907d94bf766

**status**: Active

**scope**: Advanced Care Directive

**category**: Advance Directive

**patient**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

**dateTime**: 2025-06-28

**source**: application/pdf: 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

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [https://wetten.overheid.nl/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://wetten.overheid.nl/) |

> **provision**

### Actors

| | | |
| :--- | :--- | :--- |
| - | **Role** | **Reference** |
| * | responsible party | [Contactpersoon Gert-Jan de Jong](RelatedPerson-P2-ACP-ContactPerson-GertJanDeJong.md) |

**code**:Niet reanimeren verklaring



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "P2-ACP-AdvanceDirective",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-AdvanceDirective"
    ]
  },
  "extension" : [
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/P2-ACP-Encounter-07-08-2025",
        "display" : "Encounter, 2025-08-07"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "db81a3f9-bec0-4437-bc2c-8907d94bf766"
    }
  ],
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "adr"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/consentcategorycodes",
          "code" : "acd"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
    "display" : "Patient, Samira van der Sluijs"
  },
  "dateTime" : "2025-06-28",
  "sourceAttachment" : {
    "contentType" : "application/pdf",
    "data" : "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",
    "title" : "niet reanimeren verklaring"
  },
  "policy" : [
    {
      "uri" : "https://wetten.overheid.nl/"
    }
  ],
  "provision" : {
    "actor" : [
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "RESPRSN"
            }
          ]
        },
        "reference" : {
          "reference" : "RelatedPerson/P2-ACP-ContactPerson-GertJanDeJong",
          "type" : "RelatedPerson",
          "display" : "Contactpersoon Gert-Jan de Jong"
        }
      }
    ],
    "code" : [
      {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.2.4.3.11.60.40.4.14.1",
            "code" : "NR",
            "display" : "Niet reanimeren verklaring"
          }
        ]
      }
    ]
  }
}

```
