# P2 ACP Communication - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP Communication**

## Example Communication: P2 ACP Communication

Profile: [Communication](StructureDefinition-ACP-Communication.md)

**identifier**: Resource identifier/c9736fd7-467c-497f-9235-d4efa8d46a34

**status**: Completed

**subject**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

**topic**: Informing the patient about their own responsibility to discuss these treatment agreements with relatives.

**sent**: 2025-08-07

**recipient**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

**sender**: [Healthcare professional (role), Desiree Wolters](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters.md)

**reasonCode**: advance care planning



## Resource Content

```json
{
  "resourceType" : "Communication",
  "id" : "P2-ACP-Communication-07-08-2025",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Communication"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "c9736fd7-467c-497f-9235-d4efa8d46a34"
    }
  ],
  "status" : "completed",
  "subject" : {
    "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
    "display" : "Patient, Samira van der Sluijs"
  },
  "topic" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "223449006",
        "display" : "adviseren om iemand te informeren"
      }
    ],
    "text" : "Informing the patient about their own responsibility to discuss these treatment agreements with relatives."
  },
  "sent" : "2025-08-07",
  "recipient" : [
    {
      "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
      "display" : "Patient, Samira van der Sluijs"
    }
  ],
  "sender" : {
    "reference" : "PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters",
    "display" : "Healthcare professional (role), Desiree Wolters"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "713603004",
          "display" : "advance care planning"
        }
      ]
    }
  ]
}

```
