# F1 ACP Communication - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP Communication**

## Example Communication: F1 ACP Communication

Profile: [Communication](StructureDefinition-ACP-Communication.md)

**identifier**: Resource identifier/dd6d7146-1014-4ef4-9145-e8207364c942

**status**: Completed

**subject**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**topic**: Informing the patient about their own responsibility to discuss these treatment agreements with relatives.

**sent**: 2020-10-01

**recipient**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**sender**: [Healthcare professional (role), van Huissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md)

**reasonCode**: advance care planning



## Resource Content

```json
{
  "resourceType" : "Communication",
  "id" : "F1-ACP-Communication-01-10-2020",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Communication"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "dd6d7146-1014-4ef4-9145-e8207364c942"
    }
  ],
  "status" : "completed",
  "subject" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "topic" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "223449006",
        "display" : "adviseren om iemand te informeren"
      }
    ],
    "text" : "Informing the patient about their own responsibility to discuss these treatment agreements with relatives."
  },
  "sent" : "2020-10-01",
  "recipient" : [
    {
      "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
      "display" : "Patient, Hendrik Hartman"
    }
  ],
  "sender" : {
    "reference" : "PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen",
    "display" : "Healthcare professional (role), van Huissen"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "713603004",
          "display" : "advance care planning"
        }
      ]
    }
  ]
}

```
