# iknl.fhir.r4.pzp#1.0.0-rc1: Advance Care Planning (PZP)

## Pages

* [Home](index.md)
* [ACP Actor Consulter](ActorDefinition-ACPActorConsulter.md)
* [Downloads](downloads.md)
* [ACP Actor Consulter - TTL Representation](ActorDefinition-ACPActorConsulter.ttl.md)
* [](ActorDefinition-ACPActorProvider.change.history.md)
* [ACP Actor Provider - Testing](ActorDefinition-ACPActorProvider-testing.md)
* [ACP Actor Consulter - Testing](ActorDefinition-ACPActorConsulter-testing.md)
* [](ActorDefinition-ACPActorConsulter.change.history.md)
* [Artifacts Summary](artifacts.md)
* [ACP Actor Provider - XML Representation](ActorDefinition-ACPActorProvider.xml.md)
* [ACP Actor Provider](ActorDefinition-ACPActorProvider.md)
* [Data Exchange Overview](data-exchange.md)
* [Change Log](changelog.md)
* [Data Model Overview](data-model.md)
* [Information Standard](information-standard.md)
* [ACP Actor Consulter - JSON Representation](ActorDefinition-ACPActorConsulter.json.md)
* [ACP Actor Provider - JSON Representation](ActorDefinition-ACPActorProvider.json.md)
* [ACP Actor Consulter - XML Representation](ActorDefinition-ACPActorConsulter.xml.md)
* [ACP Actor Provider - TTL Representation](ActorDefinition-ACPActorProvider.ttl.md)

## Resources

### ValueSets

* [Euthanasia Statement](ValueSet-ACP-EuthanasiaStatement.md)
* [MedicalDevice ProductType ICD](ValueSet-ACP-MedicalDeviceProductType-ICD.md)
* [Most Important Agreed-upon Goal of Medical Policy](ValueSet-ACP-MedicalPolicyGoal.md)
* [Preferred Place Of Death](ValueSet-ACP-PreferredPlaceOfDeath.md)
* [Yes, No, Unknown valueSet](ValueSet-ACP-YesNoUnknownVS.md)

### Resource Profiles

* [AdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)
* [Communication](StructureDefinition-ACP-Communication.md)
* [ContactPerson](StructureDefinition-ACP-ContactPerson.md)
* [Encounter](StructureDefinition-ACP-Encounter.md)
* [HealthProfessional Practitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md)
* [HealthProfessional PractitionerRole](StructureDefinition-ACP-HealthProfessional-PractitionerRole.md)
* [Medical Policy Goal](StructureDefinition-ACP-Medical-Policy-Goal.md)
* [MedicalDevice Product ICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)
* [MedicalDevice](StructureDefinition-ACP-MedicalDevice.md)
* [Organ donation choice registration in donor register](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)
* [Other Important Information](StructureDefinition-ACP-OtherImportantInformation.md)
* [Patient](StructureDefinition-ACP-Patient.md)
* [Position Regarding Euthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md)
* [Preferred Place Of Death](StructureDefinition-ACP-PreferredPlaceOfDeath.md)
* [Advance Care Planning Procedure](StructureDefinition-ACP-Procedure.md)
* [Specific Care Wishes](StructureDefinition-ACP-SpecificCareWishes.md)
* [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)

### Extensions

* [ext Encounter Reference](StructureDefinition-ext-EncounterReference.md)
* [ext LegallyCapable regarding medical treatment decisions](StructureDefinition-ext-LegallyCapable-MedicalTreatmentDecisions.md)

### ImplementationGuides

* [Advance Care Planning (PZP)](index.md)

### QuestionnaireResponses

* [HendrikHartman-20201001](QuestionnaireResponse-HendrikHartman-20201001.md)
* [HendrikHartman-20221108](QuestionnaireResponse-HendrikHartman-20221108.md)

### Questionnaires

* [Uniform vastleggen proactieve zorgpanning advance care planning (ACP) o.b.v. zibs2020 - Beta3 28-08-2025](Questionnaire-ACP-zib2020.md)

### SearchParameters

* [ReasonCode](SearchParameter-Communication-reason-code.md)

### Examples

* [ACPActorConsulter (Basic)](Basic-ACPActorConsulter.md)
* [ACPActorProvider (Basic)](Basic-ACPActorProvider.md)
* [F1-ACP-Communication-01-10-2020 (Communication)](Communication-F1-ACP-Communication-01-10-2020.md)
* [P2-ACP-Communication-07-08-2025 (Communication)](Communication-P2-ACP-Communication-07-08-2025.md)
* [F1-ACP-TreatmentDirective-116762002 (Consent)](Consent-F1-ACP-TreatmentDirective-116762002.md)
* [F1-ACP-TreatmentDirective-281789004 (Consent)](Consent-F1-ACP-TreatmentDirective-281789004.md)
* [F1-ACP-TreatmentDirective-305351004 (Consent)](Consent-F1-ACP-TreatmentDirective-305351004.md)
* [F1-ACP-TreatmentDirective-32485007 (Consent)](Consent-F1-ACP-TreatmentDirective-32485007.md)
* [F1-ACP-TreatmentDirective-400231000146108 (Consent)](Consent-F1-ACP-TreatmentDirective-400231000146108.md)
* [F1-ACP-TreatmentDirective-40617009 (Consent)](Consent-F1-ACP-TreatmentDirective-40617009.md)
* [F1-ACP-TreatmentDirective-89666000 (Consent)](Consent-F1-ACP-TreatmentDirective-89666000.md)
* [F2-ACP-TreatmentDirective-305351004 (Consent)](Consent-F2-ACP-TreatmentDirective-305351004.md)
* [P2-ACP-AdvanceDirective (Consent)](Consent-P2-ACP-AdvanceDirective.md)
* [P2-ACP-TreatmentDirective-281789004 (Consent)](Consent-P2-ACP-TreatmentDirective-281789004.md)
* [P2-ACP-TreatmentDirective-305351004 (Consent)](Consent-P2-ACP-TreatmentDirective-305351004.md)
* [P2-ACP-TreatmentDirective-32485007 (Consent)](Consent-P2-ACP-TreatmentDirective-32485007.md)
* [P2-ACP-TreatmentDirective-400231000146108 (Consent)](Consent-P2-ACP-TreatmentDirective-400231000146108.md)
* [P2-ACP-TreatmentDirective-40617009-1 (Consent)](Consent-P2-ACP-TreatmentDirective-40617009-1.md)
* [P2-ACP-TreatmentDirective-40617009-2 (Consent)](Consent-P2-ACP-TreatmentDirective-40617009-2.md)
* [P2-ACP-TreatmentDirective-89666000 (Consent)](Consent-P2-ACP-TreatmentDirective-89666000.md)
* [P2-ACP-TreatmentDirective-other (Consent)](Consent-P2-ACP-TreatmentDirective-other.md)
* [F1-ACP-MedicalDevice.Product-ICD (Device)](Device-F1-ACP-MedicalDevice.Product-ICD.md)
* [P2-ACP-MedicalDevice.Product-ICD (Device)](Device-P2-ACP-MedicalDevice.Product-ICD.md)
* [F1-ACP-MedicalDevice-ICD (DeviceUseStatement)](DeviceUseStatement-F1-ACP-MedicalDevice-ICD.md)
* [P2-ACP-MedicalDevice-ICD (DeviceUseStatement)](DeviceUseStatement-P2-ACP-MedicalDevice-ICD.md)
* [F1-ACP-Encounter-01-10-2020 (Encounter)](Encounter-F1-ACP-Encounter-01-10-2020.md)
* [P2-ACP-Encounter-07-08-2025 (Encounter)](Encounter-P2-ACP-Encounter-07-08-2025.md)
* [P2-ACP-Encounter-28-07-2024 (Encounter)](Encounter-P2-ACP-Encounter-28-07-2024.md)
* [F1-ACP-Medical-Policy-Goal (Goal)](Goal-F1-ACP-Medical-Policy-Goal.md)
* [P2-ACP-Medical-Policy-Goal (Goal)](Goal-P2-ACP-Medical-Policy-Goal.md)
* [F1-ACP-OrganDonationChoiceRegistration-Yes (Observation)](Observation-F1-ACP-OrganDonationChoiceRegistration-Yes.md)
* [F1-ACP-OtherImportantInformation (Observation)](Observation-F1-ACP-OtherImportantInformation.md)
* [F1-ACP-PositionRegardingEuthanasia-Unknown (Observation)](Observation-F1-ACP-PositionRegardingEuthanasia-Unknown.md)
* [F1-ACP-PreferredPlaceOfDeath-Unknown (Observation)](Observation-F1-ACP-PreferredPlaceOfDeath-Unknown.md)
* [F1-ACP-SpecificCareWishes (Observation)](Observation-F1-ACP-SpecificCareWishes.md)
* [P2-ACP-OrganDonationChoiceRegistration-20250807 (Observation)](Observation-P2-ACP-OrganDonationChoiceRegistration-20250807.md)
* [P2-ACP-OtherImportantInformation-20250807 (Observation)](Observation-P2-ACP-OtherImportantInformation-20250807.md)
* [P2-ACP-PositionRegardingEuthanasia-20250807 (Observation)](Observation-P2-ACP-PositionRegardingEuthanasia-20250807.md)
* [P2-ACP-PreferredPlaceOfDeath-20250807 (Observation)](Observation-P2-ACP-PreferredPlaceOfDeath-20250807.md)
* [P2-ACP-SpecificCareWishes-20250807 (Observation)](Observation-P2-ACP-SpecificCareWishes-20250807.md)
* [F1-ACP-Patient-HendrikHartman (Patient)](Patient-F1-ACP-Patient-HendrikHartman.md)
* [P2-ACP-Patient-SamiraVanDerSluijs (Patient)](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)
* [F1-ACP-HealthProfessional-Practitioner-DrVanHuissen (Practitioner)](Practitioner-F1-ACP-HealthProfessional-Practitioner-DrVanHuissen.md)
* [P2-ACP-HealthProfessional-Practitioner-DesireeWolters (Practitioner)](Practitioner-P2-ACP-HealthProfessional-Practitioner-DesireeWolters.md)
* [P2-ACP-HealthProfessional-Practitioner-Santos (Practitioner)](Practitioner-P2-ACP-HealthProfessional-Practitioner-Santos.md)
* [F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen (PractitionerRole)](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md)
* [P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters (PractitionerRole)](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters.md)
* [P2-ACP-HealthProfessional-PractitionerRole-Santos (PractitionerRole)](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-Santos.md)
* [F1-ACP-Procedure-01-10-2020 (Procedure)](Procedure-F1-ACP-Procedure-01-10-2020.md)
* [P2-ACP-Procedure-07-08-2025 (Procedure)](Procedure-P2-ACP-Procedure-07-08-2025.md)
* [P2-ACP-Procedure-28-07-2024 (Procedure)](Procedure-P2-ACP-Procedure-28-07-2024.md)
* [F1-ACP-ContactPerson-MichielHartman (RelatedPerson)](RelatedPerson-F1-ACP-ContactPerson-MichielHartman.md)
* [P2-ACP-ContactPerson-GertJanDeJong (RelatedPerson)](RelatedPerson-P2-ACP-ContactPerson-GertJanDeJong.md)
* [P2-ACP-ContactPerson-MayaVanDerSluijsMulder (RelatedPerson)](RelatedPerson-P2-ACP-ContactPerson-MayaVanDerSluijsMulder.md)
