# Home - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/ImplementationGuide/iknl.fhir.r4.pzp | *Version*:1.0.0-rc1 |
| Active as of 2025-10-31 | *Computable Name*:PZP |

### Project Description and Scope

This Implementation Guide (IG) supports the Advance Care Planning (ACP) information standard (Dutch: Proactieve Zorgplanning) and is intended for use within the palliative care domain in the Netherlands. This domain involves care for patients with an incurable illness or condition from which they are expected to die.

Developed by the [Netherlands Comprehensive Cancer Organisation](https://iknl.nl/en) (Dutch: Integraal Kankercentrum Nederland (IKNL)), this guide provides technical direction for using FHIR to exchange ACP data. It is based on [HL7 FHIR R4](http://hl7.org/fhir/R4/index.html) and builds on top of the [Dutch Core R4 profiles](https://simplifier.net/packages/nictiz.fhir.nl.r4.nl-core).

This guide assumes that readers are familiar with the functional specifications of ACP and the R4 version of FHIR.

### Call for Feedback

This implementation guide is a work in progress, and its quality and usefulness depend on community input. We welcome feedback on all aspects of this guide, and we are particularly interested in your thoughts on the following decisions and sections:

1. The[EncounterReference extension](StructureDefinition-ext-EncounterReference.md)is an optional extension that enables linking the Consent, Goal, and DeviceUseStatement resources to a relevant Encounter. We invite feedback on whether this extension is truly necessary.
1. The[Communication profile](StructureDefinition-ACP-Communication.md)has been developed to capture all communication events related to advance care planning. It specifically documents whether the patient has been informed about their responsibility to discuss treatment agreements with relatives. As this profile is newly created rather than derived from zib/nl-core profiles, we welcome input on its structure and modeling approach.
1. The[TreatmentDirective profile](StructureDefinition-ACP-TreatmentDirective.md)is reused for directives regarding deactivation of Implantable Cardioverter Defibrillators (ICDs). However, this does not fully align with the zib TreatmentDirective2 for two reasons:
* First, ICD codes cannot be added to `Consent.provision.code` due to binding constraints, so the mapping is placed in `Consent.provision.code.text` with `OTH` as the code. A zib ticket ([ZIB-2796](https://nictiz.atlassian.net/browse/ZIB-2796)) has been created to address this issue.
* Second, for `Consent.provision.type`, only the **permit** code should be used; the other two nullflavor codes (**ASKU** and **NASK**) from the dataset valueset are not appropriate here. The profile describes using `Consent.modifierExtension.specificationOther` to capture information about these choices, which is somewhat questionable. Alternatively, a specialized profile for ICDs could be created, not based on the nl-core profile but following the same structure where possible.

1. The[ACP Questionnaire](Questionnaire-ACP-zib2020.md)has been developed based on the ACP form dataset and aims to preserve the zib structure as much as possible. We welcome any feedback on its design and implementation.

### Dependencies





