# Data Model Overview - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* **Data Model Overview**

## Data Model Overview

This page provides an overview of the FHIR profiles used to represent the ACP dataset, many of which are based on nl-core profiles.

### FHIR Data Model Overview

The diagram below illustrates the FHIR data model for this implementation guide. The resources represent the core event where the advance care plan is discussed, the individuals involved in the ACP process, the documented outcomes of the ACP and additional clinical context relevant to the ACP agreements.

#### Data Model Overview Diagram

```
flowchart TB

    %% ---- Style Definitions for Categories ----
    classDef C0 fill:#e6f3ff,stroke:#b3d9ff,color:#000
    classDef C1 fill:#e6ffe6,stroke:#b3ffb3,color:#000
    classDef C2 fill:#fff5e6,stroke:#ffddb3,color:#000
    classDef C3 fill:#f0e6ff,stroke:#d9b3ff,color:#000
    classDef C4 fill:#f2f2f2,stroke:#cccccc,color:#000

    %% ---- Subgraph Definitions ----
    subgraph "Communication"
        ACPCommunication
    end

    subgraph "Consent"
        ACPAdvanceDirective
        ACPTreatmentDirective
    end

    subgraph "Device"
        ACPMedicalDeviceProductICD
    end

    subgraph "DeviceUseStatement"
        ACPMedicalDevice
    end

    subgraph "Encounter"
        ACPEncounter
    end

    subgraph "Goal"
        ACPMedicalPolicyGoal
    end

    subgraph "Observation"
        ACPOrganDonationChoiceRegistration
        ACPOtherImportantInformation
        ACPPositionRegardingEuthanasia
        ACPPreferredPlaceOfDeath
        ACPSpecificCareWishes
    end

    subgraph "Patient"
        ACPPatient
    end

    subgraph "Practitioner"
        ACPHealthProfessionalPractitioner
    end

    subgraph "PractitionerRole"
        ACPHealthProfessionalPractitionerRole
    end

    subgraph "Procedure"
        ACPProcedure
    end

    subgraph "RelatedPerson"
        ACPContactPerson
    end

    %% ---- Style Assignments ----
    class ACPCommunication C2
    class ACPAdvanceDirective C0
    class ACPTreatmentDirective C0
    class ACPMedicalDeviceProductICD C2
    class ACPMedicalDevice C2
    class ACPEncounter C3
    class ACPMedicalPolicyGoal C0
    class ACPSpecificCareWishes C0
    class ACPPreferredPlaceOfDeath C0
    class ACPPositionRegardingEuthanasia C0
    class ACPOrganDonationChoiceRegistration C0
    class ACPOtherImportantInformation C0
    class ACPPatient C1
    class ACPHealthProfessionalPractitioner C1
    class ACPHealthProfessionalPractitionerRole C1
    class ACPProcedure C3
    class ACPContactPerson C1

    %% ---- Resource Type References ----
    Communication -- "recipient, subject" --> Patient
    Communication -- "sender" --> PractitionerRole
    Consent -- "extension" --> Encounter
    Consent -- "patient, provision.actor" --> Patient
    Consent -- "provision.actor" --> PractitionerRole
    Consent -- "provision.actor" --> RelatedPerson
    DeviceUseStatement -- "device" --> Device
    DeviceUseStatement -- "extension" --> Encounter
    DeviceUseStatement -- "subject" --> Patient
    Encounter -- "subject" --> Patient
    Encounter -- "participant" --> PractitionerRole
    Encounter -- "reasonReference" --> Procedure
    Encounter -- "participant" --> RelatedPerson
    Goal -- "extension" --> Encounter
    Goal -- "subject" --> Patient
    Observation -- "encounter" --> Encounter
    Observation -- "subject" --> Patient
    Observation -- "performer" --> PractitionerRole
    Patient -- "contact.extension" --> RelatedPerson
    PractitionerRole -- "practitioner" --> Practitioner
    Procedure -- "encounter" --> Encounter
    Procedure -- "performer, subject" --> Patient
    Procedure -- "performer" --> PractitionerRole
    Procedure -- "performer" --> RelatedPerson
    RelatedPerson -- "patient" --> Patient

```

### ACP Questionnaire

A patient's ACP preferences can be documented using a structured form, such as the one developed by IKNL. This implementation guide provides a corresponding [FHIR Questionnaire resource](Questionnaire-ACP-zib2020.md) to ensure standardized and interoperable data capture.

The Questionnaire's primary function is to specify its identity and question identifiers required to capture answers in a QuestionnaireResponse. The Questionnaire is based on the ACP form dataset and aims to preserve the zib structure as much as possible. To ensure the intended meaning is preserved in both the Questionnaire and QuestionnaireResponse, some questions correspond to zib concepts with preset answer codes that are marked as readOnly. This approach tightly couples the Questionnaire and QuestionnaireResponse to the underlying zib data model. The Questionnaire is not specifically designed for direct use in a user interface, though this is possible. For optimal user interaction, the questionnaire may need customization, for example, hiding preselected and read-only questions.

Two example QuestionnaireResponse resources, based on this Questionnaire, are included:

* [QuestionnaireResponse for Hendrik Hartman (01-01-2020)](QuestionnaireResponse-HendrikHartman-20201001.md)
* [QuestionnaireResponse for Hendrik Hartman (08-11-2022)](QuestionnaireResponse-HendrikHartman-20221108.md)

### Associating ACP dataset to FHIR

The FHIR profiles in this guide are directly linked to the ACP dataset elements published in ART-DECOR.

Each StructureDefinition includes a `StructureDefinition.mapping.uri` that points to the specific version of the ACP dataset used. Additionally, every element within a profile is individually mapped to its corresponding dataset element using the `ElementDefinition.mapping` property. The mapping table below shows all mappings in one view, while the "Mappings" tab of each profile page displays the mappings consolidated per profile.

These mappings provide a straightforward way to highlight the elements that are especially relevant for the ACP use case. To further clarify which elements are important for the ACP use case, [Obligation flags](https://hl7.org/fhir/extensions/StructureDefinition-obligation.html) have been added to all elements that contain a mapping to the ACP dataset. As a result, the profile's differential table now clearly shows all elements marked as relevant.

#### Note on referenced zibs

The ACP dataset is built from reusable components known as Zorginformatiebouwstenen (zibs). A zib can reference other zibs to create a comprehensive clinical picture. The ACP dataset, however, only includes the first level of these references. If a nested zib (i.e., a zib referenced by another) was not deemed essential for the primary ACP use case, it was not added to the dataset and is therefore not profiled or mapped in this guide.

Nevertheless, the FHIR profiles in this guide are based on the nl-core (zib) profiles and remain open by design. If a system contains deeper information that is not explicitly profiled in this ACP guide, it is encouraged to include it.

For example, the zib AdvanceDirective can reference the zib Problem to which the directive applies. While this guide does not define a specific ACP profile for the target Problem, this data provides important context. When including such information, systems should make it available by conforming to the general-purpose nl-core profiles for those resources.

#### Mappings by dataset ID

This table provides an overview of all dataset elements that are mapped to FHIR profiles in this implementation guide.

| | | | |
| :--- | :--- | :--- | :--- |
| 808 | Contact | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `` |
| 809 |  ContactType | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `class` |
| 810 |  ContactMet | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `participant` |
| 842 |  Gesprek gevoerd door (Zorgverlener) | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `participant[healthProfessional].individual` |
| 814 |  BeginDatumTijd | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `period.start` |
| 819 |  Verrichting | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `reasonReference[procedure]` |
| 820 |  Verrichting | Procedure ([ACPProcedure](StructureDefinition-ACP-Procedure.md)) | `` |
| 827 |  PZP gesprek (VerrichtingType) | Procedure ([ACPProcedure](StructureDefinition-ACP-Procedure.md)) | `code` |
| 822 |  ToelichtingRedenContact | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `reasonReference.extension[commentContactReason].value[x]` |
| 822 |  ToelichtingRedenContact | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `reasonCode[deviatingResult].extension[commentContactReason].value[x]` |
| 736 | Datum van invullen | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `period.start` |
| 351 | Patient | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `` |
| 352 |  Naamgegevens | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name` |
| 353 |  Voornamen | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].given` |
| 354 |  Initialen | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].given` |
| 355 |  Roepnaam | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation-GivenName].given` |
| 356 |  Naamgebruik | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].use` |
| 358 |  Voorvoegsels | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].family.extension[prefix].valueString` |
| 359 |  Achternaam | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].family.extension[lastName].valueString` |
| 361 |  VoorvoegselsPartner | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].family.extension[partnerPrefix].valueString` |
| 362 |  AchternaamPartner | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].family.extension[partnerLastName].valueString` |
| 363 |  Titels | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].suffix` |
| 364 |  Adresgegevens | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address` |
| 365 |  Straat | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.line.extension[streetName].valueString` |
| 366 |  Huisnummer | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.line.extension[houseNumber].valueString` |
| 367 |  Huisnummerletter | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.line.extension[houseNumberLetter-houseNumberAddition].valueString` |
| 368 |  Huisnummertoevoeging | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.line.extension[houseNumberLetter-houseNumberAddition].valueString` |
| 369 |  AanduidingBijNummer | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.line.extension[houseNumberIndication].valueString` |
| 370 |  Postcode | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.postalCode` |
| 371 |  Woonplaats | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.city` |
| 372 |  Gemeente | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.district` |
| 373 |  Land | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.country.extension[countryCode].valueCodeableConcept` |
| 374 |  AdditioneleInformatie | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.line.extension[additionalInformation].valueString` |
| 375 |  AdresSoort | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.use` |
| 375 |  AdresSoort | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `address.type` |
| 376 |  Contactgegevens | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom` |
| 377 |  Telefoonnummers | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[telephoneNumbers]` |
| 378 |  Telefoonnummer | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[telephoneNumbers].value` |
| 379 |  TelecomType | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[telephoneNumbers].system` |
| 379 |  TelecomType | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[telephoneNumbers].system.extension[telecomType].valueCodeableConcept` |
| 380 |  NummerSoort | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[telephoneNumbers].use` |
| 381 |  Toelichting | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[telephoneNumbers].extension[comment].valueString` |
| 382 |  EmailAdressen | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[emailAddresses]` |
| 383 |  EmailAdres | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[emailAddresses].value` |
| 384 |  EmailSoort | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `telecom[emailAddresses].system` |
| 385 |  Identificatienummer | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `identifier` |
| 386 |  Geboortedatum | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `birthDate` |
| 387 |  Geslacht | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `gender` |
| 387 |  Geslacht | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `gender.extension[genderCodelist].value[x]` |
| 391 | Gesprek gevoerd door (Zorgverlener) | Practitioner ([ACPHealthProfessionalPractitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md)) | `` |
| 391 | Gesprek gevoerd door (Zorgverlener) | PractitionerRole ([ACPHealthProfessionalPractitionerRole](StructureDefinition-ACP-HealthProfessional-PractitionerRole.md)) | `` |
| 392 |  ZorgverlenerIdentificatienummer | Practitioner ([ACPHealthProfessionalPractitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md)) | `identifier` |
| 393 |  Naamgegevens | Practitioner ([ACPHealthProfessionalPractitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md)) | `name` |
| 394 |  Voornamen | Practitioner ([ACPHealthProfessionalPractitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md)) | `name[nameInformation-GivenName].given` |
| 398 |  Geslachtsnaam | Practitioner ([ACPHealthProfessionalPractitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md)) | `name[nameInformation].family` |
| 399 |  Voorvoegsels | Practitioner ([ACPHealthProfessionalPractitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md)) | `name[nameInformation].family.extension[prefix]` |
| 400 |  Achternaam | Practitioner ([ACPHealthProfessionalPractitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md)) | `name[nameInformation].family.extension[lastName]` |
| 405 |  Functie (Specialisme) | PractitionerRole ([ACPHealthProfessionalPractitionerRole](StructureDefinition-ACP-HealthProfessional-PractitionerRole.md)) | `specialty[specialty]` |
| 761 | Wilsbekwaamheid m.b.t. medische behandelbeslissingen | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `extension[legallyCapableMedicalTreatmentDecisions]` |
| 762 |  Wilsbekwaamheid m.b.t. medische behandelbeslissingen | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `extension[legallyCapableMedicalTreatmentDecisions].extension[legallyCapable].valueBoolean` |
| 763 |  Toelichting | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `extension[legallyCapableMedicalTreatmentDecisions].extension[legallyCapableComment].valueString` |
| 441 | Wettelijk vertegenwoordiger (Contactpersoon) | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `` |
| 442 |  Naamgegevens | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name` |
| 443 |  Voornamen | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].given` |
| 444 |  Initialen | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].given` |
| 445 |  Roepnaam | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation-GivenName].given` |
| 446 |  Naamgebruik | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].use` |
| 448 |  Voorvoegsels | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[prefix].valueString` |
| 449 |  Achternaam | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[lastName].valueString` |
| 451 |  VoorvoegselsPartner | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[partnerPrefix].valueString` |
| 452 |  AchternaamPartner | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[partnerLastName].valueString` |
| 453 |  Titels | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].suffix` |
| 454 |  Contactgegevens | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom` |
| 455 |  Telefoonnummers | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers]` |
| 456 |  Telefoonnummer | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].value` |
| 457 |  TelecomType | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].system` |
| 457 |  TelecomType | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].system.extension[telecomType].valueCodeableConcept` |
| 458 |  NummerSoort | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].use` |
| 459 |  Toelichting | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].extension[comment].valueString` |
| 460 |  EmailAdressen | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[emailAddresses]` |
| 461 |  EmailAdres | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[emailAddresses].value` |
| 462 |  EmailSoort | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[emailAddresses].system` |
| 463 |  Adresgegevens | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address` |
| 464 |  Straat | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[streetName].valueString` |
| 465 |  Huisnummer | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[houseNumber].valueString` |
| 466 |  Huisnummerletter | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[houseNumberLetter-houseNumberAddition].valueString` |
| 467 |  Huisnummertoevoeging | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[houseNumberLetter-houseNumberAddition].valueString` |
| 468 |  AanduidingBijNummer | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[houseNumberIndication].valueString` |
| 469 |  Postcode | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.postalCode` |
| 470 |  Woonplaats | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.city` |
| 471 |  Gemeente | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.district` |
| 472 |  Land | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.country.extension[countryCode].valueCodeableConcept` |
| 473 |  AdditioneleInformatie | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[additionalInformation].valueString` |
| 474 |  AdresSoort | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.use` |
| 474 |  AdresSoort | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.type` |
| 475 |  Rol | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `relationship[role]` |
| 476 |  Relatie | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `relationship[relationship]` |
| 477 | Vertegenwoordiger is contactpersoon | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `relationship[role]` |
| 478 | Eerste contactpersoon (Contactpersoon) | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `` |
| 479 |  Naamgegevens | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name` |
| 480 |  Voornamen | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].given` |
| 481 |  Initialen | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].given` |
| 482 |  Roepnaam | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation-GivenName].given` |
| 483 |  Naamgebruik | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].use` |
| 485 |  Voorvoegsels | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[prefix].valueString` |
| 486 |  Achternaam | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[lastName].valueString` |
| 488 |  VoorvoegselsPartner | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[partnerPrefix].valueString` |
| 489 |  AchternaamPartner | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[partnerLastName].valueString` |
| 490 |  Titels | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].suffix` |
| 491 |  Contactgegevens | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom` |
| 492 |  Telefoonnummers | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers]` |
| 493 |  Telefoonnummer | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].value` |
| 494 |  TelecomType | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].system` |
| 494 |  TelecomType | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].system.extension[telecomType].valueCodeableConcept` |
| 495 |  NummerSoort | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].use` |
| 496 |  Toelichting | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[telephoneNumbers].extension[comment].valueString` |
| 497 |  EmailAdressen | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[emailAddresses]` |
| 498 |  EmailAdres | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[emailAddresses].value` |
| 499 |  EmailSoort | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `telecom[emailAddresses].system` |
| 500 |  Adresgegevens | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address` |
| 501 |  Straat | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[streetName].valueString` |
| 502 |  Huisnummer | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[houseNumber].valueString` |
| 503 |  Huisnummerletter | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[houseNumberLetter-houseNumberAddition].valueString` |
| 504 |  Huisnummertoevoeging | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[houseNumberLetter-houseNumberAddition].valueString` |
| 505 |  AanduidingBijNummer | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[houseNumberIndication].valueString` |
| 506 |  Postcode | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.postalCode` |
| 507 |  Woonplaats | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.city` |
| 508 |  Gemeente | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.district` |
| 509 |  Land | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.country.extension[countryCode].valueCodeableConcept` |
| 510 |  AdditioneleInformatie | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.line.extension[additionalInformation].valueString` |
| 511 |  AdresSoort | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.use` |
| 511 |  AdresSoort | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `address.type` |
| 512 |  Rol | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `relationship[role]` |
| 513 |  Relatie | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `relationship[relationship]` |
| 514 | Gesprek gevoerd in bijzijn van (Patient) | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `subject` |
| 515 |  Naamgegevens | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name` |
| 516 |  Voornamen | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].given` |
| 517 |  Initialen | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].given` |
| 518 |  Roepnaam | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation-GivenName].given` |
| 519 |  Naamgebruik | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].use` |
| 521 |  Voorvoegsels | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].family.extension[prefix].valueString` |
| 522 |  Achternaam | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].family.extension[lastName].valueString` |
| 524 |  VoorvoegselsPartner | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].family.extension[partnerPrefix].valueString` |
| 525 |  AchternaamPartner | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].family.extension[partnerLastName].valueString` |
| 526 |  Titels | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `name[nameInformation].suffix` |
| 554 | Gesprek gevoerd in bijzijn van (Contactpersoon) | Encounter ([ACPEncounter](StructureDefinition-ACP-Encounter.md)) | `participant[contactPerson].individual` |
| 554 | Gesprek gevoerd in bijzijn van (Contactpersoon) | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `` |
| 555 |  Naamgegevens | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name` |
| 556 |  Voornamen | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].given` |
| 557 |  Initialen | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].given` |
| 558 |  Roepnaam | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation-GivenName].given` |
| 559 |  Naamgebruik | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].use` |
| 561 |  Voorvoegsels | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[prefix].valueString` |
| 562 |  Achternaam | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[lastName].valueString` |
| 564 |  VoorvoegselsPartner | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[partnerPrefix].valueString` |
| 565 |  AchternaamPartner | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].family.extension[partnerLastName].valueString` |
| 566 |  Titels | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `name[nameInformation].suffix` |
| 588 |  Rol | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `relationship[role]` |
| 589 |  Relatie | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `relationship[relationship]` |
| 590 | Belangrijkste doel van behandeling ([Meting]) | Goal ([ACPMedicalPolicyGoal](StructureDefinition-ACP-Medical-Policy-Goal.md)) | `` |
| 591 |  Belangrijkste doel van behandeling ([MetingNaam]) | Goal ([ACPMedicalPolicyGoal](StructureDefinition-ACP-Medical-Policy-Goal.md)) | `` |
| 592 |  Doel ([MetingWaarde]) | Goal ([ACPMedicalPolicyGoal](StructureDefinition-ACP-Medical-Policy-Goal.md)) | `description` |
| 596 |  [MeetDatumBeginTijd] | Goal ([ACPMedicalPolicyGoal](StructureDefinition-ACP-Medical-Policy-Goal.md)) | `startDate` |
| 598 |  [Toelichting] | Goal ([ACPMedicalPolicyGoal](StructureDefinition-ACP-Medical-Policy-Goal.md)) | `note.text` |
| 602 | Behandelgrens (BehandelAanwijzing2) | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `` |
| 603 |  BehandelBesluit | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.type` |
| 604 |  Behandeling | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.code` |
| 605 |  SpecificatieAnders | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `modifierExtension[specificationOther].value[x]` |
| 606 |  MeestRecenteBespreekdatum | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `dateTime` |
| 607 |  DatumBeeindigd | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.period.end` |
| 608 |  RedenBeeindigd | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.extension[reasonForEnding].value[x]` |
| 609 |  Wilsverklaring | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `sourceReference` |
| 610 |  Wilsverklaring | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `` |
| 611 |  AfspraakPartij | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.actor[agreementParty]` |
| 612 |  Patient | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.actor[agreementParty].reference` |
| 613 |  Patient | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `` |
| 614 |  Vertegenwoordiger | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.actor[agreementParty].reference` |
| 615 |  Contactpersoon | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `` |
| 616 |  Zorgverlener | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.actor[agreementParty].reference` |
| 617 |  Zorgverlener | PractitionerRole ([ACPHealthProfessionalPractitionerRole](StructureDefinition-ACP-HealthProfessional-PractitionerRole.md)) | `` |
| 618 |  Toelichting | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `extension[comment].value[x]` |
| 619 | Heeft de patient een ICD? | Device ([ACPMedicalDeviceProductICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)) | `type` |
| 619 | Heeft de patient een ICD? | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `` |
| 620 | ICD (MedischHulpmiddel) | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `` |
| 621 |  Product | Device ([ACPMedicalDeviceProductICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)) | `` |
| 622 |  ProductID | Device ([ACPMedicalDeviceProductICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)) | `identifier[gs1ProductID]` |
| 622 |  ProductID | Device ([ACPMedicalDeviceProductICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)) | `identifier[hibcProductID]` |
| 622 |  ProductID | Device ([ACPMedicalDeviceProductICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)) | `udiCarrier[gs1UdiCarrier].carrierHRF` |
| 622 |  ProductID | Device ([ACPMedicalDeviceProductICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)) | `udiCarrier[hibcUdiCarrier].carrierHRF` |
| 623 |  ProductType van ICD | Device ([ACPMedicalDeviceProductICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)) | `type` |
| 624 |  ProductOmschrijving | Device ([ACPMedicalDeviceProductICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md)) | `note.text` |
| 625 |  AnatomischeLocatie | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `bodySite` |
| 626 |  Locatie | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `bodySite` |
| 627 |  Lateraliteit | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `bodySite.extension[laterality].valueCodeableConcept` |
| 628 |  Indicatie | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `reasonReference[indication]` |
| 630 |  BeginDatum | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `timingPeriod.start` |
| 631 |  EindDatum | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `timingPeriod.end` |
| 632 |  Toelichting | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `note.text` |
| 633 |  Locatie | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `extension[location].value[x]` |
| 635 |  Zorgverlener | DeviceUseStatement ([ACPMedicalDevice](StructureDefinition-ACP-MedicalDevice.md)) | `extension[healthProfessional].value[x]` |
| 636 |  Zorgverlener | PractitionerRole ([ACPHealthProfessionalPractitionerRole](StructureDefinition-ACP-HealthProfessional-PractitionerRole.md)) | `` |
| 637 | Afspraak uitzetten ICD (BehandelAanwijzing2) | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `` |
| 638 |  Afspraak uitzetten ICD (BehandelBesluit) | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `modifierExtension[specificationOther].value[x]` |
| 638 |  Afspraak uitzetten ICD (BehandelBesluit) | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.type` |
| 639 |  Behandeling van uitzetten ICD (Behandeling) | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.code.text` |
| 641 |  MeestRecenteBespreekdatum | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `dateTime` |
| 642 |  DatumBeeindigd | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.period.end` |
| 643 |  RedenBeeindigd | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.extension[reasonForEnding]` |
| 644 |  Wilsverklaring | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `extension[additionalAdvanceDirective].valueReference` |
| 644 |  Wilsverklaring | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `sourceReference` |
| 645 |  Wilsverklaring | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `` |
| 646 |  AfspraakPartij | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.actor[agreementParty]` |
| 647 |  Patient | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.actor[agreementParty].reference` |
| 648 |  Patient | Patient ([ACPPatient](StructureDefinition-ACP-Patient.md)) | `` |
| 649 |  Vertegenwoordiger | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.actor[agreementParty].reference` |
| 650 |  Contactpersoon | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `` |
| 651 |  Zorgverlener | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `provision.actor[agreementParty].reference` |
| 652 |  Zorgverlener | PractitionerRole ([ACPHealthProfessionalPractitionerRole](StructureDefinition-ACP-HealthProfessional-PractitionerRole.md)) | `` |
| 653 |  Toelichting | Consent ([ACPTreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)) | `extension[comment].value[x]` |
| 654 | Specifieke wensen ([Meting]) | Observation ([ACPSpecificCareWishes](StructureDefinition-ACP-SpecificCareWishes.md)) | `` |
| 655 |  Wens en verwachting patient ([MetingNaam]) | Observation ([ACPSpecificCareWishes](StructureDefinition-ACP-SpecificCareWishes.md)) | `code` |
| 656 |  Wens en verwachting patient ([MetingWaarde]) | Observation ([ACPSpecificCareWishes](StructureDefinition-ACP-SpecificCareWishes.md)) | `valueString` |
| 656 |  Wens en verwachting patient ([MetingWaarde]) | Observation ([ACPSpecificCareWishes](StructureDefinition-ACP-SpecificCareWishes.md)) | `dataAbsentReason` |
| 657 |  Vaststellen wens en verwachting patiënt ([MeetMethode]) | Observation ([ACPSpecificCareWishes](StructureDefinition-ACP-SpecificCareWishes.md)) | `method` |
| 660 |  [MeetDatumBeginTijd] | Observation ([ACPSpecificCareWishes](StructureDefinition-ACP-SpecificCareWishes.md)) | `effective[x]` |
| 666 | Gewenste plek van overlijden ([Meting]) | Observation ([ACPPreferredPlaceOfDeath](StructureDefinition-ACP-PreferredPlaceOfDeath.md)) | `` |
| 667 |  Gewenste plek van overlijden ([MetingNaam]) | Observation ([ACPPreferredPlaceOfDeath](StructureDefinition-ACP-PreferredPlaceOfDeath.md)) | `code` |
| 668 |  Voorkeursplek ([MetingWaarde]) | Observation ([ACPPreferredPlaceOfDeath](StructureDefinition-ACP-PreferredPlaceOfDeath.md)) | `valueCodeableConcept` |
| 668 |  Voorkeursplek ([MetingWaarde]) | Observation ([ACPPreferredPlaceOfDeath](StructureDefinition-ACP-PreferredPlaceOfDeath.md)) | `dataAbsentReason` |
| 672 |  [MeetDatumBeginTijd] | Observation ([ACPPreferredPlaceOfDeath](StructureDefinition-ACP-PreferredPlaceOfDeath.md)) | `effective[x]` |
| 674 |  [Toelichting] | Observation ([ACPPreferredPlaceOfDeath](StructureDefinition-ACP-PreferredPlaceOfDeath.md)) | `note.text` |
| 678 | Euthanasie standpunt ([Meting]) | Observation ([ACPPositionRegardingEuthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md)) | `` |
| 679 |  Euthanasie standpunt ([MetingNaam]) | Observation ([ACPPositionRegardingEuthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md)) | `code` |
| 680 |  Euthanasie standpunt ([MetingWaarde]) | Observation ([ACPPositionRegardingEuthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md)) | `valueCodeableConcept` |
| 680 |  Euthanasie standpunt ([MetingWaarde]) | Observation ([ACPPositionRegardingEuthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md)) | `dataAbsentReason` |
| 684 |  [MeetDatumBeginTijd] | Observation ([ACPPositionRegardingEuthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md)) | `effective[x]` |
| 686 |  [Toelichting] | Observation ([ACPPositionRegardingEuthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md)) | `note.text` |
| 690 | Euthanasieverklaring (Wilsverklaring) | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `` |
| 691 |  Euthanasieverklaring (WilsverklaringType) | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `provision.code` |
| 692 |  WilsverklaringDatum | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `dateTime` |
| 693 |  Aandoening | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `extension[disorder].value[x]` |
| 695 |  Vertegenwoordiger | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `provision.actor[representative].reference` |
| 696 |  Contactpersoon | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `` |
| 697 |  WilsverklaringDocument | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `sourceAttachment` |
| 698 |  Toelichting | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `extension[comment].value[x]` |
| 746 | Keuze orgaandonatie vastgelegd in donorregister? ([Meting]) | Observation ([ACPOrganDonationChoiceRegistration](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)) | `` |
| 747 |  Keuze orgaandonatie vastgelegd in donorregister? ([MetingNaam]) | Observation ([ACPOrganDonationChoiceRegistration](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)) | `code` |
| 748 |  Keuze orgaandonatie in donorregister ([MetingWaarde]) | Observation ([ACPOrganDonationChoiceRegistration](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)) | `valueCodeableConcept` |
| 748 |  Keuze orgaandonatie in donorregister ([MetingWaarde]) | Observation ([ACPOrganDonationChoiceRegistration](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)) | `dataAbsentReason` |
| 752 |  [MeetDatumBeginTijd] | Observation ([ACPOrganDonationChoiceRegistration](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)) | `effective[x]` |
| 700 | Keuze orgaandonatie vastgelegd (Wilsverklaring) | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `` |
| 701 |  Orgaandonatie (WilsverklaringType) | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `provision.code` |
| 702 |  WilsverklaringDatum | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `dateTime` |
| 703 |  Aandoening | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `extension[disorder].value[x]` |
| 705 |  Vertegenwoordiger | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `provision.actor[representative].reference` |
| 706 |  Contactpersoon | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `` |
| 707 |  WilsverklaringDocument | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `sourceAttachment` |
| 708 |  Toelichting | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `extension[comment].value[x]` |
| 709 | Wat verder nog belangrijk is ([Meting]) | Observation ([ACPOtherImportantInformation](StructureDefinition-ACP-OtherImportantInformation.md)) | `` |
| 710 |  Wat verder nog belangrijk is ([MetingNaam]) | Observation ([ACPOtherImportantInformation](StructureDefinition-ACP-OtherImportantInformation.md)) | `code` |
| 711 |  Wat verder nog belangrijk is ([MetingWaarde]) | Observation ([ACPOtherImportantInformation](StructureDefinition-ACP-OtherImportantInformation.md)) | `valueString` |
| 711 |  Wat verder nog belangrijk is ([MetingWaarde]) | Observation ([ACPOtherImportantInformation](StructureDefinition-ACP-OtherImportantInformation.md)) | `dataAbsentReason` |
| 715 |  [MeetDatumBeginTijd] | Observation ([ACPOtherImportantInformation](StructureDefinition-ACP-OtherImportantInformation.md)) | `effective[x]` |
| 721 | Eerder vastgelegde behandelafspraken (Wilsverklaring) | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `` |
| 722 |  WilsverklaringType | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `provision.code` |
| 723 |  WilsverklaringDatum | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `dateTime` |
| 724 |  Aandoening | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `extension[disorder].value[x]` |
| 726 |  Vertegenwoordiger | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `provision.actor[representative].reference` |
| 727 |  Contactpersoon | RelatedPerson ([ACPContactPerson](StructureDefinition-ACP-ContactPerson.md)) | `` |
| 728 |  WilsverklaringDocument | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `sourceAttachment` |
| 729 |  Toelichting | Consent ([ACPAdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md)) | `extension[comment].value[x]` |
| 734 | Heeft u patient geïnformeerd over eigen verantwoordelijkheid om deze behandelafspraken met naasten te bespreken? | Communication ([ACPCommunication](StructureDefinition-ACP-Communication.md)) | `` |

