# Artifacts Summary - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Questionnaire and QuestionnaireResponses 

These define forms used by systems conforming to this implementation guide to capture or expose data to end users.

| | |
| :--- | :--- |
| [ACP Questionnaire based on zib2020](Questionnaire-ACP-zib2020.md) | Uniform vastleggen proactieve zorgpanning advance care planning (ACP) o.b.v. zibs2020 - Beta3 28-08-2025 |
| [QuestionnaireResponse Hendrik Hartman 20201001](QuestionnaireResponse-HendrikHartman-20201001.md) | An example of a QuestionnaireResponse for Hendrik Hartman on 2020-10-01 |
| [QuestionnaireResponse Hendrik Hartman 20221108](QuestionnaireResponse-HendrikHartman-20221108.md) | An example of a QuestionnaireResponse for Hendrik Hartman on 2022-11-08 |

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [ACP Actor Consulter](ActorDefinition-ACPActorConsulter.md) | The ACP Actor Consulter is a system that creates and initiates a data access request to retrieve digital health and administrative information. |
| [ACP Actor Provider](ActorDefinition-ACPActorProvider.md) | The ACP Actor Provider is a system that responds to data access requests for digital health and administrative information. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [Communication-reason-code](SearchParameter-Communication-reason-code.md) | ReasonCode for the Communication |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Advance Care Planning Procedure](StructureDefinition-ACP-Procedure.md) | Advance Care Planning procedure. Based on nl-core-Procedure-event profile and HCIM Procedure. |
| [AdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md) | A verbal or written description of the patient’s wishes with regard to future medical action or end of their life. A living will is mainly used for situations in which the patient is no longer able to speak about these decisions with their healthcare provider. Based on nl-core-AdvanceDirective and HCIM AdvanceDirective. |
| [Communication](StructureDefinition-ACP-Communication.md) | Communication events that have taken place in context of Advance Care Planning. Based on Communication resource. |
| [ContactPerson](StructureDefinition-ACP-ContactPerson.md) | A person not being a healthcare professional who is involved in the patient’s care, such as family members, caregivers, mental caretakers, guardians and legal representatives. Based on nl-core-ContactPerson and HCIM ContactPerson. |
| [Encounter](StructureDefinition-ACP-Encounter.md) | Any interaction, regardless of the situation, between a patient and the healthcare provider, in which the healthcare provider has primary responsibility for diagnosing, evaluating and treating the patient’s condition and informing the patient. These can be visits, appointments or non face-to-face interactions. Based on nl-core-Encounter and HCIM Encounter. |
| [HealthProfessional Practitioner](StructureDefinition-ACP-HealthProfessional-Practitioner.md) | A person who is authorized to perform actions in the field of individual healthcare. Based on nl-core-HealthProfessionalPractitioner and HCIM HealthProfessional. |
| [HealthProfessional PractitionerRole](StructureDefinition-ACP-HealthProfessional-PractitionerRole.md) | The specialty of a person who is authorized to perform actions in the field of individual healthcare. Based on nl-core-HealthProfessionalPractitionerRole and HCIM HealthProfessional. |
| [Medical Policy Goal](StructureDefinition-ACP-Medical-Policy-Goal.md) | The primary, agreed-upon goal of a patient's medical treatment policy. Based on Goal resource. |
| [MedicalDevice](StructureDefinition-ACP-MedicalDevice.md) | Any internally implanted and external devices and/or aids used by the patient (in the past) to reduce the effects of functional limitations in organ systems or to facilitate the treatment of a disease. In the context of ACP, this profile is used to declare the use of an implantable cardioverter defibrillator (ICD). Based on nl-core-MedicalDevice and HCIM MedicalDevice. |
| [MedicalDevice Product ICD](StructureDefinition-ACP-MedicalDevice.Product-ICD.md) | The medical device (internally or externally). In the context of ACP, this profile is used to capture information on a patient's implantable cardioverter defibrillator (ICD). Based on nl-core-MedicalDeviceProduct and HCIM MedicalDevice. |
| [Organ donation choice registration in donor register](StructureDefinition-ACP-OrganDonationChoiceRegistration.md) | Answer, captured in an observation, to the question: 'Is the choice on organ donation recorded in the donor register?' Based on Observation resource. |
| [Other Important Information](StructureDefinition-ACP-OtherImportantInformation.md) | Other relevant and important information related to the Patient’s Advance Care Planning (ACP) agreements. Based on Observation resource. |
| [Patient](StructureDefinition-ACP-Patient.md) | A person who receives medical, psychological, paramedical, or nursing care. Based on nl-core-Patient and HCIM Patient. |
| [Position Regarding Euthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md) | The patient's position regarding euthanasia. Based on Observation resource. |
| [Preferred Place Of Death](StructureDefinition-ACP-PreferredPlaceOfDeath.md) | The preferred place of death. This is the place where the patient prefers to die, if possible. The preferred place of death can be a home, a hospital, a nursing home, hospice or another location. Based on Observation resource. |
| [Specific Care Wishes](StructureDefinition-ACP-SpecificCareWishes.md) | The patient's wishes and expectations concerning their treatment, as an answer to the questions: 'What, according to the patient, should healthcare providers know to provide good care? Does this patient have specific wishes regarding their care (including cultural, religious, social, and spiritual aspects)?' Based on Observation resource. |
| [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md) | A joint decision between a health professional (for example a general practitioner) and a patient or his representative(s) about the desirability of performing a certain treatment, such as resuscitation, before this treatment becomes (acute) necessary. Based on nl-core-TreatmentDirective2 and HCIM TreatmentDirective2. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ext Encounter Reference](StructureDefinition-ext-EncounterReference.md) | An extension to link the Encounter during which the Consent, Goal or DeviceUseStatement was created or to which the creation is tightly associated. |
| [ext LegallyCapable regarding medical treatment decisions](StructureDefinition-ext-LegallyCapable-MedicalTreatmentDecisions.md) | An extension to indicate the patient's legal capability regarding medical treatment decisions, and to provide a comment on this capability. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Euthanasia Statement](ValueSet-ACP-EuthanasiaStatement.md) | ValueSet for Position Regarding Euthanasia, representing the the patient's position regarding euthanasia and information on the presence of a euthanasia statement. |
| [MedicalDevice ProductType ICD](ValueSet-ACP-MedicalDeviceProductType-ICD.md) | ICD product code for MedicalDevice ProductType. |
| [Most Important Agreed-upon Goal of Medical Policy](ValueSet-ACP-MedicalPolicyGoal.md) | ValueSet for Medical Policy Goal, representing the primary agreed-upon goal of a patient's medical treatment policy. |
| [Preferred Place Of Death](ValueSet-ACP-PreferredPlaceOfDeath.md) | ValueSet for Preferred Place of Death, representing the place where the patient prefers to die, if possible. |
| [Yes, No, Unknown valueSet](ValueSet-ACP-YesNoUnknownVS.md) | ValueSet representing 'Yes, No, Unknown' answers. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| |
| :--- |
| [F1 ACP ACPProcedure 01-10-2020](Procedure-F1-ACP-Procedure-01-10-2020.md) |
| [F1 ACP Communication](Communication-F1-ACP-Communication-01-10-2020.md) |
| [F1 ACP ContactPerson Michiel Hartman](RelatedPerson-F1-ACP-ContactPerson-MichielHartman.md) |
| [F1 ACP Donor Registration Yes](Observation-F1-ACP-OrganDonationChoiceRegistration-Yes.md) |
| [F1 ACP Encounter 01-10-2020](Encounter-F1-ACP-Encounter-01-10-2020.md) |
| [F1 ACP HealthProfessional Practitioner Dr. van Huissen](Practitioner-F1-ACP-HealthProfessional-Practitioner-DrVanHuissen.md) |
| [F1 ACP HealthProfessional PractitionerRole Dr. van Huissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md) |
| [F1 ACP Medical Policy Goal - Life-sustaining treatment](Goal-F1-ACP-Medical-Policy-Goal.md) |
| [F1 ACP MedicalDevice ICD](DeviceUseStatement-F1-ACP-MedicalDevice-ICD.md) |
| [F1 ACP MedicalDevice.Product ICD](Device-F1-ACP-MedicalDevice.Product-ICD.md) |
| [F1 ACP Other Important Information](Observation-F1-ACP-OtherImportantInformation.md) |
| [F1 ACP Patient Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md) |
| [F1 ACP Position Regarding Euthanasia Unknown](Observation-F1-ACP-PositionRegardingEuthanasia-Unknown.md) |
| [F1 ACP Preferred Place Of Death Unknown](Observation-F1-ACP-PreferredPlaceOfDeath-Unknown.md) |
| [F1 ACP Specific Care Wishes](Observation-F1-ACP-SpecificCareWishes.md) |
| [F1 ACP TreatmentDirective](Consent-F1-ACP-TreatmentDirective-400231000146108.md) |
| [F1 ACP TreatmentDirective 116762002](Consent-F1-ACP-TreatmentDirective-116762002.md) |
| [F1 ACP TreatmentDirective 281789004](Consent-F1-ACP-TreatmentDirective-281789004.md) |
| [F1 ACP TreatmentDirective 305351004](Consent-F1-ACP-TreatmentDirective-305351004.md) |
| [F1 ACP TreatmentDirective 32485007](Consent-F1-ACP-TreatmentDirective-32485007.md) |
| [F1 ACP TreatmentDirective 40617009](Consent-F1-ACP-TreatmentDirective-40617009.md) |
| [F1 ACP TreatmentDirective 89666000](Consent-F1-ACP-TreatmentDirective-89666000.md) |
| [F2 ACP TreatmentDirective 305351004](Consent-F2-ACP-TreatmentDirective-305351004.md) |
| [P2 ACP ACPProcedure 07-08-2025](Procedure-P2-ACP-Procedure-07-08-2025.md) |
| [P2 ACP ACPProcedure 28-07-2024](Procedure-P2-ACP-Procedure-28-07-2024.md) |
| [P2 ACP AdvanceDirective](Consent-P2-ACP-AdvanceDirective.md) |
| [P2 ACP Communication](Communication-P2-ACP-Communication-07-08-2025.md) |
| [P2 ACP ContactPerson Gert-Jan de Jong](RelatedPerson-P2-ACP-ContactPerson-GertJanDeJong.md) |
| [P2 ACP ContactPerson Maya van der Sluijs-Mulder](RelatedPerson-P2-ACP-ContactPerson-MayaVanDerSluijsMulder.md) |
| [P2 ACP Encounter 07-08-2025](Encounter-P2-ACP-Encounter-07-08-2025.md) |
| [P2 ACP Encounter 28-07-2025](Encounter-P2-ACP-Encounter-28-07-2024.md) |
| [P2 ACP HealthProfessional Practitioner Desiree Wolters](Practitioner-P2-ACP-HealthProfessional-Practitioner-DesireeWolters.md) |
| [P2 ACP HealthProfessional Practitioner Santos](Practitioner-P2-ACP-HealthProfessional-Practitioner-Santos.md) |
| [P2 ACP HealthProfessional PractitionerRole Desiree Wolters](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters.md) |
| [P2 ACP HealthProfessional PractitionerRole Santos](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-Santos.md) |
| [P2 ACP Medical Policy Goal - Life-sustaining treatment](Goal-P2-ACP-Medical-Policy-Goal.md) |
| [P2 ACP MedicalDevice ICD](DeviceUseStatement-P2-ACP-MedicalDevice-ICD.md) |
| [P2 ACP MedicalDevice.Product ICD](Device-P2-ACP-MedicalDevice.Product-ICD.md) |
| [P2 ACP Organ Donation Choice Registration 2025 08 07](Observation-P2-ACP-OrganDonationChoiceRegistration-20250807.md) |
| [P2 ACP Other Important Information 2025 08 07](Observation-P2-ACP-OtherImportantInformation-20250807.md) |
| [P2 ACP Patient Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md) |
| [P2 ACP Position Regarding Euthanasia 2025 08 07](Observation-P2-ACP-PositionRegardingEuthanasia-20250807.md) |
| [P2 ACP Preferred Place Of Death 2025 08 07](Observation-P2-ACP-PreferredPlaceOfDeath-20250807.md) |
| [P2 ACP Specific Care Wishes 2025 08 07](Observation-P2-ACP-SpecificCareWishes-20250807.md) |
| [P2 ACP TreatmentDirective 281789004](Consent-P2-ACP-TreatmentDirective-281789004.md) |
| [P2 ACP TreatmentDirective 305351004](Consent-P2-ACP-TreatmentDirective-305351004.md) |
| [P2 ACP TreatmentDirective 32485007](Consent-P2-ACP-TreatmentDirective-32485007.md) |
| [P2 ACP TreatmentDirective 400231000146108](Consent-P2-ACP-TreatmentDirective-400231000146108.md) |
| [P2 ACP TreatmentDirective 40617009-1](Consent-P2-ACP-TreatmentDirective-40617009-1.md) |
| [P2 ACP TreatmentDirective 40617009-2](Consent-P2-ACP-TreatmentDirective-40617009-2.md) |
| [P2 ACP TreatmentDirective 89666000](Consent-P2-ACP-TreatmentDirective-89666000.md) |
| [P2 ACP TreatmentDirective other](Consent-P2-ACP-TreatmentDirective-other.md) |

