# Yes, No, Unknown valueSet - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Yes, No, Unknown valueSet**

## ValueSet: Yes, No, Unknown valueSet 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-YesNoUnknownVS | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPYesNoUnknownVS |
| **Copyright/Legal**: This artefact includes content from SNOMED Clinical Terms® (SNOMED CT®) which is copyright of the International Health Terminology Standards Development Organisation (IHTSDO). Implementers of these artefacts must have the appropriate SNOMED CT Affiliate license - for more information contact http://www.snomed.org/snomed-ct/getsnomed-ct or info@snomed.org. | |

 
ValueSet representing 'Yes, No, Unknown' answers. 

 **References** 

* [Organ donation choice registration in donor register](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT Dutch edition 30-Sep 2024
* [codesystem NullFlavor v3.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html)

This value set contains 3 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ACP-YesNoUnknownVS",
  "url" : "https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-YesNoUnknownVS",
  "version" : "1.0.0-rc1",
  "name" : "ACPYesNoUnknownVS",
  "title" : "Yes, No, Unknown valueSet",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "ValueSet representing 'Yes, No, Unknown' answers.",
  "copyright" : "This artefact includes content from SNOMED Clinical Terms® (SNOMED CT®) which is copyright of the International Health Terminology Standards Development Organisation (IHTSDO). Implementers of these artefacts must have the appropriate SNOMED CT Affiliate license - for more information contact http://www.snomed.org/snomed-ct/getsnomed-ct or info@snomed.org.",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "code" : "UNK",
            "display" : "nog onbekend",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "onbekend"
              }
            ]
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "373066001",
            "display" : "ja",
            "designation" : [
              {
                "language" : "en-UK",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Yes (qualifier value)"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Yes (qualifier value)"
              },
              {
                "language" : "en-UK",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Yes"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Yes"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "ja (kwalificatiewaarde)"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "ja"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "bevestiging"
              }
            ]
          },
          {
            "code" : "373067005",
            "display" : "nee",
            "designation" : [
              {
                "language" : "en-UK",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "No (qualifier value)"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "No (qualifier value)"
              },
              {
                "language" : "en-UK",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "No"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "No"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "nee (kwalificatiewaarde)"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "nee"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "geen"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "ontkenning"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "neen"
              }
            ]
          }
        ]
      }
    ]
  }
}

```
