# Preferred Place Of Death - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Preferred Place Of Death**

## ValueSet: Preferred Place Of Death 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-PreferredPlaceOfDeath | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPPreferredPlaceOfDeathVS |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
ValueSet for Preferred Place of Death, representing the place where the patient prefers to die, if possible. 

 **References** 

* [Preferred Place Of Death](StructureDefinition-ACP-PreferredPlaceOfDeath.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT Dutch edition 30-Sep 2024
* [codesystem NullFlavor v3.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html)

This value set contains 6 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ACP-PreferredPlaceOfDeath",
  "url" : "https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-PreferredPlaceOfDeath",
  "version" : "1.0.0-rc1",
  "name" : "ACPPreferredPlaceOfDeathVS",
  "title" : "Preferred Place Of Death",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "ValueSet for Preferred Place of Death, representing the place where the patient prefers to die, if possible.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "code" : "OTH",
            "display" : "Anders"
          },
          {
            "code" : "UNK",
            "display" : "Nog onbekend"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "264362003",
            "display" : "thuis",
            "designation" : [
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Home (environment)"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Home"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Private home"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Dwelling"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Private dwelling"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "thuis (omgeving)"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "thuis"
              }
            ]
          },
          {
            "code" : "22232009",
            "display" : "ziekenhuis",
            "designation" : [
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Hospital (environment)"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Hospital"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "ziekenhuis (omgeving)"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "ziekenhuis"
              }
            ]
          },
          {
            "code" : "108344006",
            "display" : "verpleeghuis en/of locatie voor ambulante zorg",
            "designation" : [
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Nursing home AND/OR ambulatory care site (environment)"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Nursing home AND/OR ambulatory care site"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "verpleeghuis en/of locatie voor ambulante zorg (omgeving)"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "verpleeghuis en/of locatie voor ambulante zorg"
              }
            ]
          },
          {
            "code" : "284546000",
            "display" : "hospice",
            "designation" : [
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Hospice (environment)"
              },
              {
                "language" : "en-US",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "Hospice"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "hospice (omgeving)"
              },
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "hospice"
              }
            ]
          }
        ]
      }
    ]
  }
}

```
