# Most Important Agreed-upon Goal of Medical Policy - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Most Important Agreed-upon Goal of Medical Policy**

## ValueSet: Most Important Agreed-upon Goal of Medical Policy 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-MedicalPolicyGoal | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:MedicalPolicyGoalVS |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
ValueSet for Medical Policy Goal, representing the primary agreed-upon goal of a patient's medical treatment policy. 

 **References** 

* [Medical Policy Goal](StructureDefinition-ACP-Medical-Policy-Goal.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT Dutch edition 30-Sep 2024

This value set contains 2 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ACP-MedicalPolicyGoal",
  "url" : "https://api.iknl.nl/docs/pzp/r4/ValueSet/ACP-MedicalPolicyGoal",
  "version" : "1.0.0-rc1",
  "name" : "MedicalPolicyGoalVS",
  "title" : "Most Important Agreed-upon Goal of Medical Policy",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "ValueSet for Medical Policy Goal, representing the primary agreed-upon goal of a patient's medical treatment policy.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "385987000",
            "display" : "zorg bij ziekte en/of letsel"
          },
          {
            "code" : "1351964001",
            "display" : "levensverlengende behandeling"
          },
          {
            "code" : "713148004",
            "display" : "voorkomen en behandelen van symptomen"
          }
        ]
      }
    ]
  }
}

```
