# ext LegallyCapable regarding medical treatment decisions - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ext LegallyCapable regarding medical treatment decisions**

## Extension: ext LegallyCapable regarding medical treatment decisions 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ExtLegallyCapableMedicalTreatmentDecisions |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

An extension to indicate the patient's legal capability regarding medical treatment decisions, and to provide a comment on this capability.

This extension is based on the [extension FreedomRestrictingIntervention.LegallyCapable](http://nictiz.nl/fhir/StructureDefinition/ext-FreedomRestrictingIntervention.LegallyCapable), but is adapted for the ACP context by allowing its use on the Patient resource and specifying its application to treatment decisions.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient](StructureDefinition-ACP-Patient.md)
* Examples for this Extension: [Patient/F1-ACP-Patient-HendrikHartman](Patient-F1-ACP-Patient-HendrikHartman.md) and [Patient/P2-ACP-Patient-SamiraVanDerSluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-LegallyCapable-MedicalTreatmentDecisions.csv), [Excel](StructureDefinition-ext-LegallyCapable-MedicalTreatmentDecisions.xlsx), [Schematron](StructureDefinition-ext-LegallyCapable-MedicalTreatmentDecisions.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-LegallyCapable-MedicalTreatmentDecisions",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions",
  "version" : "1.0.0-rc1",
  "name" : "ExtLegallyCapableMedicalTreatmentDecisions",
  "title" : "ext LegallyCapable regarding medical treatment decisions",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "An extension to indicate the patient's legal capability regarding medical treatment decisions, and to provide a comment on this capability.",
  "purpose" : "This extension is based on the [extension FreedomRestrictingIntervention.LegallyCapable](http://nictiz.nl/fhir/StructureDefinition/ext-FreedomRestrictingIntervention.LegallyCapable), but is adapted for the ACP context by allowing its use on the Patient resource and specifying its application to treatment decisions.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension|4.0.1",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "ext LegallyCapable regarding medical treatment decisions",
        "definition" : "An extension to indicate the patient's legal capability regarding medical treatment decisions, and to provide a comment on this capability."
      },
      {
        "id" : "Extension.extension:legallyCapable",
        "path" : "Extension.extension",
        "sliceName" : "legallyCapable",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:legallyCapable.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:legallyCapable.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "legallyCapable"
      },
      {
        "id" : "Extension.extension:legallyCapable.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "LegallyCapable",
        "definition" : "Indicates the patient's legal capacity (LegallyCapable) regarding medical treatment decisions.",
        "alias" : ["Wilsbekwaam"],
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Extension.extension:legallyCapableComment",
        "path" : "Extension.extension",
        "sliceName" : "legallyCapableComment",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:legallyCapableComment.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:legallyCapableComment.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "legallyCapableComment"
      },
      {
        "id" : "Extension.extension:legallyCapableComment.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "LegallyCapableComment",
        "definition" : "A comment regarding the patient's legal capacity regarding medical treatment decisions.",
        "alias" : ["WilsbekwaamToelichting"],
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
