# TreatmentDirective - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TreatmentDirective**

## Resource Profile: TreatmentDirective 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPTreatmentDirective |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
A joint decision between a health professional (for example a general practitioner) and a patient or his representative(s) about the desirability of performing a certain treatment, such as resuscitation, before this treatment becomes (acute) necessary. Based on nl-core-TreatmentDirective2 and HCIM TreatmentDirective2. 

**Usages:**

* Examples for this Profile: [Consent/F1-ACP-TreatmentDirective-116762002](Consent-F1-ACP-TreatmentDirective-116762002.md), [Consent/F1-ACP-TreatmentDirective-281789004](Consent-F1-ACP-TreatmentDirective-281789004.md), [Consent/F1-ACP-TreatmentDirective-305351004](Consent-F1-ACP-TreatmentDirective-305351004.md), [Consent/F1-ACP-TreatmentDirective-32485007](Consent-F1-ACP-TreatmentDirective-32485007.md)...Show 12 more,[Consent/F1-ACP-TreatmentDirective-400231000146108](Consent-F1-ACP-TreatmentDirective-400231000146108.md),[Consent/F1-ACP-TreatmentDirective-40617009](Consent-F1-ACP-TreatmentDirective-40617009.md),[Consent/F1-ACP-TreatmentDirective-89666000](Consent-F1-ACP-TreatmentDirective-89666000.md),[Consent/F2-ACP-TreatmentDirective-305351004](Consent-F2-ACP-TreatmentDirective-305351004.md),[Consent/P2-ACP-TreatmentDirective-281789004](Consent-P2-ACP-TreatmentDirective-281789004.md),[Consent/P2-ACP-TreatmentDirective-305351004](Consent-P2-ACP-TreatmentDirective-305351004.md),[Consent/P2-ACP-TreatmentDirective-32485007](Consent-P2-ACP-TreatmentDirective-32485007.md),[Consent/P2-ACP-TreatmentDirective-400231000146108](Consent-P2-ACP-TreatmentDirective-400231000146108.md),[Consent/P2-ACP-TreatmentDirective-40617009-1](Consent-P2-ACP-TreatmentDirective-40617009-1.md),[Consent/P2-ACP-TreatmentDirective-40617009-2](Consent-P2-ACP-TreatmentDirective-40617009-2.md),[Consent/P2-ACP-TreatmentDirective-89666000](Consent-P2-ACP-TreatmentDirective-89666000.md)and[Consent/P2-ACP-TreatmentDirective-other](Consent-P2-ACP-TreatmentDirective-other.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ACP-TreatmentDirective)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ACP-TreatmentDirective.csv), [Excel](StructureDefinition-ACP-TreatmentDirective.xlsx), [Schematron](StructureDefinition-ACP-TreatmentDirective.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ACP-TreatmentDirective",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective",
  "version" : "1.0.0-rc1",
  "name" : "ACPTreatmentDirective",
  "title" : "TreatmentDirective",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "A joint decision between a health professional (for example a general practitioner) and a patient or his representative(s) about the desirability of performing a certain treatment, such as resuscitation, before this treatment becomes (acute) necessary. Based on nl-core-TreatmentDirective2 and HCIM TreatmentDirective2.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "pall-izppz-zib2020v2025-03-11",
      "uri" : "https://decor.nictiz.nl/exist/apps/api/dataset/2.16.840.1.113883.2.4.3.11.60.117.1.1/2020-07-29T10%3A37%3A48/$view?language=nl-NL&ui=nl-NL&format=html&hidecolumns=3456gh&release=2025-10-29T13%3A09%3A23",
      "name" : "ACP dataset"
    },
    {
      "identity" : "zib-treatmentdirective2-v1.0-2020EN",
      "uri" : "https://zibs.nl/wiki/TreatmentDirective2-v1.0(2020EN)",
      "name" : "zib TreatmentDirective2-v1.0(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-TreatmentDirective2",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "602",
            "comment" : "Behandelgrens (BehandelAanwijzing)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "637",
            "comment" : "Afspraak uitzetten ICD (BehandelAanwijzing)"
          }
        ]
      },
      {
        "id" : "Consent.extension:comment",
        "path" : "Consent.extension",
        "sliceName" : "comment"
      },
      {
        "id" : "Consent.extension:comment.extension",
        "path" : "Consent.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Consent.extension:comment.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "618",
            "comment" : "Toelichting"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "653",
            "comment" : "Toelichting"
          }
        ]
      },
      {
        "id" : "Consent.extension:additionalAdvanceDirective",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Consent.extension",
        "sliceName" : "additionalAdvanceDirective"
      },
      {
        "id" : "Consent.extension:additionalAdvanceDirective.extension",
        "path" : "Consent.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Consent.extension:additionalAdvanceDirective.value[x]",
        "path" : "Consent.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-AdvanceDirective|1.0.0-rc1"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "644",
            "comment" : "Wilsverklaring"
          }
        ]
      },
      {
        "id" : "Consent.extension:encounter",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.extension",
        "sliceName" : "encounter",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Consent.extension:encounter.value[x]",
        "path" : "Consent.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Consent.modifierExtension:specificationOther",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Consent.modifierExtension",
        "sliceName" : "specificationOther"
      },
      {
        "id" : "Consent.modifierExtension:specificationOther.value[x]",
        "path" : "Consent.modifierExtension.value[x]",
        "comment" : "In addition to the default zib/nl-core guidance, this extension is used to communicate further details about agreements concerning ICD.",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "605",
            "comment" : "SpecificatieAnders"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "638",
            "comment" : "Afspraak uitzetten ICD (BehandelBesluit)"
          }
        ]
      },
      {
        "id" : "Consent.patient",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Consent.dateTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.dateTime",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "606",
            "comment" : "MeestRecenteBespreekdatum"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "641",
            "comment" : "MeestRecenteBespreekdatum"
          }
        ]
      },
      {
        "id" : "Consent.source[x]:sourceReference",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.source[x]",
        "sliceName" : "sourceReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-AdvanceDirective|1.0.0-rc1"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "609",
            "comment" : "Wilsverklaring"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "644",
            "comment" : "Wilsverklaring"
          }
        ]
      },
      {
        "id" : "Consent.provision.extension:reasonForEnding",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Consent.provision.extension",
        "sliceName" : "reasonForEnding",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "643",
            "comment" : "RedenBeeindigd"
          }
        ]
      },
      {
        "id" : "Consent.provision.extension:reasonForEnding.value[x]",
        "path" : "Consent.provision.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "608",
            "comment" : "RedenBeeindigd"
          }
        ]
      },
      {
        "id" : "Consent.provision.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.provision.type",
        "comment" : "Additional terminology mapping guidance, in addition to the default zib/nl-core guidance: \n- BehandelBesluit (dataset id 603) values: \n    - _Wel uitvoeren_ -> _permit_\n    - _Niet uitvoeren_ -> _deny_\n    - _Anders_ or _Onbekend_ -> do not set a value. Instead, communicate this via the `modifierExtension[specificationOther].value[x]` element.\n- Afspraak uitzetten ICD (dataset id 638) values: \n    - _Wel uitvoeren_ -> _permit_ \n    - No value is mapped to _deny_\n    - _Nee, nog geen besluit genomen_ or _Niet besproken_ -> do not set a value. Instead, communicate this via the `modifierExtension[specificationOther].value[x]` element.",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "603",
            "comment" : "BehandelBesluit"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "638",
            "comment" : "Afspraak uitzetten ICD (BehandelBesluit)"
          }
        ]
      },
      {
        "id" : "Consent.provision.period.end",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.provision.period.end",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "607",
            "comment" : "DatumBeeindigd"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "642",
            "comment" : "DatumBeeindigd"
          }
        ]
      },
      {
        "id" : "Consent.provision.actor:agreementParty",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "provisionActor"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.provision.actor",
        "sliceName" : "agreementParty",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "611",
            "comment" : "AfspraakPartij"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "646",
            "comment" : "AfspraakPartij"
          }
        ]
      },
      {
        "id" : "Consent.provision.actor:agreementParty.reference",
        "path" : "Consent.provision.actor.reference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1",
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole|1.0.0-rc1",
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson|1.0.0-rc1"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "612",
            "comment" : "Patient"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "614",
            "comment" : "Vertegenwoordiger"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "616",
            "comment" : "Zorgverlener"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "647",
            "comment" : "Patient"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "649",
            "comment" : "Vertegenwoordiger"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "651",
            "comment" : "Zorgverlener"
          }
        ]
      },
      {
        "id" : "Consent.provision.code",
        "path" : "Consent.provision.code",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "604",
            "comment" : "Behandeling"
          }
        ]
      },
      {
        "id" : "Consent.provision.code.text",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable",
            "valueBoolean" : true
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Consent.provision.code.text",
        "comment" : "`.provision.type` has a required binding. Therefore, only codes in the bound ValueSet are permitted. For concepts not present in the ValueSet, such as SNOMED CT code 400231000146108 (Uitzetten van cardioverter-defibrillator in laatste levensfase), use the `.text` field as per FHIR guidance.",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "639",
            "comment" : "Behandeling van ICD (Behandeling)"
          }
        ]
      }
    ]
  }
}

```
