# Advance Care Planning Procedure - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Advance Care Planning Procedure**

## Resource Profile: Advance Care Planning Procedure 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Procedure | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPProcedure |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
Advance Care Planning procedure. Based on nl-core-Procedure-event profile and HCIM Procedure. 

**Usages:**

* Examples for this Profile: [Procedure/F1-ACP-Procedure-01-10-2020](Procedure-F1-ACP-Procedure-01-10-2020.md), [Procedure/P2-ACP-Procedure-07-08-2025](Procedure-P2-ACP-Procedure-07-08-2025.md) and [Procedure/P2-ACP-Procedure-28-07-2024](Procedure-P2-ACP-Procedure-28-07-2024.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ACP-Procedure)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ACP-Procedure.csv), [Excel](StructureDefinition-ACP-Procedure.xlsx), [Schematron](StructureDefinition-ACP-Procedure.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ACP-Procedure",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Procedure",
  "version" : "1.0.0-rc1",
  "name" : "ACPProcedure",
  "title" : "Advance Care Planning Procedure",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "Advance Care Planning procedure. Based on nl-core-Procedure-event profile and HCIM Procedure.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "pall-izppz-zib2020v2025-03-11",
      "uri" : "https://decor.nictiz.nl/exist/apps/api/dataset/2.16.840.1.113883.2.4.3.11.60.117.1.1/2020-07-29T10%3A37%3A48/$view?language=nl-NL&ui=nl-NL&format=html&hidecolumns=3456gh&release=2025-10-29T13%3A09%3A23",
      "name" : "ACP dataset"
    },
    {
      "identity" : "zib-procedure-v5.2-2020EN",
      "uri" : "https://zibs.nl/wiki/Procedure-v5.2(2020EN)",
      "name" : "zib Procedure-v5.2(2020EN)"
    },
    {
      "identity" : "zib-textresult-v4.4-2020EN",
      "uri" : "https://zibs.nl/wiki/TextResult-v4.4(2020EN)",
      "name" : "zib TextResult-v4.4(2020EN)"
    },
    {
      "identity" : "zib-medicaldevice-v3.3.1-2020EN",
      "uri" : "https://zibs.nl/wiki/MedicalDevice-v3.3.1(2020EN)",
      "name" : "zib MedicalDevice-v3.3.1(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-event",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "820",
            "comment" : "Verrichting"
          }
        ]
      },
      {
        "id" : "Procedure.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "713603004"
            }
          ]
        },
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "827",
            "comment" : "PZP gesprek (VerrichtingType)"
          }
        ]
      },
      {
        "id" : "Procedure.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.encounter",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Procedure.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer.actor",
        "path" : "Procedure.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole|1.0.0-rc1",
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson|1.0.0-rc1",
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
            ]
          }
        ]
      }
    ]
  }
}

```
