# Patient - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient**

## Resource Profile: Patient 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPPatient |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
A person who receives medical, psychological, paramedical, or nursing care. Based on nl-core-Patient and HCIM Patient. 

**Usages:**

* Refer to this Profile: [AdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md), [Communication](StructureDefinition-ACP-Communication.md), [ContactPerson](StructureDefinition-ACP-ContactPerson.md), [Encounter](StructureDefinition-ACP-Encounter.md)...Show 9 more,[Medical Policy Goal](StructureDefinition-ACP-Medical-Policy-Goal.md),[MedicalDevice](StructureDefinition-ACP-MedicalDevice.md),[Organ donation choice registration in donor register](StructureDefinition-ACP-OrganDonationChoiceRegistration.md),[Other Important Information](StructureDefinition-ACP-OtherImportantInformation.md),[Position Regarding Euthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md),[Preferred Place Of Death](StructureDefinition-ACP-PreferredPlaceOfDeath.md),[Advance Care Planning Procedure](StructureDefinition-ACP-Procedure.md),[Specific Care Wishes](StructureDefinition-ACP-SpecificCareWishes.md)and[TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)
* Examples for this Profile: [Patient/F1-ACP-Patient-HendrikHartman](Patient-F1-ACP-Patient-HendrikHartman.md) and [Patient/P2-ACP-Patient-SamiraVanDerSluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ACP-Patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ACP-Patient.csv), [Excel](StructureDefinition-ACP-Patient.xlsx), [Schematron](StructureDefinition-ACP-Patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ACP-Patient",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient",
  "version" : "1.0.0-rc1",
  "name" : "ACPPatient",
  "title" : "Patient",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "A person who receives medical, psychological, paramedical, or nursing care. Based on nl-core-Patient and HCIM Patient.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "pall-izppz-zib2020v2025-03-11",
      "uri" : "https://decor.nictiz.nl/exist/apps/api/dataset/2.16.840.1.113883.2.4.3.11.60.117.1.1/2020-07-29T10%3A37%3A48/$view?language=nl-NL&ui=nl-NL&format=html&hidecolumns=3456gh&release=2025-10-29T13%3A09%3A23",
      "name" : "ACP dataset"
    },
    {
      "identity" : "zib-patient-v3.2-2020EN",
      "uri" : "https://zibs.nl/wiki/Patient-v3.2(2020EN)",
      "name" : "zib Patient-v3.2(2020EN)"
    },
    {
      "identity" : "zib-nationality-v3.0-2020EN",
      "uri" : "https://zibs.nl/wiki/Nationality-v3.0(2020EN)",
      "name" : "zib Nationality-v3.0(2020EN)"
    },
    {
      "identity" : "zib-maritalstatus-v3.1-2020EN",
      "uri" : "https://zibs.nl/wiki/MaritalStatus-v3.1(2020EN)",
      "name" : "zib MaritalStatus-v3.1(2020EN)"
    },
    {
      "identity" : "zib-languageproficiency-v3.2-2020EN",
      "uri" : "https://zibs.nl/wiki/LanguageProficiency-v3.2(2020EN)",
      "name" : "zib LanguageProficiency-v3.2(2020EN)"
    },
    {
      "identity" : "zib-contactinformation-v1.2-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.2(2020EN)",
      "name" : "zib ContactInformation-v1.2(2020EN)"
    },
    {
      "identity" : "zib-contactperson-v3.4-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactPerson-v3.4(2020EN)",
      "name" : "zib ContactPerson-v3.4(2020EN)"
    },
    {
      "identity" : "zib-payer-v3.1.1-2020EN",
      "uri" : "https://zibs.nl/wiki/Payer-v3.1.1(2020EN)",
      "name" : "zib Payer-v3.1.1(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "constraint" : [
          {
            "key" : "ACP-Patient-1",
            "severity" : "warning",
            "human" : "If the patient is not legally capable, there should be a legal representative.",
            "expression" : "extension.where(url='https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions').extension.where(url='legallyCapable').value = false implies (contact.where(relationship.coding.code = '24').exists() or contact.extension.where(url='http://hl7.org/fhir/StructureDefinition/patient-relatedPerson').exists())",
            "source" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
          }
        ],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "351",
            "comment" : "Patient"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "613",
            "comment" : "Patient"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "648",
            "comment" : "Patient"
          }
        ]
      },
      {
        "id" : "Patient.extension:legallyCapableMedicalTreatmentDecisions",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "legallyCapableMedicalTreatmentDecisions",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions|1.0.0-rc1"
            ]
          }
        ],
        "condition" : ["ACP-Patient-1"],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "761",
            "comment" : "Wilsbekwaamheid m.b.t. medische behandelbeslissingen"
          }
        ]
      },
      {
        "id" : "Patient.extension:legallyCapableMedicalTreatmentDecisions.extension:legallyCapable",
        "path" : "Patient.extension.extension",
        "sliceName" : "legallyCapable"
      },
      {
        "id" : "Patient.extension:legallyCapableMedicalTreatmentDecisions.extension:legallyCapable.value[x]",
        "path" : "Patient.extension.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "762",
            "comment" : "Wilsbekwaamheid m.b.t. medische behandelbeslissingen"
          }
        ]
      },
      {
        "id" : "Patient.extension:legallyCapableMedicalTreatmentDecisions.extension:legallyCapableComment",
        "path" : "Patient.extension.extension",
        "sliceName" : "legallyCapableComment"
      },
      {
        "id" : "Patient.extension:legallyCapableMedicalTreatmentDecisions.extension:legallyCapableComment.value[x]",
        "path" : "Patient.extension.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "763",
            "comment" : "Toelichting"
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.identifier",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "385",
            "comment" : "Identificatienummer"
          }
        ]
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "352",
            "comment" : "Naamgegevens"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "515",
            "comment" : "Naamgegevens"
          }
        ]
      },
      {
        "id" : "Patient.name:nameInformation",
        "path" : "Patient.name",
        "sliceName" : "nameInformation"
      },
      {
        "id" : "Patient.name:nameInformation.use",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.use",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "356",
            "comment" : "Naamgebruik"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "519",
            "comment" : "Naamgebruik"
          }
        ]
      },
      {
        "id" : "Patient.name:nameInformation.family.extension:prefix",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.family.extension",
        "sliceName" : "prefix"
      },
      {
        "id" : "Patient.name:nameInformation.family.extension:prefix.value[x]",
        "path" : "Patient.name.family.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "358",
            "comment" : "Voorvoegsels"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "521",
            "comment" : "Voorvoegsels"
          }
        ]
      },
      {
        "id" : "Patient.name:nameInformation.family.extension:lastName",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.family.extension",
        "sliceName" : "lastName"
      },
      {
        "id" : "Patient.name:nameInformation.family.extension:lastName.value[x]",
        "path" : "Patient.name.family.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "359",
            "comment" : "Achternaam"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "522",
            "comment" : "Achternaam"
          }
        ]
      },
      {
        "id" : "Patient.name:nameInformation.family.extension:partnerPrefix",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.family.extension",
        "sliceName" : "partnerPrefix"
      },
      {
        "id" : "Patient.name:nameInformation.family.extension:partnerPrefix.value[x]",
        "path" : "Patient.name.family.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "361",
            "comment" : "VoorvoegselsPartner"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "524",
            "comment" : "VoorvoegselsPartner"
          }
        ]
      },
      {
        "id" : "Patient.name:nameInformation.family.extension:partnerLastName",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.family.extension",
        "sliceName" : "partnerLastName"
      },
      {
        "id" : "Patient.name:nameInformation.family.extension:partnerLastName.value[x]",
        "path" : "Patient.name.family.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "362",
            "comment" : "AchternaamPartner"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "525",
            "comment" : "AchternaamPartner"
          }
        ]
      },
      {
        "id" : "Patient.name:nameInformation.given",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.given",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "353",
            "comment" : "Voornamen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "354",
            "comment" : "Initialen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "516",
            "comment" : "Voornamen"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "517",
            "comment" : "Initialen"
          }
        ]
      },
      {
        "id" : "Patient.name:nameInformation.suffix",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.suffix",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "363",
            "comment" : "Titels"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "526",
            "comment" : "Titels"
          }
        ]
      },
      {
        "id" : "Patient.name:nameInformation-GivenName",
        "path" : "Patient.name",
        "sliceName" : "nameInformation-GivenName"
      },
      {
        "id" : "Patient.name:nameInformation-GivenName.given",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.name.given",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "355",
            "comment" : "Roepnaam"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "518",
            "comment" : "Roepnaam"
          }
        ]
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "376",
            "comment" : "Contactgegevens"
          }
        ]
      },
      {
        "id" : "Patient.telecom:telephoneNumbers",
        "path" : "Patient.telecom",
        "sliceName" : "telephoneNumbers",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "377",
            "comment" : "Telefoonnummers"
          }
        ]
      },
      {
        "id" : "Patient.telecom:telephoneNumbers.extension:comment",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Patient.telecom.extension",
        "sliceName" : "comment"
      },
      {
        "id" : "Patient.telecom:telephoneNumbers.extension:comment.value[x]",
        "path" : "Patient.telecom.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "381",
            "comment" : "Toelichting"
          }
        ]
      },
      {
        "id" : "Patient.telecom:telephoneNumbers.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.system",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "379",
            "comment" : "TelecomType"
          }
        ]
      },
      {
        "id" : "Patient.telecom:telephoneNumbers.system.extension:telecomType",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Patient.telecom.system.extension",
        "sliceName" : "telecomType"
      },
      {
        "id" : "Patient.telecom:telephoneNumbers.system.extension:telecomType.value[x]",
        "path" : "Patient.telecom.system.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "379",
            "comment" : "TelecomType"
          }
        ]
      },
      {
        "id" : "Patient.telecom:telephoneNumbers.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.value",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "378",
            "comment" : "Telefoonnummer"
          }
        ]
      },
      {
        "id" : "Patient.telecom:telephoneNumbers.use",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.use",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "380",
            "comment" : "NummerSoort"
          }
        ]
      },
      {
        "id" : "Patient.telecom:emailAddresses",
        "path" : "Patient.telecom",
        "sliceName" : "emailAddresses",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "382",
            "comment" : "EmailAdressen"
          }
        ]
      },
      {
        "id" : "Patient.telecom:emailAddresses.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.system",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "384",
            "comment" : "EmailSoort"
          }
        ]
      },
      {
        "id" : "Patient.telecom:emailAddresses.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.telecom.value",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "383",
            "comment" : "EmailAdres"
          }
        ]
      },
      {
        "id" : "Patient.gender",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.gender",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "387",
            "comment" : "Geslacht"
          }
        ]
      },
      {
        "id" : "Patient.gender.extension:genderCodelist",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Patient.gender.extension",
        "sliceName" : "genderCodelist"
      },
      {
        "id" : "Patient.gender.extension:genderCodelist.value[x]",
        "path" : "Patient.gender.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "387",
            "comment" : "Geslacht"
          }
        ]
      },
      {
        "id" : "Patient.birthDate",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.birthDate",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "386",
            "comment" : "Geboortedatum"
          }
        ]
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "364",
            "comment" : "Adresgegevens"
          }
        ]
      },
      {
        "id" : "Patient.address.use",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.use",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "375",
            "comment" : "AdresSoort"
          }
        ]
      },
      {
        "id" : "Patient.address.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.type",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "375",
            "comment" : "AdresSoort"
          }
        ]
      },
      {
        "id" : "Patient.address.line.extension:streetName",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.line.extension",
        "sliceName" : "streetName"
      },
      {
        "id" : "Patient.address.line.extension:streetName.value[x]",
        "path" : "Patient.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "365",
            "comment" : "Straat"
          }
        ]
      },
      {
        "id" : "Patient.address.line.extension:houseNumber",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.line.extension",
        "sliceName" : "houseNumber"
      },
      {
        "id" : "Patient.address.line.extension:houseNumber.value[x]",
        "path" : "Patient.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "366",
            "comment" : "Huisnummer"
          }
        ]
      },
      {
        "id" : "Patient.address.line.extension:houseNumberLetter-houseNumberAddition",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.line.extension",
        "sliceName" : "houseNumberLetter-houseNumberAddition"
      },
      {
        "id" : "Patient.address.line.extension:houseNumberLetter-houseNumberAddition.value[x]",
        "path" : "Patient.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "367",
            "comment" : "Huisnummerletter"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "368",
            "comment" : "Huisnummertoevoeging"
          }
        ]
      },
      {
        "id" : "Patient.address.line.extension:houseNumberIndication",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.line.extension",
        "sliceName" : "houseNumberIndication"
      },
      {
        "id" : "Patient.address.line.extension:houseNumberIndication.value[x]",
        "path" : "Patient.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "369",
            "comment" : "AanduidingBijHuisnummer"
          }
        ]
      },
      {
        "id" : "Patient.address.line.extension:additionalInformation",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.line.extension",
        "sliceName" : "additionalInformation"
      },
      {
        "id" : "Patient.address.line.extension:additionalInformation.value[x]",
        "path" : "Patient.address.line.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "374",
            "comment" : "AdditioneleInformatie"
          }
        ]
      },
      {
        "id" : "Patient.address.city",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.city",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "371",
            "comment" : "Woonplaats"
          }
        ]
      },
      {
        "id" : "Patient.address.district",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.district",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "372",
            "comment" : "Gemeente"
          }
        ]
      },
      {
        "id" : "Patient.address.postalCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.address.postalCode",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "370",
            "comment" : "Postcode"
          }
        ]
      },
      {
        "id" : "Patient.address.country.extension:countryCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Patient.address.country.extension",
        "sliceName" : "countryCode"
      },
      {
        "id" : "Patient.address.country.extension:countryCode.value[x]",
        "path" : "Patient.address.country.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "373",
            "comment" : "Land"
          }
        ]
      },
      {
        "id" : "Patient.contact",
        "path" : "Patient.contact",
        "condition" : ["ACP-Patient-1"]
      },
      {
        "id" : "Patient.contact.extension:contactPerson",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Patient.contact.extension",
        "sliceName" : "contactPerson",
        "comment" : "All information regarding the patient's contact persons should preferably be stored in the RelatedPerson resource, and optionally in `Patient.contact`. The http://hl7.org/fhir/StructureDefinition/patient-relatedPerson extension is used to link the contact person to the Patient and to emphasize that the related person is also a contact person of the patient.",
        "condition" : ["ACP-Patient-1"]
      },
      {
        "id" : "Patient.contact.extension:contactPerson.value[x]",
        "path" : "Patient.contact.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.relationship",
        "path" : "Patient.contact.relationship",
        "condition" : ["ACP-Patient-1"]
      }
    ]
  }
}

```
