# HealthProfessional PractitionerRole - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HealthProfessional PractitionerRole**

## Resource Profile: HealthProfessional PractitionerRole 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPHealthProfessionalPractitionerRole |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
The specialty of a person who is authorized to perform actions in the field of individual healthcare. Based on nl-core-HealthProfessionalPractitionerRole and HCIM HealthProfessional. 

**Usages:**

* Refer to this Profile: [Communication](StructureDefinition-ACP-Communication.md), [Encounter](StructureDefinition-ACP-Encounter.md), [Advance Care Planning Procedure](StructureDefinition-ACP-Procedure.md) and [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)
* Examples for this Profile: [PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md), [PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters.md) and [PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-Santos](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-Santos.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ACP-HealthProfessional-PractitionerRole)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ACP-HealthProfessional-PractitionerRole.csv), [Excel](StructureDefinition-ACP-HealthProfessional-PractitionerRole.xlsx), [Schematron](StructureDefinition-ACP-HealthProfessional-PractitionerRole.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ACP-HealthProfessional-PractitionerRole",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole",
  "version" : "1.0.0-rc1",
  "name" : "ACPHealthProfessionalPractitionerRole",
  "title" : "HealthProfessional PractitionerRole",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "The specialty of a person who is authorized to perform actions in the field of individual healthcare. Based on nl-core-HealthProfessionalPractitionerRole and HCIM HealthProfessional.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "pall-izppz-zib2020v2025-03-11",
      "uri" : "https://decor.nictiz.nl/exist/apps/api/dataset/2.16.840.1.113883.2.4.3.11.60.117.1.1/2020-07-29T10%3A37%3A48/$view?language=nl-NL&ui=nl-NL&format=html&hidecolumns=3456gh&release=2025-10-29T13%3A09%3A23",
      "name" : "ACP dataset"
    },
    {
      "identity" : "zib-healthprofessional-v3.5-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.5(2020EN)",
      "name" : "zib HealthProfessional-v3.5(2020EN)"
    },
    {
      "identity" : "zib-contactinformation-v1.2-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.2(2020EN)",
      "name" : "zib ContactInformation-v1.2(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthProfessional-PractitionerRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "391",
            "comment" : "Gesprek gevoerd door (Zorgverlener)"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "617",
            "comment" : "Zorgverlener"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "636",
            "comment" : "Zorgverlener"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "652",
            "comment" : "Zorgverlener"
          }
        ]
      },
      {
        "id" : "PractitionerRole.practitioner",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.practitioner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-Practitioner|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.specialty:specialty",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.specialty",
        "sliceName" : "specialty",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "405",
            "comment" : "Specialisme"
          }
        ]
      }
    ]
  }
}

```
