# Encounter - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter**

## Resource Profile: Encounter 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPEncounter |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
Any interaction, regardless of the situation, between a patient and the healthcare provider, in which the healthcare provider has primary responsibility for diagnosing, evaluating and treating the patient’s condition and informing the patient. These can be visits, appointments or non face-to-face interactions. Based on nl-core-Encounter and HCIM Encounter. 

**Usages:**

* Refer to this Profile: [AdvanceDirective](StructureDefinition-ACP-AdvanceDirective.md), [Medical Policy Goal](StructureDefinition-ACP-Medical-Policy-Goal.md), [MedicalDevice](StructureDefinition-ACP-MedicalDevice.md), [Organ donation choice registration in donor register](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)...Show 6 more,[Other Important Information](StructureDefinition-ACP-OtherImportantInformation.md),[Position Regarding Euthanasia](StructureDefinition-ACP-PositionRegardingEuthanasia.md),[Preferred Place Of Death](StructureDefinition-ACP-PreferredPlaceOfDeath.md),[Advance Care Planning Procedure](StructureDefinition-ACP-Procedure.md),[Specific Care Wishes](StructureDefinition-ACP-SpecificCareWishes.md)and[TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)
* Examples for this Profile: [Encounter/F1-ACP-Encounter-01-10-2020](Encounter-F1-ACP-Encounter-01-10-2020.md), [Encounter/P2-ACP-Encounter-07-08-2025](Encounter-P2-ACP-Encounter-07-08-2025.md) and [Encounter/P2-ACP-Encounter-28-07-2024](Encounter-P2-ACP-Encounter-28-07-2024.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ACP-Encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ACP-Encounter.csv), [Excel](StructureDefinition-ACP-Encounter.xlsx), [Schematron](StructureDefinition-ACP-Encounter.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ACP-Encounter",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Encounter",
  "version" : "1.0.0-rc1",
  "name" : "ACPEncounter",
  "title" : "Encounter",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "Any interaction, regardless of the situation, between a patient and the healthcare provider, in which the healthcare provider has primary responsibility for diagnosing, evaluating and treating the patient’s condition and informing the patient. These can be visits, appointments or non face-to-face interactions. Based on nl-core-Encounter and HCIM Encounter.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "pall-izppz-zib2020v2025-03-11",
      "uri" : "https://decor.nictiz.nl/exist/apps/api/dataset/2.16.840.1.113883.2.4.3.11.60.117.1.1/2020-07-29T10%3A37%3A48/$view?language=nl-NL&ui=nl-NL&format=html&hidecolumns=3456gh&release=2025-10-29T13%3A09%3A23",
      "name" : "ACP dataset"
    },
    {
      "identity" : "zib-encounter-v4.0.1-2020EN",
      "uri" : "https://zibs.nl/wiki/Encounter-v4.0.1(2020EN)",
      "name" : "zib Encounter-v4.0.1(2020EN)"
    },
    {
      "identity" : "zib-healthprofessional-v3.5-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.5(2020EN)",
      "name" : "zib HealthProfessional-v3.5(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "808",
            "comment" : "Contact"
          }
        ]
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "809",
            "comment" : "ContactType"
          }
        ]
      },
      {
        "id" : "Encounter.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "514",
            "comment" : "Gesprek gevoerd in bijzijn van (Patient)"
          }
        ]
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "810",
            "comment" : "ContactMet"
          }
        ]
      },
      {
        "id" : "Encounter.participant:healthProfessional",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.participant",
        "sliceName" : "healthProfessional"
      },
      {
        "id" : "Encounter.participant:healthProfessional.individual",
        "path" : "Encounter.participant.individual",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole|1.0.0-rc1"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "842",
            "comment" : "Gesprek gevoerd door (Zorgverlener)"
          }
        ]
      },
      {
        "id" : "Encounter.participant:contactPerson",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.participant",
        "sliceName" : "contactPerson",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:contactPerson.individual",
        "path" : "Encounter.participant.individual",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-ContactPerson|1.0.0-rc1"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "554",
            "comment" : "Gesprek gevoerd in bijzijn van (Contactpersoon)"
          }
        ]
      },
      {
        "id" : "Encounter.period.start",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.period.start",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "814",
            "comment" : "BeginDatumTijd"
          },
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "736",
            "comment" : "Datum van invullen"
          }
        ]
      },
      {
        "id" : "Encounter.reasonCode:deviatingResult",
        "path" : "Encounter.reasonCode",
        "sliceName" : "deviatingResult"
      },
      {
        "id" : "Encounter.reasonCode:deviatingResult.extension:commentContactReason",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Encounter.reasonCode.extension",
        "sliceName" : "commentContactReason"
      },
      {
        "id" : "Encounter.reasonCode:deviatingResult.extension:commentContactReason.value[x]",
        "path" : "Encounter.reasonCode.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "822",
            "comment" : "ToelichtingRedenContact"
          }
        ]
      },
      {
        "id" : "Encounter.reasonReference",
        "path" : "Encounter.reasonReference"
      },
      {
        "id" : "Encounter.reasonReference.extension:commentContactReason",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "normative"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation",
            "valueCode" : "4.0.0"
          }
        ],
        "path" : "Encounter.reasonReference.extension",
        "sliceName" : "commentContactReason"
      },
      {
        "id" : "Encounter.reasonReference.extension:commentContactReason.value[x]",
        "path" : "Encounter.reasonReference.extension.value[x]",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "822",
            "comment" : "ToelichtingRedenContact"
          }
        ]
      },
      {
        "id" : "Encounter.reasonReference:procedure",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Encounter.reasonReference",
        "sliceName" : "procedure",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "819",
            "comment" : "Verrichting"
          }
        ]
      }
    ]
  }
}

```
