# Communication - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Communication**

## Resource Profile: Communication 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Communication | *Version*:1.0.0-rc1 |
| Draft as of 2025-10-31 | *Computable Name*:ACPCommunication |
| **Copyright/Legal**: Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise. | |

 
Communication events that have taken place in context of Advance Care Planning. Based on Communication resource. 

**Usages:**

* Examples for this Profile: [Communication/F1-ACP-Communication-01-10-2020](Communication-F1-ACP-Communication-01-10-2020.md) and [Communication/P2-ACP-Communication-07-08-2025](Communication-P2-ACP-Communication-07-08-2025.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/iknl.fhir.r4.pzp|current/StructureDefinition/ACP-Communication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ACP-Communication.csv), [Excel](StructureDefinition-ACP-Communication.xlsx), [Schematron](StructureDefinition-ACP-Communication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ACP-Communication",
  "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Communication",
  "version" : "1.0.0-rc1",
  "name" : "ACPCommunication",
  "title" : "Communication",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-31T09:52:04+00:00",
  "publisher" : "IKNL",
  "contact" : [
    {
      "name" : "IKNL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://iknl.nl/"
        },
        {
          "system" : "email",
          "value" : "info@iknl.nl"
        }
      ]
    }
  ],
  "description" : "Communication events that have taken place in context of Advance Care Planning. Based on Communication resource.",
  "copyright" : "Copyright and related rights waived via CC0, https://creativecommons.org/publicdomain/zero/1.0/. This does not apply to information from third parties, for example a medical terminology system. The implementer alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize third party IP in connection with the specification or otherwise.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "pall-izppz-zib2020v2025-03-11",
      "uri" : "https://decor.nictiz.nl/exist/apps/api/dataset/2.16.840.1.113883.2.4.3.11.60.117.1.1/2020-07-29T10%3A37%3A48/$view?language=nl-NL&ui=nl-NL&format=html&hidecolumns=3456gh&release=2025-10-29T13%3A09%3A23",
      "name" : "ACP dataset"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Communication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Communication|4.0.1",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Communication",
        "path" : "Communication",
        "mapping" : [
          {
            "identity" : "pall-izppz-zib2020v2025-03-11",
            "map" : "734",
            "comment" : "Heeft u patient geïnformeerd over eigen verantwoordelijkheid om deze behandelafspraken met naasten te bespreken?"
          }
        ]
      },
      {
        "id" : "Communication.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Communication.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Communication.topic",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Communication.topic",
        "comment" : "For information patient about own responsibility the following text may be added to the `topic.text` element: Informing the patient about their own responsibility to discuss these treatment agreements with relatives."
      },
      {
        "id" : "Communication.sent",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Communication.sent",
        "comment" : "Indicate the date and preferrably time when the communication was sent"
      },
      {
        "id" : "Communication.recipient",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Communication.recipient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Communication.sender",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Communication.sender",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-HealthProfessional-PractitionerRole|1.0.0-rc1"
            ]
          }
        ]
      },
      {
        "id" : "Communication.reasonCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter|1.0.0-rc1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Communication.reasonCode",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "713603004"
            }
          ]
        }
      }
    ]
  }
}

```
