# P2 ACP Patient Samira van der Sluijs - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP Patient Samira van der Sluijs**

## Example Patient: P2 ACP Patient Samira van der Sluijs

Profile: [Patient](StructureDefinition-ACP-Patient.md)

Samira Female, DoB: 1959-07-31 ( http://fhir.nl/fhir/NamingSystem/bsn#999998298)

-------

| | |
| :--- | :--- |
| Alt. Name: | Samira van der Sluijs(Official) |
| Contact Detail | * ph: 0688877788(Home)
* [samira.test@iknl.nl](mailto:samira.test@iknl.nl)
* Vasteland 78 Rotterdam 3011BN Nederland (home)
 |
| ext LegallyCapable regarding medical treatment decisions: | * legallyCapable: true
* legallyCapableComment: Patiënt is wilsbekwaam. Bij verandering van de situatie wordt haar partner haar wettelijk vertegenwoordiger.
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "P2-ACP-Patient-SamiraVanDerSluijs",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Patient"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "legallyCapable",
          "valueBoolean" : true
        },
        {
          "url" : "legallyCapableComment",
          "valueString" : "Patiënt is wilsbekwaam. Bij verandering van de situatie wordt haar partner haar wettelijk vertegenwoordiger."
        }
      ],
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-LegallyCapable-MedicalTreatmentDecisions"
    }
  ],
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/bsn",
      "value" : "999998298"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "text" : "Samira van der Sluijs",
      "family" : "van der Sluijs",
      "_family" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
            "valueString" : "Sluijs"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-prefix",
            "valueString" : "van der"
          }
        ]
      },
      "given" : ["Samira", "Louise"],
      "_given" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier",
              "valueCode" : "BR"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier",
              "valueCode" : "BR"
            }
          ]
        }
      ]
    },
    {
      "use" : "usual",
      "given" : ["Samira"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "_system" : {
        "extension" : [
          {
            "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-CodeSpecification",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressUse",
                  "code" : "MC",
                  "display" : "mobile contact"
                }
              ]
            }
          }
        ]
      },
      "value" : "0688877788",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "samira.test@iknl.nl",
      "use" : "work"
    }
  ],
  "gender" : "female",
  "_gender" : {
    "extension" : [
      {
        "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-CodeSpecification",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-AdministrativeGender",
              "code" : "F",
              "display" : "Female"
            }
          ]
        }
      }
    ]
  },
  "birthDate" : "1959-07-31",
  "address" : [
    {
      "extension" : [
        {
          "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-AddressInformation.AddressType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-AddressUse",
                "code" : "HP",
                "display" : "Primary Home"
              }
            ]
          }
        }
      ],
      "use" : "home",
      "type" : "both",
      "line" : ["Vasteland 78"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Vasteland"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "78"
            }
          ]
        }
      ],
      "city" : "Rotterdam",
      "district" : "Rotterdam",
      "postalCode" : "3011BN",
      "country" : "Nederland",
      "_country" : {
        "extension" : [
          {
            "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-CodeSpecification",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "urn:iso:std:iso:3166",
                  "code" : "NL",
                  "display" : "Netherlands"
                }
              ]
            }
          }
        ]
      }
    }
  ]
}

```
