# F1 ACP Specific Care Wishes - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP Specific Care Wishes**

## Example Observation: F1 ACP Specific Care Wishes

Profile: [Specific Care Wishes](StructureDefinition-ACP-SpecificCareWishes.md)

**identifier**: Resource identifier/c68d0feb-ee43-45d5-86f5-a7f43a20f167

**status**: Final

**code**: wensen en verwachtingen met betrekking tot uitkomst van behandeling

**subject**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**encounter**: [Encounter, 2020-10-01](Encounter-F1-ACP-Encounter-01-10-2020.md)

**effective**: 2020-10-01

**performer**: [Healthcare professional (role), van Huissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md)

**value**: Hendrik wil er alles aan doen om zo lang mogelijk in goede gezondheid te kunnen leven. Hij probeert regelmatig te sporten en zou graag willen blijven hardlopen. Broer Michiel woont om de hoek en is erg betrokken bij het proces van Hendrik

**method**: vaststellen van persoonlijke waarden en wensen met betrekking tot zorg (verrichting)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "F1-ACP-SpecificCareWishes",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-SpecificCareWishes"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "c68d0feb-ee43-45d5-86f5-a7f43a20f167"
    }
  ],
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "153851000146100",
        "display" : "wensen en verwachtingen met betrekking tot uitkomst van behandeling"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "encounter" : {
    "reference" : "Encounter/F1-ACP-Encounter-01-10-2020",
    "display" : "Encounter, 2020-10-01"
  },
  "effectiveDateTime" : "2020-10-01",
  "performer" : [
    {
      "reference" : "PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen",
      "display" : "Healthcare professional (role), van Huissen"
    }
  ],
  "valueString" : "Hendrik wil er alles aan doen om zo lang mogelijk in goede gezondheid te kunnen leven. Hij probeert regelmatig te sporten en zou graag willen blijven hardlopen. Broer Michiel woont om de hoek en is erg betrokken bij het proces van Hendrik",
  "method" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "370819000",
        "display" : "vaststellen van persoonlijke waarden en wensen met betrekking tot zorg (verrichting)"
      }
    ]
  }
}

```
