# F1 ACP Donor Registration Yes - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP Donor Registration Yes**

## Example Observation: F1 ACP Donor Registration Yes

Profile: [Organ donation choice registration in donor register](StructureDefinition-ACP-OrganDonationChoiceRegistration.md)

**identifier**: Resource identifier/31952dca-757c-4e4e-b7f6-fab66a79deba

**status**: Final

**code**: geregistreerd in orgaan donorregister

**subject**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**encounter**: [Encounter, 2020-10-01](Encounter-F1-ACP-Encounter-01-10-2020.md)

**effective**: 2020-10-01

**performer**: [Healthcare professional (role), van Huissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md)

**value**: ja



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "F1-ACP-OrganDonationChoiceRegistration-Yes",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-OrganDonationChoiceRegistration"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "31952dca-757c-4e4e-b7f6-fab66a79deba"
    }
  ],
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "570801000146104",
        "display" : "geregistreerd in orgaan donorregister"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "encounter" : {
    "reference" : "Encounter/F1-ACP-Encounter-01-10-2020",
    "display" : "Encounter, 2020-10-01"
  },
  "effectiveDateTime" : "2020-10-01",
  "performer" : [
    {
      "reference" : "PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen",
      "display" : "Healthcare professional (role), van Huissen"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "373066001",
        "display" : "ja"
      }
    ]
  }
}

```
