# P2 ACP Medical Policy Goal - Life-sustaining treatment - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP Medical Policy Goal - Life-sustaining treatment**

## Example Goal: P2 ACP Medical Policy Goal - Life-sustaining treatment

Profile: [Medical Policy Goal](StructureDefinition-ACP-Medical-Policy-Goal.md)

**ext Encounter Reference**: [Encounter, 2025-08-07](Encounter-P2-ACP-Encounter-07-08-2025.md)

**identifier**: Resource identifier/b3aaf1a9-cbe3-4b7a-a6c8-ecc55a65e5e9

**lifecycleStatus**: Active

**description**: voorkomen en behandelen van symptomen

**subject**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

**statusDate**: 2025-08-07



## Resource Content

```json
{
  "resourceType" : "Goal",
  "id" : "P2-ACP-Medical-Policy-Goal",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Medical-Policy-Goal"
    ]
  },
  "extension" : [
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/P2-ACP-Encounter-07-08-2025",
        "display" : "Encounter, 2025-08-07"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "b3aaf1a9-cbe3-4b7a-a6c8-ecc55a65e5e9"
    }
  ],
  "lifecycleStatus" : "active",
  "description" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "713148004",
        "display" : "voorkomen en behandelen van symptomen"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
    "display" : "Patient, Samira van der Sluijs"
  },
  "statusDate" : "2025-08-07"
}

```
