# F1 ACP Medical Policy Goal - Life-sustaining treatment - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP Medical Policy Goal - Life-sustaining treatment**

## Example Goal: F1 ACP Medical Policy Goal - Life-sustaining treatment

Profile: [Medical Policy Goal](StructureDefinition-ACP-Medical-Policy-Goal.md)

**ext Encounter Reference**: [Encounter, 2020-10-01](Encounter-F1-ACP-Encounter-01-10-2020.md)

**identifier**: Resource identifier/a1e0d113-bf6d-4e5c-9bf4-044eda75b709

**lifecycleStatus**: Active

**description**: levensverlengende behandeling

**subject**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**statusDate**: 2020-10-01



## Resource Content

```json
{
  "resourceType" : "Goal",
  "id" : "F1-ACP-Medical-Policy-Goal",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-Medical-Policy-Goal"
    ]
  },
  "extension" : [
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/F1-ACP-Encounter-01-10-2020",
        "display" : "Encounter, 2020-10-01"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "a1e0d113-bf6d-4e5c-9bf4-044eda75b709"
    }
  ],
  "lifecycleStatus" : "active",
  "description" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1351964001",
        "display" : "levensverlengende behandeling"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "statusDate" : "2020-10-01"
}

```
