# P2 ACP MedicalDevice ICD - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP MedicalDevice ICD**

## Example DeviceUseStatement: P2 ACP MedicalDevice ICD

Profile: [MedicalDevice](StructureDefinition-ACP-MedicalDevice.md)

**ext MedicalDevice.HealthProfessional**: [Healthcare professional, Santos](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-Santos.md)

**ext Encounter Reference**: [Encounter, 2025-08-07](Encounter-P2-ACP-Encounter-07-08-2025.md)

**identifier**: Resource identifier/3fdc0ec5-2984-4b47-b6b8-f9822fb8c425

**status**: Active

**subject**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

**timing**: 2024 --> (ongoing)

**device**: [Device: identifier = https://www.gs1.org/gtin#GTIN Global Trade Item Number#8700000000001; type = implanteerbare cardioverter-defibrillator](Device-P2-ACP-MedicalDevice.Product-ICD.md)

**bodySite**: structuur van cor

**note**: 

> 

ICD is ongeveer eén jaar geleden geïmplanteerd.




## Resource Content

```json
{
  "resourceType" : "DeviceUseStatement",
  "id" : "P2-ACP-MedicalDevice-ICD",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-MedicalDevice"
    ]
  },
  "extension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-MedicalDevice.HealthProfessional",
      "valueReference" : {
        "reference" : "PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-Santos",
        "display" : "Healthcare professional, Santos"
      }
    },
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/P2-ACP-Encounter-07-08-2025",
        "display" : "Encounter, 2025-08-07"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "3fdc0ec5-2984-4b47-b6b8-f9822fb8c425"
    }
  ],
  "status" : "active",
  "subject" : {
    "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
    "display" : "Patient, Samira van der Sluijs"
  },
  "timingPeriod" : {
    "start" : "2024"
  },
  "device" : {
    "reference" : "Device/P2-ACP-MedicalDevice.Product-ICD"
  },
  "bodySite" : {
    "extension" : [
      {
        "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-AnatomicalLocation.Laterality",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "7771000",
              "display" : "links"
            }
          ]
        }
      }
    ],
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "80891009",
        "display" : "structuur van cor"
      }
    ]
  },
  "note" : [
    {
      "text" : "ICD is ongeveer eén jaar geleden geïmplanteerd."
    }
  ]
}

```
