# P2 ACP TreatmentDirective 400231000146108 - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **P2 ACP TreatmentDirective 400231000146108**

## Example Consent: P2 ACP TreatmentDirective 400231000146108

Profile: [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)

**ext Comment**: Patiënt gaat dit volgende week met de cardioloog bespreken.

**ext Encounter Reference**: [Encounter, 2025-08-07](Encounter-P2-ACP-Encounter-07-08-2025.md)

**ext TreatmentDirective2.SpecificationOther**: Nee, nog geen besluit genomen

**identifier**: Resource identifier/0b7b1248-a209-4205-b1ab-c308efcce769

**status**: Active

**scope**: Treatment

**category**: Context-dependent procedure

**patient**: [Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

**dateTime**: 2025-08-07

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [https://wetten.overheid.nl/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://wetten.overheid.nl/) |

> **provision**
> **actor****role**:consenter**reference**:[Patient, Samira van der Sluijs](Patient-P2-ACP-Patient-SamiraVanDerSluijs.md)

> **actor****role**:consenter**reference**:[Healthcare professional (role), Desiree Wolters](PractitionerRole-P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters.md)
**code**:uitzetten van cardioverter-defibrillator in laatste levensfase (SNOMED CT - 400231000146108)



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "P2-ACP-TreatmentDirective-400231000146108",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective"
    ]
  },
  "extension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-Comment",
      "valueString" : "Patiënt gaat dit volgende week met de cardioloog bespreken."
    },
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/P2-ACP-Encounter-07-08-2025",
        "display" : "Encounter, 2025-08-07"
      }
    }
  ],
  "modifierExtension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/ext-TreatmentDirective2.SpecificationOther",
      "valueString" : "Nee, nog geen besluit genomen"
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "0b7b1248-a209-4205-b1ab-c308efcce769"
    }
  ],
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "treatment"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "129125009"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
    "display" : "Patient, Samira van der Sluijs"
  },
  "dateTime" : "2025-08-07",
  "policy" : [
    {
      "uri" : "https://wetten.overheid.nl/"
    }
  ],
  "provision" : {
    "actor" : [
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "Patient/P2-ACP-Patient-SamiraVanDerSluijs",
          "type" : "Patient",
          "display" : "Patient, Samira van der Sluijs"
        }
      },
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "PractitionerRole/P2-ACP-HealthProfessional-PractitionerRole-DesireeWolters",
          "type" : "PractitionerRole",
          "display" : "Healthcare professional (role), Desiree Wolters"
        }
      }
    ],
    "code" : [
      {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
            "code" : "OTH"
          }
        ],
        "text" : "uitzetten van cardioverter-defibrillator in laatste levensfase (SNOMED CT - 400231000146108)"
      }
    ]
  }
}

```
