# F2 ACP TreatmentDirective 305351004 - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F2 ACP TreatmentDirective 305351004**

## Example Consent: F2 ACP TreatmentDirective 305351004

Profile: [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)

**ext Encounter Reference**: [Encounter, 2020-10-01](Encounter-F1-ACP-Encounter-01-10-2020.md)

**identifier**: Resource identifier/d543b9f3-4b87-4f10-bbbb-1425d66f485c

**status**: Active

**scope**: Treatment

**category**: Context-dependent procedure

**patient**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**dateTime**: 2022-11-08

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [https://wetten.overheid.nl/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://wetten.overheid.nl/) |

> **provision****type**: Opt In
> **actor****role**:consenter**reference**:[Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

> **actor****role**:consenter**reference**:[Healthcare professional (role), van Huissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md)

> **actor****role**:consenter**reference**:[ContactPerson, Michiel Hartman](RelatedPerson-F1-ACP-ContactPerson-MichielHartman.md)
**code**:opname op intensive care



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "F2-ACP-TreatmentDirective-305351004",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective"
    ]
  },
  "extension" : [
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/F1-ACP-Encounter-01-10-2020",
        "display" : "Encounter, 2020-10-01"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "d543b9f3-4b87-4f10-bbbb-1425d66f485c"
    }
  ],
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "treatment"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "129125009"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "dateTime" : "2022-11-08",
  "policy" : [
    {
      "uri" : "https://wetten.overheid.nl/"
    }
  ],
  "provision" : {
    "type" : "permit",
    "actor" : [
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
          "type" : "Patient",
          "display" : "Patient, Hendrik Hartman"
        }
      },
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen",
          "type" : "PractitionerRole",
          "display" : "Healthcare professional (role), van Huissen"
        }
      },
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "RelatedPerson/F1-ACP-ContactPerson-MichielHartman",
          "type" : "RelatedPerson",
          "display" : "ContactPerson, Michiel Hartman"
        }
      }
    ],
    "code" : [
      {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "305351004",
            "display" : "opname op intensive care"
          }
        ]
      }
    ]
  }
}

```
