# F1 ACP TreatmentDirective 89666000 - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **F1 ACP TreatmentDirective 89666000**

## Example Consent: F1 ACP TreatmentDirective 89666000

Profile: [TreatmentDirective](StructureDefinition-ACP-TreatmentDirective.md)

**ext Encounter Reference**: [Encounter, 2020-10-01](Encounter-F1-ACP-Encounter-01-10-2020.md)

**identifier**: Resource identifier/943eff64-86a4-4057-b41c-08a849e244c4

**status**: Active

**scope**: Treatment

**category**: Context-dependent procedure

**patient**: [Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

**dateTime**: 2020-10-01

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [https://wetten.overheid.nl/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://wetten.overheid.nl/) |

> **provision****type**: Opt In
> **actor****role**:consenter**reference**:[Patient, Hendrik Hartman](Patient-F1-ACP-Patient-HendrikHartman.md)

> **actor****role**:consenter**reference**:[Healthcare professional (role), van Huissen](PractitionerRole-F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen.md)
**code**:cardiopulmonale resuscitatie



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "F1-ACP-TreatmentDirective-89666000",
  "meta" : {
    "profile" : [
      "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ACP-TreatmentDirective"
    ]
  },
  "extension" : [
    {
      "url" : "https://api.iknl.nl/docs/pzp/r4/StructureDefinition/ext-EncounterReference",
      "valueReference" : {
        "reference" : "Encounter/F1-ACP-Encounter-01-10-2020",
        "display" : "Encounter, 2020-10-01"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource identifier"
          }
        ]
      },
      "system" : "https://acme.com/fhir/NamingSystem/resource-business-identifier",
      "value" : "943eff64-86a4-4057-b41c-08a849e244c4"
    }
  ],
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "treatment"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "129125009"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
    "display" : "Patient, Hendrik Hartman"
  },
  "dateTime" : "2020-10-01",
  "policy" : [
    {
      "uri" : "https://wetten.overheid.nl/"
    }
  ],
  "provision" : {
    "type" : "permit",
    "actor" : [
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "Patient/F1-ACP-Patient-HendrikHartman",
          "type" : "Patient",
          "display" : "Patient, Hendrik Hartman"
        }
      },
      {
        "role" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "CONSENTER"
            }
          ]
        },
        "reference" : {
          "reference" : "PractitionerRole/F1-ACP-HealthProfessional-PractitionerRole-DrVanHuissen",
          "type" : "PractitionerRole",
          "display" : "Healthcare professional (role), van Huissen"
        }
      }
    ],
    "code" : [
      {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "89666000",
            "display" : "cardiopulmonale resuscitatie"
          }
        ]
      }
    ]
  }
}

```
