# Resource ACPActorProvider (Basic)



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "ACPActorProvider",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.url",
      "valueUri" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorProvider"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.version",
      "valueString" : "1.0.0-rc1"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.name",
      "valueString" : "ACPActorProvider"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.title",
      "valueString" : "ACP Actor Provider"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.status",
      "valueCode" : "active"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.date",
      "valueDateTime" : "2025-10-31T09:52:04+00:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.publisher",
      "valueString" : "IKNL"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.contact",
      "valueContactDetail" : {
        "name" : "IKNL",
        "telecom" : [
          {
            "system" : "url",
            "value" : "https://iknl.nl/"
          },
          {
            "system" : "email",
            "value" : "info@iknl.nl"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.description",
      "valueMarkdown" : "The ACP Actor Provider is a system that responds to data access requests for digital health and administrative information."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.jurisdiction"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.type",
      "valueCode" : "system"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.documentation",
      "valueMarkdown" : "The ACP Actor Provider is a system role fulfilled by a source information system (e.g., GP Information System (HIS), Electronic Patient Record (EPD), Electronic Client Record (ECD)). It is responsible for making the Advance Care Planning (ACP) information available in response to a request.\n\nIn the Dutch functional design, this role is identified as **PZPInformatieBeschikbaarstellendSysteem** with the code **PZP-PZPIB-FHIR**. This code is a composite of the use case (`PZP` - Proactieve Zorgplanning), the system role (`PZPIB` - PZP Informatie Beschikbaarstellend) and the standard for information exchange (`FHIR`).\n\nAn ACP Actor Provider:\n\n- **SHALL** correctly populate all obligation-marked elements if they know a value for the element.\n\n\n- **SHALL** populate the data-absent-reason extension when an element cannot be shared due to policy or technical constraints.\n\n\n\nThe obligation-marked elements are specified in ACP Actor Provider [obligation extension](https://hl7.org/fhir/extensions/StructureDefinition-obligation.html) on the element definition."
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "ActorDefinition"
      }
    ]
  }
}

```
