# Resource ACPActorConsulter (Basic)



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "ACPActorConsulter",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.url",
      "valueUri" : "https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.version",
      "valueString" : "1.0.0-rc1"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.name",
      "valueString" : "ACPActorConsulter"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.title",
      "valueString" : "ACP Actor Consulter"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.status",
      "valueCode" : "active"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.date",
      "valueDateTime" : "2025-10-31T09:52:04+00:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.publisher",
      "valueString" : "IKNL"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.contact",
      "valueContactDetail" : {
        "name" : "IKNL",
        "telecom" : [
          {
            "system" : "url",
            "value" : "https://iknl.nl/"
          },
          {
            "system" : "email",
            "value" : "info@iknl.nl"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.description",
      "valueMarkdown" : "The ACP Actor Consulter is a system that creates and initiates a data access request to retrieve digital health and administrative information."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.jurisdiction"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.type",
      "valueCode" : "system"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.documentation",
      "valueMarkdown" : "The ACP Actor Consulter is a system role fulfilled by a consulting information system (e.g., GP Information System (HIS), Electronic Patient Record (EPD), Electronic Client Record (ECD)). It is responsible for initiating the transaction to retrieve Advance Care Planning (ACP) information.\n\nIn the Dutch functional design, this role is identified as **PZPInformatieRaadplegendSysteem** with the code **PZP-PZPIR-FHIR**. This code is a composite of the use case (`PZP` - Proactieve Zorgplanning), the system role (`PZPIR` - PZP Informatie Raadplegend) and the standard for information exchange (`FHIR`).\n\nAn ACP Actor Consulter:\n\n- **SHALL** accept resources containing obligation-marked elements without error\n\n \n- **SHALL** accept resources containing obligation-marked elements with missing data (e.g., usage of data-absent-reason extension) without error.\n\n\n\nHow the system processes the resource depends on local requirements that could align with obligation terms such as [reject invalid](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-reject-invalid), \n[correctly handle](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-handle), \n[persist](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-persist), \n[display](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-display), \nor [ignore](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-ignore).\n\n\n\n The obligation-marked elements are specified in the ACP Actor Consulter [obligation extension](https://hl7.org/fhir/extensions/StructureDefinition-obligation.html) on the element definition."
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "ActorDefinition"
      }
    ]
  }
}

```
