# ACP Actor Consulter - Advance Care Planning (PZP) v1.0.0-rc1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ACP Actor Consulter**

## ActorDefinition: ACP Actor Consulter 

| | |
| :--- | :--- |
| *Official URL*:https://api.iknl.nl/docs/pzp/r4/ActorDefinition/ACPActorConsulter | *Version*:1.0.0-rc1 |
| Active as of 2025-10-31 | *Computable Name*:ACPActorConsulter |

 
The ACP Actor Consulter is a system that creates and initiates a data access request to retrieve digital health and administrative information. 

* **Actor: ACPActorConsulter**: The ACP Actor Consulter is a system role fulfilled by a consulting information system (e.g., GP Information System (HIS), Electronic Patient Record (EPD), Electronic Client Record (ECD)). It is responsible for initiating the transaction to retrieve Advance Care Planning (ACP) information.In the Dutch functional design, this role is identified as **PZPInformatieRaadplegendSysteem** with the code **PZP-PZPIR-FHIR**. This code is a composite of the use case (`PZP` - Proactieve Zorgplanning), the system role (`PZPIR` - PZP Informatie Raadplegend) and the standard for information exchange (`FHIR`).An ACP Actor Consulter:* **SHALL** accept resources containing obligation-marked elements without error
* **SHALL** accept resources containing obligation-marked elements with missing data (e.g., usage of data-absent-reason extension) without error.
How the system processes the resource depends on local requirements that could align with obligation terms such as [reject invalid](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-reject-invalid), [correctly handle](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-handle), [persist](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-persist), [display](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-display), or [ignore](https://hl7.org/fhir/extensions/CodeSystem-obligation.html#obligation-ignore).The obligation-marked elements are specified in the ACP Actor Consulter [obligation extension](https://hl7.org/fhir/extensions/StructureDefinition-obligation.html) on the element definition.

