# Artifacts Summary - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

## Artifacts Summary

Contents:

*  [Behavior: Capability Statements](#1) 
*  [Structures: Abstract Profiles](#2) 
*  [Structures: Resource Profiles](#3) 
*  [Terminology: Value Sets](#4) 
*  [Terminology: Code Systems](#5) 
*  [Example: Example Instances](#6) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Guideline Engine](CapabilityStatement-IHE.CCG.GuidelineEngine.md) | IHE QRPH Computable Care Guidelines (CCG) - Guideline Engine. |
| [Guideline Performer](CapabilityStatement-IHE.CCG.GuidelinePerformer.md) | IHE QRPH Computable Care Guidelines (CCG) - Guideline Performer. |

### Structures: Abstract Profiles 

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles **based** on these abstract profiles but do not declare conformance to the abstract profiles themselves.

| | |
| :--- | :--- |
| [Base CARD PlanDefinition](StructureDefinition-ccg-card-pd-base.md) | Profile to serve as the basis for all CARD PlanDefinitions based on the CPG Computable PlanDefinition |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Activity Definition for the Administer Medication CARD](StructureDefinition-ccg-card-adminrx-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Collect Information CARD](StructureDefinition-ccg-card-collect-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Dispense Medication CARD](StructureDefinition-ccg-card-disprx-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Order Medication CARD](StructureDefinition-ccg-card-orderrx-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Propose a Diagnosis CARD](StructureDefinition-ccg-card-proposedx-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Provide Information CARD](StructureDefinition-ccg-card-provide-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Request Immunization CARD](StructureDefinition-ccg-card-reqvx-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Request a Service (Lab Order) CARD](StructureDefinition-ccg-card-reqlabs-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Request a Service (Procedure Order) CARD](StructureDefinition-ccg-card-reqprocserv-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Request a Service (Radiology Order) CARD](StructureDefinition-ccg-card-reqradserv-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Request a Service (Referral) CARD](StructureDefinition-ccg-card-reqrefserv-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Stop Activity (Medication Order) CARD](StructureDefinition-ccg-card-stoprx-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [Activity Definition for the Stop Activity (Service Order) CARD](StructureDefinition-ccg-card-stopsrv-ad.md) | Simple profile to inherit the base and set topic to the appropriate CARD |
| [CCG CARD Digital Signature](StructureDefinition-ccg-signature.md) | This is a profile on the FHIR Provenance resource to align with CCG requirements for signature |
| [CCG CARD Folder PlanDefinition](StructureDefinition-ccg-card-folder.md) | Each unique CCG will be expressed as a PlanDefinition (a CCG Folder) that lists the CCG's defined CARDs |
| [CCG CARD type - Administer Medication](StructureDefinition-ccg-card-adminrx.md) | The role of this type of CCG CARD is to record a medication administration for the patient. |
| [CCG CARD type - Collect Information](StructureDefinition-ccg-card-collect.md) | The role of this type of CCG CARD is to collect information about the patient. |
| [CCG CARD type - Dispense Medication](StructureDefinition-ccg-card-disprx.md) | The role of this type of CCG CARD is to create a medication dispensation for the patient. |
| [CCG CARD type - Order Medication](StructureDefinition-ccg-card-orderrx.md) | The role of this type of CCG CARD is to create a prescription / medication order for the patient. |
| [CCG CARD type - Propose a Diagnosis](StructureDefinition-ccg-card-proposedx.md) | The role of this type of CCG CARD is to propose a diagnosis of health conditions; it content about the patient. |
| [CCG CARD type - Provide Information](StructureDefinition-ccg-card-provide.md) | The role of this type of CCG CARD is to provide information, counselling, or instructions to the patient. |
| [CCG CARD type - Request Immunization](StructureDefinition-ccg-card-reqvx.md) | The role of this type of CCG CARD is to recommend and record an immunization event for the patient. Importantly, this CARD does not create an order for a future planned immunization. |
| [CCG CARD type - Request a Service (Lab Order)](StructureDefinition-ccg-card-reqserv-labs.md) | The role of this type of CCG CARD is to create a laboratory / pathology ServiceRequest for the patient. |
| [CCG CARD type - Request a Service (Procedure Order)](StructureDefinition-ccg-card-reqprocserv.md) | The role of this type of CCG CARD is to create a procedure ServiceRequest for the patient. |
| [CCG CARD type - Request a Service (Radiology Order)](StructureDefinition-ccg-card-reqradserv.md) | The role of this type of CCG CARD is to create a laboratory / pathology ServiceRequest for the patient. |
| [CCG CARD type - Request a Service (Referral)](StructureDefinition-ccg-card-reqrefserv.md) | The role of this type of CCG CARD is to create a procedure ServiceRequest for the patient. |
| [CCG CARD type - Stop Activity (Medication Order)](StructureDefinition-ccg-card-stoprx.md) | The role of this type of CCG CARD is to create a Task that, upon being processed, will “stop” a patient’s presently active MedicationRequest (i.e. set status to stopped). |
| [CCG CARD type - Stop Activity (Service Order)](StructureDefinition-ccg-card-stopsrv.md) | The role of this type of CCG CARD is to create a Task that, upon being processed, will “stop” a patient&apos;s presently active ServiceRequest (i.e. set status to revoked). |
| [CCG Data In Bundle](StructureDefinition-ccg-di-bundle.md) | CCG Data Input Bundle. A container for a collection of resources that is passed as part of the Apply Guideline transaction submission. This bundle represents the content that will be used by the Guideline Engine to evaluate all relevant CCG CARD&amp;s condition statements during the $apply operation. |
| [CCG Data-In Bundle Encounter](StructureDefinition-ccg-di-encounter.md) | Identifies the Encounter to which the CCG Apply Guideline transaction is relevant. |
| [CCG Data-In Bundle IPS CarePlan Specific Resource](StructureDefinition-ccg-data-in-ips-careplan.md) | This is a CarePlan profile that forces at least one of the activity.definitionCanonical to be a CARD Folder |
| [CCG Data-In Bundle IPS Composition Resource](StructureDefinition-ccg-di-ips-composition.md) | IPS Composition Resource Profiled for use with CCG |
| [CCG Data-In Bundle Location](StructureDefinition-ccg-di-location.md) | Location of the Encounter in the Data-in Bundle |
| [CCG Data-In Bundle Organization](StructureDefinition-ccg-di-organization.md) | Organization relevant to the current Encounter |
| [CCG Data-In Bundle Practitioner](StructureDefinition-ccg-di-practitioner.md) | Identifies the Practitioner initiating the CCG Apply Guideline transaction |
| [CCG Data-In Bundle PractitionerRole](StructureDefinition-ccg-di-practitionerrole.md) | Role of the Practitioner in the Data-in Bundle |
| [CCG Deployment Package (IG)](StructureDefinition-ccg-deployment.md) | The deployment model is that each unique CCG Folder and its contents will be contained in a FHIR package. |
| [CCG IPS Bundle](StructureDefinition-ccg-di-ips-bundle.md) | This bundle follows the IPS Bundle with the exception of using the CCG Composition |
| [CCG Library for CARDs](StructureDefinition-ccg-card-library.md) | Profile to serve as the basis for all CARD definitions referencing Library resources based on the CPG CQL Library |
| [CCG Patient Plans (patient-specific) PlanDefinition](StructureDefinition-ccg-patient-plans.md) | A patient-specific PlanDefinition holds the list of one or more applicable CCG Folders. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AllowedSignature signatureFormat](ValueSet-ccg-signature-sigformat.md) | Constraining to signature xml and json only |
| [AllowedSignature targetFormat](ValueSet-ccg-signature-target.md) | Constraining to fhir only |
| [ValueSet of all Current CCG Card Types](ValueSet-ccg-card-type.md) | This list includes all currently defined CCG CARD Types |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Code System for All CCG Card Types](CodeSystem-ccg-card-type-cs.md) | This CodeSystem defines all known CardTypes for use in CARD PlanDefinitions |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AD Administer Meds](ActivityDefinition-activity-example-administermedication-ad.md) | Example ActivityDefinition for Administer Medications CARD |
| [AD Collect info](ActivityDefinition-activity-example-collectinformation-ad.md) | Example ActivityDefinition for Collect Info CARD |
| [AD Dispense Meds](ActivityDefinition-activity-example-dispensemedication-ad.md) | Example ActivityDefinition for Dispense Medications CARD |
| [AD Order Meds](ActivityDefinition-activity-example-ordermedication-ad.md) | Example ActivityDefinition for Order Medications CARD |
| [AD Propose Diagnosis](ActivityDefinition-activity-example-proposediagnosis-ad.md) | Example ActivityDefinition for Propose Diagnosis CARD |
| [AD Provide Information](ActivityDefinition-activity-example-sendmessage-ad.md) | Example ActivityDefinition for Provide Information CARD |
| [AD Recommend Immunization](ActivityDefinition-activity-example-recommendimmunization-ad.md) | Example ActivityDefinition for Recommend Immunization CARD |
| [AD Service Request (Lab Order)](ActivityDefinition-activity-example-orderservice-lab-ad.md) | Example ActivityDefinition for Recommend Lab Order CARD |
| [AD Service Request (Procedure Order)](ActivityDefinition-activity-example-orderservice-proc-ad.md) | Example ActivityDefinition for Recommend Procedure Order CARD |
| [AD Service Request (Radiology Order)](ActivityDefinition-activity-example-orderservice-rad-ad.md) | Example ActivityDefinition for Recommend Radiology Order CARD |
| [AD Service Request (Referral Order)](ActivityDefinition-activity-example-orderservice-ref-ad.md) | Example ActivityDefinition for Recommend Referral Order CARD |
| [AD Stop Task (Medication Order)](ActivityDefinition-activity-example-stopmedication-ad.md) | Example ActivityDefinition for Stop Medication Order CARD |
| [AD Stop Task (Service Order)](ActivityDefinition-activity-example-stopservice-ad.md) | Example ActivityDefinition for Stop Service Order CARD |
| [CARD Administer Medication](PlanDefinition-card-example-adminrx.md) | Example CCG CARD to Administer Medication |
| [CARD Collect Information](PlanDefinition-card-example-collect.md) | Example CCG CARD to Collect Information |
| [CARD Digital Signature example](Provenance-example-ccg-CARD-signature.md) | Example FHIR Provenance resource for CARD digital signature |
| [CARD Dispense Medication](PlanDefinition-card-example-disprx.md) | Example CCG CARD to Dispense Medication |
| [CARD Order Medication](PlanDefinition-card-example-orderrx.md) | Example CCG CARD to Order Medication |
| [CARD Propose Diagnosis](PlanDefinition-card-example-propdx.md) | Example CCG CARD to Propose a Diagnosis |
| [CARD Provide Information](PlanDefinition-card-example-provide.md) | Example CCG CARD to Provide Information |
| [CARD Recommend Immunization](PlanDefinition-card-example-reqvx.md) | Example CCG CARD to Recommend an Immunization |
| [CARD Recommend Lab Order](PlanDefinition-card-example-reqlab.md) | Example CCG CARD to Recommend a Lab Order |
| [CARD Recommend Procedure Order](PlanDefinition-card-example-reqproc.md) | Example CCG CARD to Recommend a Procedure |
| [CARD Recommend Radiology Order](PlanDefinition-card-example-reqrad.md) | Example CCG CARD to Recommend a Radiology Order |
| [CARD Recommend Referral Order](PlanDefinition-card-example-reqref.md) | Example CCG CARD to Recommend a Referral Order |
| [CARD Stop Medication Order](PlanDefinition-card-example-stoprx.md) | Example CCG CARD to Recommend Stopping a Medication Order |
| [CARD Stop Service Order](PlanDefinition-card-example-stopsrv.md) | Example CCG CARD to Recommend Stopping a Service Order |
| [CCG Folder 1](PlanDefinition-ccg-folder-Diabetes.md) | Example CCG Folder - e.g. Diabetes |
| [CCG Folder 2](PlanDefinition-ccg-folder-Hypertension.md) | Example CCG Folder - e.g. Hypertension |
| [Data-in Care Plan](CarePlan-CCG-careplan-example.md) | Example CarePlan resource including a patient-speicific PlanDefinition (to reference applicable CCG Folders). |
| [Data-in Encounter](Encounter-Encounter-1234567.md) | Example in-progress outpatient encounter of normal priority |
| [Data-in Location](Location-Location-12.md) | Example Location (Standalone Primary Care Clinic) |
| [Data-in Organization](Organization-Organization-14.md) | Example organization providing family care services |
| [Data-in Patient](Patient-ZKT9319.md) | Example patient to which all the Data-in example content relates |
| [Data-in PlanDefinition for Patient CCGs](PlanDefinition-CCG-patient-plans-example.md) | An example person-centric PlanDefinition resource referencing applicable CCG Folders. |
| [Data-in Practitioner](Practitioner-Practitioner-123.md) | Example practitioner (Family Doctor) |
| [Data-in PractitionerRole](PractitionerRole-PractitionerRole-124.md) | Example practitionerRole (Family Doctor in a Family Practice setting) |

| | | |
| :--- | :--- | :--- |
|  [<prev](issues.md) | [top](#top) |  [next>](CapabilityStatement-IHE.CCG.GuidelineEngine.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

